/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsUninstallCommand;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.wscommands.NutsWorkspaceCommandBase;

public abstract class AbstractNutsUninstallCommand
extends NutsWorkspaceCommandBase<NutsUninstallCommand>
implements NutsUninstallCommand {
    private boolean erase = false;
    private List<String> args;
    private final List<NutsId> ids = new ArrayList<NutsId>();

    public AbstractNutsUninstallCommand(NutsWorkspace ws) {
        super(ws, "uninstall");
    }

    public NutsUninstallCommand addId(String id) {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        return this.addId(id == null ? null : ws.id().parser().parse(id));
    }

    public NutsUninstallCommand addId(NutsId id) {
        if (id == null) {
            this.checkSession();
            throw new NutsNotFoundException(this.getSession(), id);
        }
        this.ids.add(id);
        return this;
    }

    public NutsUninstallCommand addIds(String ... ids) {
        for (String id : ids) {
            this.addId(id);
        }
        return this;
    }

    public NutsUninstallCommand addIds(NutsId ... ids) {
        for (NutsId id : ids) {
            this.addId(id);
        }
        return this;
    }

    public NutsUninstallCommand removeId(NutsId id) {
        if (id != null) {
            this.ids.remove(id);
        }
        return this;
    }

    public NutsUninstallCommand removeId(String id) {
        this.checkSession();
        NutsWorkspace ws = this.getSession().getWorkspace();
        return this.removeId(ws.id().parser().parse(id));
    }

    public NutsUninstallCommand clearIds() {
        this.ids.clear();
        return this;
    }

    public NutsUninstallCommand clearArgs() {
        this.args = null;
        return this;
    }

    public String[] getArgs() {
        return this.args == null ? new String[]{} : this.args.toArray(new String[0]);
    }

    public NutsUninstallCommand addArg(String arg) {
        if (arg != null) {
            if (this.args == null) {
                this.args = new ArrayList<String>();
            }
            this.args.add(arg);
        }
        return this;
    }

    public NutsUninstallCommand addArgs(String ... args) {
        return this.addArgs(args == null ? null : Arrays.asList(args));
    }

    public NutsUninstallCommand addArgs(Collection<String> args) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        if (args != null) {
            for (String arg : args) {
                if (arg == null) continue;
                this.args.add(arg);
            }
        }
        return this;
    }

    public NutsId[] getIds() {
        return this.ids == null ? new NutsId[]{} : this.ids.toArray(new NutsId[0]);
    }

    public boolean isErase() {
        return this.erase;
    }

    public NutsUninstallCommand setErase(boolean erase) {
        this.erase = erase;
        return this;
    }

    @Override
    public boolean configureFirst(NutsCommandLine cmdLine) {
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isEnabled();
        switch (a.getStringKey()) {
            case "-e": 
            case "--erase": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setErase(val);
                }
                return true;
            }
            case "-g": 
            case "--args": {
                while (cmdLine.hasNext()) {
                    String val = cmdLine.nextString(new String[0]).getStringValue();
                    if (!enabled) continue;
                    this.addArg(val);
                }
                return true;
            }
        }
        if (super.configureFirst(cmdLine)) {
            return true;
        }
        if (a.isOption()) {
            return false;
        }
        cmdLine.skip();
        this.addId(a.getString());
        return true;
    }
}

