/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.wscommands;

import java.io.File;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependencies;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyTreeNode;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsExecutionEntry;
import net.thevpc.nuts.NutsFetchCommand;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsInstallStatusFilter;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsResultList;
import net.thevpc.nuts.NutsSearchCommand;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.core.DefaultNutsClassLoader;
import net.thevpc.nuts.runtime.core.commands.ws.DefaultNutsQueryBaseOptions;
import net.thevpc.nuts.runtime.core.format.NutsDisplayProperty;
import net.thevpc.nuts.runtime.core.format.NutsFetchDisplayOptions;
import net.thevpc.nuts.runtime.core.format.NutsIdFormatHelper;
import net.thevpc.nuts.runtime.standalone.ext.DefaultNutsWorkspaceExtensionManager;
import net.thevpc.nuts.runtime.standalone.util.NutsClassLoaderUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsCollectionResult;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public abstract class AbstractNutsSearchCommand
extends DefaultNutsQueryBaseOptions<NutsSearchCommand>
implements NutsSearchCommand {
    protected final List<String> arch = new ArrayList<String>();
    protected final List<NutsId> ids = new ArrayList<NutsId>();
    protected final List<NutsId> lockedIds = new ArrayList<NutsId>();
    protected final List<String> scripts = new ArrayList<String>();
    protected final List<String> packaging = new ArrayList<String>();
    protected Comparator comparator;
    protected NutsDescriptorFilter descriptorFilter;
    protected NutsIdFilter idFilter;
    protected boolean latest = false;
    protected boolean distinct = false;
    protected boolean includeBasePackage = true;
    protected boolean sorted = false;
    protected Boolean defaultVersions = null;
    protected String execType = null;
    protected NutsVersion targetApiVersion = null;
    protected boolean printResult = false;
    protected NutsInstallStatusFilter installStatus;

    public AbstractNutsSearchCommand(NutsWorkspace ws) {
        super(ws, "search");
    }

    public NutsSearchCommand clearIds() {
        this.ids.clear();
        return this;
    }

    public NutsSearchCommand addId(String id) {
        this.checkSession();
        if (!NutsUtilStrings.isBlank((CharSequence)id)) {
            this.ids.add(this.getSession().getWorkspace().id().parser().setLenient(false).parse(id));
        }
        return this;
    }

    public NutsSearchCommand addId(NutsId id) {
        if (id != null) {
            this.ids.add(id);
        }
        return this;
    }

    public NutsSearchCommand addIds(String ... values) {
        this.checkSession();
        if (values != null) {
            for (String s : values) {
                if (NutsUtilStrings.isBlank((CharSequence)s)) continue;
                this.ids.add(this.getSession().getWorkspace().id().parser().setLenient(false).parse(s));
            }
        }
        return this;
    }

    public NutsSearchCommand addIds(NutsId ... value) {
        if (value != null) {
            for (NutsId s : value) {
                if (s == null) continue;
                this.ids.add(s);
            }
        }
        return this;
    }

    public NutsSearchCommand removeId(String id) {
        this.checkSession();
        this.ids.remove(this.getSession().getWorkspace().id().parser().parse(id));
        return this;
    }

    public NutsSearchCommand removeId(NutsId id) {
        if (id != null) {
            this.removeId(id.toString());
        }
        return this;
    }

    public boolean isRuntime() {
        return "runtime".equals(this.execType);
    }

    public NutsSearchCommand setRuntime(boolean enable) {
        this.execType = enable ? "runtime" : null;
        return this;
    }

    public boolean isCompanion() {
        return "companion".equals(this.execType);
    }

    public NutsSearchCommand setCompanion(boolean enable) {
        this.execType = enable ? "companion" : null;
        return this;
    }

    public boolean isExtension() {
        return "extension".equals(this.execType);
    }

    public NutsSearchCommand setExtension(boolean enable) {
        this.execType = enable ? "extension" : null;
        return this;
    }

    public boolean isExec() {
        return "exec".equals(this.execType);
    }

    public NutsSearchCommand setExec(boolean enable) {
        this.execType = enable ? "exec" : null;
        return this;
    }

    public boolean isApplication() {
        return "app".equals(this.execType);
    }

    public NutsSearchCommand setApplication(boolean enable) {
        this.execType = enable ? "app" : null;
        return this;
    }

    public boolean isLib() {
        return "lib".equals(this.execType);
    }

    public NutsSearchCommand setLib(boolean enable) {
        this.execType = enable ? "lib" : null;
        return this;
    }

    public NutsSearchCommand addScript(String value) {
        if (value != null) {
            this.scripts.add(value);
        }
        return this;
    }

    public NutsSearchCommand removeScript(String value) {
        this.scripts.remove(value);
        return this;
    }

    public NutsSearchCommand addScripts(Collection<String> value) {
        if (value != null) {
            this.addScripts(value.toArray(new String[0]));
        }
        return this;
    }

    public NutsSearchCommand addScripts(String ... value) {
        if (value != null) {
            this.scripts.addAll(Arrays.asList(value));
        }
        return this;
    }

    public NutsSearchCommand clearScripts() {
        this.scripts.clear();
        return this;
    }

    public String[] getScripts() {
        return this.scripts.toArray(new String[0]);
    }

    public NutsSearchCommand clearArchs() {
        this.arch.clear();
        return this;
    }

    public NutsSearchCommand addLockedIds(String ... values) {
        this.checkSession();
        if (values != null) {
            for (String s : values) {
                if (NutsUtilStrings.isBlank((CharSequence)s)) continue;
                this.lockedIds.add(this.getSession().getWorkspace().id().parser().setLenient(false).parse(s));
            }
        }
        return this;
    }

    public NutsSearchCommand addLockedIds(NutsId ... values) {
        if (values != null) {
            for (NutsId s : values) {
                if (s == null) continue;
                this.lockedIds.add(s);
            }
        }
        return this;
    }

    public NutsSearchCommand clearLockedIds() {
        this.lockedIds.clear();
        return this;
    }

    public NutsSearchCommand addArch(String value) {
        if (!NutsUtilStrings.isBlank((CharSequence)value)) {
            this.arch.add(value);
        }
        return this;
    }

    public NutsSearchCommand removeArch(String value) {
        this.arch.remove(value);
        return this;
    }

    public NutsSearchCommand addArchs(Collection<String> values) {
        if (values != null) {
            this.addArchs(values.toArray(new String[0]));
        }
        return this;
    }

    public NutsSearchCommand addArchs(String ... values) {
        if (values != null) {
            this.arch.addAll(Arrays.asList(values));
        }
        return this;
    }

    public NutsSearchCommand clearPackagings() {
        this.packaging.clear();
        return this;
    }

    public NutsSearchCommand addPackagings(Collection<String> values) {
        if (values != null) {
            this.addPackagings(values.toArray(new String[0]));
        }
        return this;
    }

    public NutsSearchCommand addPackagings(String ... values) {
        if (values != null) {
            this.packaging.addAll(Arrays.asList(values));
        }
        return this;
    }

    public NutsSearchCommand addPackaging(String value) {
        if (value != null) {
            this.packaging.add(value);
        }
        return this;
    }

    public NutsSearchCommand removePackaging(String value) {
        this.packaging.remove(value);
        return this;
    }

    public NutsSearchCommand addLockedId(NutsId id) {
        if (id != null) {
            this.addLockedId(id.toString());
        }
        return this;
    }

    public NutsSearchCommand removeLockedId(NutsId id) {
        if (id != null) {
            this.removeLockedId(id.toString());
        }
        return this;
    }

    public NutsSearchCommand removeLockedId(String id) {
        this.checkSession();
        this.lockedIds.remove(this.getSession().getWorkspace().id().parser().parse(id));
        return this;
    }

    public NutsSearchCommand addLockedId(String id) {
        this.checkSession();
        if (!NutsUtilStrings.isBlank((CharSequence)id)) {
            this.lockedIds.add(this.getSession().getWorkspace().id().parser().setLenient(false).parse(id));
        }
        return this;
    }

    public NutsId[] getLockedIds() {
        return this.lockedIds.toArray(new NutsId[0]);
    }

    public NutsSearchCommand sort(Comparator comparator) {
        this.comparator = comparator;
        this.sorted = true;
        return this;
    }

    public NutsSearchCommand copyFrom(NutsSearchCommand other) {
        super.copyFromDefaultNutsQueryBaseOptions((DefaultNutsQueryBaseOptions)other);
        if (other != null) {
            NutsSearchCommand o = other;
            this.comparator = o.getComparator();
            this.descriptorFilter = o.getDescriptorFilter();
            this.idFilter = o.getIdFilter();
            this.latest = o.isLatest();
            this.distinct = o.isDistinct();
            this.includeBasePackage = o.isBasePackage();
            this.sorted = o.isSorted();
            this.arch.clear();
            this.arch.addAll(Arrays.asList(o.getArch()));
            this.ids.clear();
            this.ids.addAll(Arrays.asList(o.getIds()));
            this.scripts.clear();
            this.scripts.addAll(Arrays.asList(o.getScripts()));
            this.packaging.clear();
            this.packaging.addAll(Arrays.asList(o.getPackaging()));
            this.printResult = o.isPrintResult();
            this.installStatus = other.getInstallStatus();
        }
        return this;
    }

    public NutsSearchCommand copyFrom(NutsFetchCommand other) {
        super.copyFromDefaultNutsQueryBaseOptions((DefaultNutsQueryBaseOptions)other);
        return this;
    }

    public NutsId[] getIds() {
        return this.ids.toArray(new NutsId[0]);
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public NutsSearchCommand setSorted(boolean sort) {
        this.sorted = sort;
        return this;
    }

    public NutsDescriptorFilter getDescriptorFilter() {
        return this.descriptorFilter;
    }

    public NutsSearchCommand setDescriptorFilter(NutsDescriptorFilter filter) {
        this.descriptorFilter = filter;
        return this;
    }

    public NutsSearchCommand setDescriptorFilter(String filter) {
        this.checkSession();
        this.descriptorFilter = this.getSession().getWorkspace().descriptor().filter().byExpression(filter);
        return this;
    }

    public NutsIdFilter getIdFilter() {
        return this.idFilter;
    }

    public NutsSearchCommand setIdFilter(NutsIdFilter filter) {
        this.idFilter = filter;
        return this;
    }

    public NutsSearchCommand setIdFilter(String filter) {
        this.checkSession();
        this.idFilter = this.getSession().getWorkspace().id().filter().byExpression(filter);
        return this;
    }

    public String[] getArch() {
        return this.arch.toArray(new String[0]);
    }

    public String[] getPackaging() {
        return this.packaging.toArray(new String[0]);
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public NutsSearchCommand setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public NutsVersion getTargetApiVersion() {
        return this.targetApiVersion;
    }

    public NutsSearchCommand setTargetApiVersion(NutsVersion targetApiVersion) {
        this.targetApiVersion = targetApiVersion;
        return this;
    }

    public boolean isBasePackage() {
        return this.includeBasePackage;
    }

    public NutsSearchCommand setBasePackage(boolean includeBasePackage) {
        this.includeBasePackage = includeBasePackage;
        return this;
    }

    public boolean isLatest() {
        return this.latest;
    }

    public NutsSearchCommand setLatest(boolean enable) {
        this.latest = enable;
        return this;
    }

    public NutsResultList<NutsId> getResultIds() {
        return this.buildCollectionResult(this.getResultIdIteratorBase(null));
    }

    public NutsResultList<NutsDependencies> getResultDependencies() {
        return this.postProcessResult(IteratorBuilder.of(this.getResultDefinitionIteratorBase(true, this.isEffective())).map(x -> x.getDependencies()));
    }

    public NutsResultList<NutsDependency> getResultInlineDependencies() {
        return this.buildCollectionResult(IteratorBuilder.of(this.getResultIdIteratorBase(true)).map(x -> x.toDependency(), "Id->Dependency").build());
    }

    public NutsResultList<NutsDefinition> getResultDefinitions() {
        return this.buildCollectionResult(this.getResultDefinitionIteratorBase(this.isContent(), this.isEffective()));
    }

    public ClassLoader getResultClassLoader() {
        return this.getResultClassLoader(null);
    }

    public ClassLoader getResultClassLoader(ClassLoader parent) {
        this.checkSession();
        this.setContent(true);
        this.setDependencies(true);
        List nutsDefinitions = this.getResultDefinitions().list();
        URL[] allURLs = new URL[nutsDefinitions.size()];
        NutsId[] allIds = new NutsId[nutsDefinitions.size()];
        for (int i = 0; i < allURLs.length; ++i) {
            allURLs[i] = ((NutsDefinition)nutsDefinitions.get(i)).getURL();
            allIds[i] = ((NutsDefinition)nutsDefinitions.get(i)).getId();
        }
        DefaultNutsClassLoader cl = ((DefaultNutsWorkspaceExtensionManager)this.getSession().getWorkspace().extensions()).getModel().getNutsURLClassLoader("SEARCH-" + UUID.randomUUID().toString(), parent, this.getSession());
        for (NutsDefinition def : nutsDefinitions) {
            cl.add(NutsClassLoaderUtils.definitionToClassLoaderNode(def, this.getSession()));
        }
        return cl;
    }

    public String getResultNutsPath() {
        return this.getResultIds().list().stream().map(NutsId::getLongName).collect(Collectors.joining(";"));
    }

    public String getResultClassPath() {
        StringBuilder sb = new StringBuilder();
        Iterator<NutsDefinition> it = this.getResultDefinitionIteratorBase(true, this.isEffective());
        while (it.hasNext()) {
            NutsDefinition nutsDefinition = it.next();
            if (nutsDefinition.getPath() == null) continue;
            if (sb.length() > 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(nutsDefinition.getPath());
        }
        return sb.toString();
    }

    public Boolean getDefaultVersions() {
        return this.defaultVersions;
    }

    public NutsSearchCommand setDefaultVersions(Boolean acceptDefaultVersion) {
        this.defaultVersions = acceptDefaultVersion;
        return this;
    }

    public NutsResultList<String> getResultPaths() {
        return this.postProcessResult(IteratorBuilder.of(this.getResultDefinitionIteratorBase(true, this.isEffective())).map(x -> x.getContent() == null || x.getContent().getPath() == null ? null : x.getContent().getPath().toString()).notBlank());
    }

    public NutsResultList<String> getResultPathNames() {
        return this.postProcessResult(IteratorBuilder.of(this.getResultDefinitionIteratorBase(true, this.isEffective())).map(x -> x.getContent() == null || x.getContent().getPath() == null ? null : x.getContent().getPath().getName()).notBlank());
    }

    public NutsResultList<Instant> getResultInstallDates() {
        return this.postProcessResult(IteratorBuilder.of(this.getResultDefinitionIteratorBase(this.isContent(), this.isEffective())).map(x -> x.getInstallInformation() == null ? null : x.getInstallInformation().getCreatedInstant()).notNull());
    }

    public NutsResultList<String> getResultInstallUsers() {
        return this.postProcessResult(IteratorBuilder.of(this.getResultDefinitionIteratorBase(this.isContent(), this.isEffective())).map(x -> x.getInstallInformation() == null ? null : x.getInstallInformation().getInstallUser()).notBlank());
    }

    public NutsResultList<String> getResultInstallFolders() {
        return this.postProcessResult(IteratorBuilder.of(this.getResultDefinitionIteratorBase(this.isContent(), this.isEffective())).map(x -> x.getInstallInformation() == null ? null : x.getInstallInformation().getInstallFolder()).notNull());
    }

    public NutsResultList<String> getResultStoreLocations(NutsStoreLocation location) {
        this.checkSession();
        return this.postProcessResult(IteratorBuilder.of(this.getResultDefinitionIteratorBase(this.isContent(), this.isEffective())).map(x -> this.getSession().getWorkspace().locations().getStoreLocation(x.getId(), location)).notNull());
    }

    public NutsResultList<String[]> getResultStrings(String[] columns) {
        NutsFetchDisplayOptions oo = new NutsFetchDisplayOptions(this.ws);
        oo.addDisplay(columns);
        oo.setIdFormat(this.getDisplayOptions().getIdFormat());
        return this.postProcessResult(IteratorBuilder.of(this.getResultDefinitionIteratorBase(this.isContent(), this.isEffective())).map(x -> NutsIdFormatHelper.of(x, this.getSearchSession()).buildLong().getMultiColumnRowStrings(oo)));
    }

    public NutsResultList<String> getResultNames() {
        return this.postProcessResult(IteratorBuilder.of(this.getResultDefinitionIteratorBase(this.isContent(), this.isEffective())).mapMulti(x -> Arrays.asList(x.getDescriptor().getName())).notBlank());
    }

    public NutsResultList<String> getResultOses() {
        return this.postProcessResult(IteratorBuilder.of(this.getResultDefinitionIteratorBase(this.isContent(), this.isEffective())).mapMulti(x -> Arrays.asList(x.getDescriptor().getOs())).notBlank().distinct());
    }

    public NutsResultList<NutsExecutionEntry> getResultExecutionEntries() {
        this.checkSession();
        return this.postProcessResult(IteratorBuilder.of(this.getResultDefinitionIteratorBase(this.isContent(), this.isEffective())).mapMulti(x -> x.getContent() == null || x.getContent().getFilePath() == null ? Collections.emptyList() : Arrays.asList(this.getSession().getWorkspace().apps().execEntries().setSession(this.getSession()).parse(x.getContent().getFilePath()))));
    }

    public NutsResultList<String> getResultOsdists() {
        return this.postProcessResult(IteratorBuilder.of(this.getResultDefinitionIteratorBase(this.isContent(), this.isEffective())).mapMulti(x -> Arrays.asList(x.getDescriptor().getOsdist())).notBlank().distinct());
    }

    public NutsResultList<String> getResultPackagings() {
        return this.postProcessResult(IteratorBuilder.of(this.getResultDefinitionIteratorBase(this.isContent(), this.isEffective())).mapMulti(x -> Arrays.asList(x.getDescriptor().getPackaging())).notBlank().distinct());
    }

    public NutsResultList<String> getResultPlatforms() {
        return this.postProcessResult(IteratorBuilder.of(this.getResultDefinitionIteratorBase(this.isContent(), this.isEffective())).mapMulti(x -> Arrays.asList(x.getDescriptor().getPlatform())).notBlank().distinct());
    }

    public NutsResultList<String> getResultArchs() {
        return this.postProcessResult(IteratorBuilder.of(this.getResultDefinitionIteratorBase(this.isContent(), this.isEffective())).mapMulti(x -> Arrays.asList(x.getDescriptor().getArch())).notBlank());
    }

    public boolean isPrintResult() {
        return this.printResult;
    }

    public NutsSearchCommand setPrintResult(boolean printResult) {
        this.printResult = printResult;
        return this;
    }

    public NutsInstallStatusFilter getInstallStatus() {
        return this.installStatus;
    }

    public NutsSearchCommand setInstallStatus(NutsInstallStatusFilter installStatus) {
        this.installStatus = installStatus;
        return this;
    }

    public String getExecType() {
        return this.execType;
    }

    @Override
    public boolean configureFirst(NutsCommandLine cmdLine) {
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isEnabled();
        switch (a.getStringKey()) {
            case "--inline-dependencies": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setInlineDependencies(val);
                }
                return true;
            }
            case "-L": 
            case "--latest": 
            case "--latest-versions": {
                cmdLine.skip();
                if (enabled) {
                    this.setLatest(true);
                }
                return true;
            }
            case "--distinct": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setDistinct(val);
                }
                return true;
            }
            case "--default": 
            case "--default-versions": {
                Boolean val = cmdLine.nextBoolean(new String[0]).getBoolean(null);
                if (enabled) {
                    this.setDefaultVersions(val);
                }
                return true;
            }
            case "--duplicates": {
                boolean val;
                boolean bl = val = !cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setDistinct(val);
                }
                return true;
            }
            case "-s": 
            case "--sort": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setSorted(val);
                }
                return true;
            }
            case "--base": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.includeBasePackage = val;
                }
                return true;
            }
            case "--lib": 
            case "--libs": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setLib(val);
                }
                return true;
            }
            case "--app": 
            case "--apps": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setExec(val);
                }
                return true;
            }
            case "--companion": 
            case "--companions": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setCompanion(val);
                }
                return true;
            }
            case "--extension": 
            case "--extensions": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setExtension(val);
                }
                return true;
            }
            case "--runtime": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setRuntime(val);
                }
                return true;
            }
            case "--api-version": {
                String val = cmdLine.nextBoolean(new String[0]).getStringValue();
                if (enabled) {
                    this.setTargetApiVersion(this.getSession().getWorkspace().version().parse(val));
                }
                return true;
            }
            case "--nuts-app": 
            case "--nuts-apps": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setApplication(val);
                }
                return true;
            }
            case "--arch": {
                String val = cmdLine.nextString(new String[0]).getStringValue();
                if (enabled) {
                    this.addArch(val);
                }
                return true;
            }
            case "--packaging": {
                String val = cmdLine.nextString(new String[0]).getStringValue();
                if (enabled) {
                    this.addPackaging(val);
                }
                return true;
            }
            case "--optional": {
                NutsArgument val = cmdLine.nextString(new String[0]);
                if (enabled) {
                    this.setOptional(NutsUtilStrings.parseBoolean((String)val.getStringValue(), null, null));
                }
                return true;
            }
            case "--script": {
                String val = cmdLine.nextString(new String[0]).getStringValue();
                if (enabled) {
                    this.addScript(val);
                }
                return true;
            }
            case "--id": {
                String val = cmdLine.nextString(new String[0]).getStringValue();
                if (enabled) {
                    this.addId(val);
                }
                return true;
            }
            case "--locked-id": {
                String val = cmdLine.nextString(new String[0]).getStringValue();
                if (enabled) {
                    this.addLockedId(val);
                }
                return true;
            }
            case "--print": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setPrintResult(val);
                }
                return true;
            }
            case "--deployed": {
                NutsArgument b = cmdLine.nextBoolean(new String[0]);
                if (enabled) {
                    this.checkSession();
                    this.setInstallStatus(this.getSession().getWorkspace().filters().installStatus().byDeployed(b.getBooleanValue()));
                }
                return true;
            }
            case "-i": 
            case "--installed": {
                NutsArgument b = cmdLine.nextBoolean(new String[0]);
                if (enabled) {
                    this.checkSession();
                    this.setInstallStatus(this.getSession().getWorkspace().filters().installStatus().byInstalled(b.getBooleanValue()));
                }
                return true;
            }
            case "--required": {
                NutsArgument b = cmdLine.nextBoolean(new String[0]);
                if (enabled) {
                    this.checkSession();
                    this.setInstallStatus(this.getSession().getWorkspace().filters().installStatus().byRequired(b.getBooleanValue()));
                }
                return true;
            }
            case "--obsolete": {
                NutsArgument b = cmdLine.nextBoolean(new String[0]);
                if (enabled) {
                    this.checkSession();
                    this.setInstallStatus(this.getSession().getWorkspace().filters().installStatus().byObsolete(b.getBooleanValue()));
                }
                return true;
            }
            case "--status": {
                NutsArgument aa = cmdLine.nextString(new String[0]);
                if (enabled) {
                    this.checkSession();
                    this.setInstallStatus((NutsInstallStatusFilter)this.getSession().getWorkspace().filters().installStatus().parse(aa.getStringValue()));
                }
                return true;
            }
        }
        if (super.configureFirst(cmdLine)) {
            return true;
        }
        if (a.isOption()) {
            return false;
        }
        cmdLine.skip();
        this.addId(a.getString());
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{failFast=" + this.isFailFast() + ", optional=" + this.getOptional() + ", scope=" + this.getScope() + ", content=" + this.isContent() + ", inlineDependencies=" + this.isInlineDependencies() + ", dependencies=" + this.isDependencies() + ", effective=" + this.isEffective() + ", location=" + this.getLocation() + ", displayOptions=" + this.getDisplayOptions() + ", comparator=" + this.getComparator() + ", dependencyFilter=" + this.getDependencyFilter() + ", descriptorFilter=" + this.getDescriptorFilter() + ", idFilter=" + this.getIdFilter() + ", repositoryFilter=" + this.getRepositoryFilter() + ", latest=" + this.isLatest() + ", distinct=" + this.isDistinct() + ", includeMain=" + this.isBasePackage() + ", sorted=" + this.isSorted() + ", arch=" + Arrays.toString(this.getArch()) + ", ids=" + Arrays.toString(this.getIds()) + ", lockedIds=" + Arrays.toString(this.getLockedIds()) + ", scripts=" + Arrays.toString(this.getScripts()) + ", packaging=" + Arrays.toString(this.getPackaging()) + ", defaultVersions=" + this.getDefaultVersions() + ", execType='" + this.getExecType() + '\'' + ", targetApiVersion='" + this.getTargetApiVersion() + '\'' + '}';
    }

    private Object dependenciesToElement(NutsDependencyTreeNode d) {
        List li;
        NutsId id = d.getDependency().toId();
        if (d.isPartial()) {
            id = id.builder().setProperty("partial", "true").build();
        }
        if ((li = Arrays.asList(d.getChildren()).stream().map(x -> this.dependenciesToElement((NutsDependencyTreeNode)x)).collect(Collectors.toList())).isEmpty()) {
            return id;
        }
        HashMap o = new HashMap();
        o.put(id, li);
        return o;
    }

    public NutsSearchCommand run() {
        this.checkSession();
        NutsDisplayProperty[] a = this.getDisplayOptions().getDisplayProperties();
        Object r = null;
        if (this.isDependencies() && !this.isInlineDependencies()) {
            NutsContentType of = this.getSearchSession().getOutputFormat();
            if (of == null) {
                of = NutsContentType.TREE;
            }
            switch (of) {
                case JSON: 
                case TSON: 
                case XML: 
                case YAML: 
                case TREE: {
                    Iterator<Object> it = IteratorBuilder.of(this.getResultDefinitionIteratorBase(this.isContent(), this.isEffective())).flatMap(x -> x.getDependencies().nodes().iterator()).map(x -> this.dependenciesToElement((NutsDependencyTreeNode)x)).build();
                    it = NutsWorkspaceUtils.of(this.getSearchSession()).decoratePrint(it, this.getSearchSession(), this.getDisplayOptions());
                    while (it.hasNext()) {
                        it.next();
                    }
                    break;
                }
                default: {
                    NutsResultList<NutsDependency> rr = this.getResultInlineDependencies();
                    Iterator it = NutsWorkspaceUtils.of(this.getSearchSession()).decoratePrint(rr.iterator(), this.getSearchSession(), this.getDisplayOptions());
                    while (it.hasNext()) {
                        it.next();
                    }
                    break block0;
                }
            }
            return this;
        }
        if (a.length == 0) {
            r = this.getResultIds();
        } else if (a.length == 1) {
            switch (a[0]) {
                case ARCH: {
                    r = this.getResultArchs();
                    break;
                }
                case FILE: {
                    r = this.getResultPaths();
                    break;
                }
                case FILE_NAME: {
                    r = this.getResultPathNames();
                    break;
                }
                case NAME: {
                    r = this.getResultNames();
                    break;
                }
                case PACKAGING: {
                    r = this.getResultPackagings();
                    break;
                }
                case PLATFORM: {
                    r = this.getResultPlatforms();
                    break;
                }
                case EXEC_ENTRY: {
                    r = this.getResultExecutionEntries();
                    break;
                }
                case OS: {
                    r = this.getResultOses();
                    break;
                }
                case OSDIST: {
                    r = this.getResultOsdists();
                    break;
                }
                case ID: {
                    r = this.getResultIds();
                    break;
                }
                case INSTALL_DATE: {
                    r = this.getResultInstallDates();
                    break;
                }
                case INSTALL_USER: {
                    r = this.getResultInstallUsers();
                    break;
                }
                case INSTALL_FOLDER: {
                    r = this.getResultInstallFolders();
                    break;
                }
                case APPS_FOLDER: {
                    r = this.getResultStoreLocations(NutsStoreLocation.APPS);
                    break;
                }
                case CACHE_FOLDER: {
                    r = this.getResultStoreLocations(NutsStoreLocation.CACHE);
                    break;
                }
                case CONFIG_FOLDER: {
                    r = this.getResultStoreLocations(NutsStoreLocation.CONFIG);
                    break;
                }
                case LIB_FOLDER: {
                    r = this.getResultStoreLocations(NutsStoreLocation.LIB);
                    break;
                }
                case LOG_FOLDER: {
                    r = this.getResultStoreLocations(NutsStoreLocation.LOG);
                    break;
                }
                case TEMP_FOLDER: {
                    r = this.getResultStoreLocations(NutsStoreLocation.TEMP);
                    break;
                }
                case VAR_LOCATION: {
                    r = this.getResultStoreLocations(NutsStoreLocation.VAR);
                    break;
                }
                case STATUS: {
                    r = this.getResultStatuses();
                }
            }
        }
        if (r == null) {
            boolean _content = this.isContent();
            boolean _effective = this.isEffective();
            block33: for (NutsDisplayProperty display : this.getDisplayOptions().getDisplayProperties()) {
                switch (display) {
                    case ARCH: 
                    case NAME: 
                    case PACKAGING: 
                    case PLATFORM: 
                    case OS: 
                    case OSDIST: {
                        continue block33;
                    }
                    case FILE: 
                    case FILE_NAME: 
                    case EXEC_ENTRY: {
                        continue block33;
                    }
                    case INSTALL_DATE: 
                    case INSTALL_USER: {
                        continue block33;
                    }
                }
            }
            r = this.buildCollectionResult(this.getResultDefinitionIteratorBase(_content, _effective));
        }
        Iterator it = NutsWorkspaceUtils.of(this.getSearchSession()).decoratePrint(r.iterator(), this.getSearchSession(), this.getDisplayOptions());
        while (it.hasNext()) {
            it.next();
        }
        return this;
    }

    public Iterator<NutsDefinition> getResultDefinitionIteratorBase(boolean content, boolean effective) {
        NutsFetchCommand fetch = this.toFetch().setContent(content).setEffective(effective);
        NutsFetchCommand ofetch = this.toFetch().setContent(content).setEffective(effective).setSession(this.getSession().copy().setFetchStrategy(NutsFetchStrategy.OFFLINE));
        boolean hasRemote = this.getSession().getFetchStrategy() == null || Arrays.stream(this.getSession().getFetchStrategy().modes()).anyMatch(x -> x == NutsFetchMode.REMOTE);
        return IteratorBuilder.of(this.getResultIdIteratorBase(null)).convert(next -> {
            NutsDefinition d = fetch.setId(next).getResultDefinition();
            if (d == null) {
                if (this.isFailFast()) {
                    throw new NutsNotFoundException(this.getSession(), next);
                }
                return d;
            }
            return d;
        }, "Id->Definition").notNull().build();
    }

    protected <T> NutsCollectionResult<T> buildCollectionResult(Iterator<T> o) {
        NutsSession ss = this.getSearchSession();
        return new NutsCollectionResult<T>(ss, this.resolveFindIdBase(), o);
    }

    protected String resolveFindIdBase() {
        return this.ids.isEmpty() ? null : (this.ids.get(0) == null ? null : this.ids.get(0).toString());
    }

    public NutsResultList<String> getResultStatuses() {
        return this.postProcessResult(IteratorBuilder.of(this.getResultDefinitionIteratorBase(this.isContent(), this.isEffective())).map(x -> NutsIdFormatHelper.of(x, this.getSearchSession()).buildLong().getStatusString()).notBlank());
    }

    protected abstract Iterator<NutsId> getResultIdIteratorBase(Boolean var1);

    protected NutsCollectionResult<NutsId> getResultIdsBase(boolean sort) {
        return this.buildCollectionResult(this.getResultIdIteratorBase(null));
    }

    protected <T> NutsResultList<T> postProcessResult(IteratorBuilder<T> a) {
        if (this.isSorted()) {
            a = a.sort(null, this.isDistinct());
        }
        return this.buildCollectionResult(a.build());
    }

    protected NutsSession getSearchSession() {
        return this.getSession();
    }

    protected Iterator<NutsId> applyPrintDecoratorIterOfNutsId(Iterator<NutsId> curr, boolean print) {
        return print ? NutsWorkspaceUtils.of(this.getSearchSession()).decoratePrint(curr, this.getSearchSession(), this.getDisplayOptions()) : curr;
    }

    public NutsSearchCommand setId(String id) {
        this.clearIds();
        this.addId(id);
        return this;
    }

    public NutsSearchCommand setId(NutsId id) {
        this.clearIds();
        this.addId(id);
        return this;
    }

    public NutsSearchCommand setIds(String ... ids) {
        this.clearIds();
        this.addIds(ids);
        return this;
    }

    public NutsSearchCommand setIds(NutsId ... ids) {
        this.clearIds();
        this.addIds(ids);
        return this;
    }
}

