/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFormat;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsExecutionEntry;
import net.thevpc.nuts.NutsFetchCommand;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFormat;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInstallEvent;
import net.thevpc.nuts.NutsInstallListener;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsReadOnlyException;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryAlreadyRegisteredException;
import net.thevpc.nuts.NutsRepositoryFilter;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionAware;
import net.thevpc.nuts.NutsUpdateEvent;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceEvent;
import net.thevpc.nuts.NutsWorkspaceListener;
import net.thevpc.nuts.runtime.bundles.common.CorePlatformUtils;
import net.thevpc.nuts.runtime.bundles.http.SimpleHttpClient;
import net.thevpc.nuts.runtime.bundles.io.InputStreamVisitor;
import net.thevpc.nuts.runtime.bundles.io.ZipUtils;
import net.thevpc.nuts.runtime.bundles.reflect.DefaultReflectRepository;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectConfigurationBuilder;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectPropertyAccessStrategy;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectPropertyDefaultValueStrategy;
import net.thevpc.nuts.runtime.bundles.reflect.ReflectRepository;
import net.thevpc.nuts.runtime.core.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.core.commands.repo.NutsRepositorySupportedAction;
import net.thevpc.nuts.runtime.core.format.NutsFetchDisplayOptions;
import net.thevpc.nuts.runtime.core.format.NutsPrintIterator;
import net.thevpc.nuts.runtime.core.format.plain.DefaultSearchFormatPlain;
import net.thevpc.nuts.runtime.core.repos.DefaultNutsRepositoryManager;
import net.thevpc.nuts.runtime.core.repos.NutsInstalledRepository;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.io.DefaultNutsExecutionEntry;
import net.thevpc.nuts.runtime.standalone.util.NutsJavaSdkUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceHelper;
import net.thevpc.nuts.runtime.standalone.wscommands.NutsRepositoryAndFetchMode;
import net.thevpc.nuts.spi.NutsRepositorySPI;

public class NutsWorkspaceUtils {
    private NutsLogger LOG;
    private NutsWorkspace ws;
    private NutsSession session;

    private NutsWorkspaceUtils(NutsSession session) {
        this.session = session;
        this.ws = session.getWorkspace();
    }

    public static NutsWorkspaceUtils of(NutsSession ws) {
        return new NutsWorkspaceUtils(ws);
    }

    public static NutsSession defaultSession(NutsWorkspace ws) {
        return ((NutsWorkspaceExt)ws).defaultSession();
    }

    public static void checkSession(NutsWorkspace ws, NutsSession session) {
        if (session == null) {
            throw new NutsIllegalArgumentException(NutsWorkspaceUtils.defaultSession(ws), NutsMessage.cstyle((String)"missing session", (Object[])new Object[0]));
        }
        if (!Objects.equals(session.getWorkspace().getUuid(), ws.getUuid())) {
            throw new NutsIllegalArgumentException(NutsWorkspaceUtils.defaultSession(ws), NutsMessage.cstyle((String)"invalid session", (Object[])new Object[0]));
        }
    }

    public static void checkNutsIdBase(NutsWorkspace ws, NutsId id) {
        if (id == null) {
            throw new NutsIllegalArgumentException(NutsWorkspaceUtils.defaultSession(ws), NutsMessage.cstyle((String)"missing id", (Object[])new Object[0]));
        }
        if (NutsUtilStrings.isBlank((CharSequence)id.getGroupId())) {
            throw new NutsIllegalArgumentException(NutsWorkspaceUtils.defaultSession(ws), NutsMessage.cstyle((String)"missing group for %s", (Object[])new Object[]{id}));
        }
        if (NutsUtilStrings.isBlank((CharSequence)id.getArtifactId())) {
            throw new NutsIllegalArgumentException(NutsWorkspaceUtils.defaultSession(ws), NutsMessage.cstyle((String)"missing name for %s", (Object[])new Object[]{id}));
        }
    }

    public static boolean setSession(Object o, NutsSession session) {
        if (o instanceof NutsSessionAware) {
            ((NutsSessionAware)o).setSession(session);
            return true;
        }
        return false;
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = this.ws.log().setSession(session).of(NutsWorkspaceUtils.class);
        }
        return this.LOG;
    }

    public NutsRepositorySPI repoSPI(NutsRepository repo) {
        DefaultNutsRepositoryManager repos = (DefaultNutsRepositoryManager)this.ws.repos().setSession(this.session);
        return repos.getModel().toRepositorySPI(repo);
    }

    public ReflectRepository getReflectRepository() {
        return (ReflectRepository)this.ws.env().setSession(this.session).getOrCreateProperty(ReflectRepository.class, () -> new DefaultReflectRepository(ReflectConfigurationBuilder.create().setPropertyAccessStrategy(ReflectPropertyAccessStrategy.FIELD).setPropertyDefaultValueStrategy(ReflectPropertyDefaultValueStrategy.PROPERTY_DEFAULT).build()));
    }

    public NutsId createSdkId(String type, String version) {
        if (NutsUtilStrings.isBlank((CharSequence)type)) {
            throw new NutsException(this.session, NutsMessage.formatted((String)"missing sdk type"));
        }
        if (NutsUtilStrings.isBlank((CharSequence)version)) {
            throw new NutsException(this.session, NutsMessage.formatted((String)"missing version"));
        }
        if ("java".equalsIgnoreCase(type)) {
            return NutsJavaSdkUtils.of(this.ws).createJdkId(version, this.session);
        }
        return this.ws.id().builder().setArtifactId(type).setVersion(version).build();
    }

    public void checkReadOnly() {
        if (this.session.getWorkspace().config().isReadOnly()) {
            throw new NutsReadOnlyException(this.session, this.session.getWorkspace().locations().getWorkspaceLocation());
        }
    }

    public NutsFetchCommand validateSession(NutsFetchCommand fetch) {
        if (fetch.getSession() == null) {
            fetch = fetch.setSession(this.ws.createSession());
        }
        return fetch;
    }

    public NutsSession validateSession(NutsSession session) {
        if (session == null) {
            session = this.ws.createSession();
        } else if (session.getWorkspace() != this.ws) {
            throw new IllegalArgumentException("session was created with a different Workspace");
        }
        return session;
    }

    public NutsSession validateSilentSession(NutsSession session) {
        if (session == null) {
            session = this.ws.createSession().setTrace(Boolean.valueOf(false));
            return session;
        }
        return CoreNutsUtils.silent(session);
    }

    public NutsId configureFetchEnv(NutsId id) {
        Map qm = id.getProperties();
        if (qm.get("face") == null && qm.get("arch") == null && qm.get("os") == null && qm.get("osdist") == null && qm.get("platform") == null) {
            qm.put("arch", this.ws.env().getArchFamily().id());
            qm.put("os", this.ws.env().getOs().toString());
            if (this.ws.env().getOsDist() != null) {
                qm.put("osdist", this.ws.env().getOsDist().toString());
            }
            return id.builder().setProperties(qm).build();
        }
        return id;
    }

    public List<NutsRepository> _getEnabledRepositories(NutsRepositoryFilter repositoryFilter) {
        ArrayList<NutsRepository> repos = new ArrayList<NutsRepository>();
        ArrayList<NutsRepository> subrepos = new ArrayList<NutsRepository>();
        for (NutsRepository repository : this.ws.repos().setSession(this.session).getRepositories()) {
            boolean ok = false;
            if (!repository.config().isEnabled()) continue;
            if (repositoryFilter == null || repositoryFilter.acceptRepository(repository)) {
                repos.add(repository);
                ok = true;
            }
            if (ok) continue;
            subrepos.add(repository);
        }
        for (NutsRepository subrepo : subrepos) {
            repos.addAll(NutsWorkspaceHelper._getEnabledRepositories(subrepo, repositoryFilter, this.session));
        }
        return repos;
    }

    public List<NutsRepository> filterRepositoriesDeploy(NutsId id, NutsRepositoryFilter repositoryFilter) {
        NutsRepositoryFilter f = this.ws.filters().repository().installedRepo().neg().and(repositoryFilter);
        return this.filterRepositories(NutsRepositorySupportedAction.DEPLOY, id, f, NutsFetchMode.LOCAL);
    }

    public List<NutsRepositoryAndFetchMode> filterRepositoryAndFetchModes(NutsRepositorySupportedAction fmode, NutsId id, NutsRepositoryFilter repositoryFilter, NutsFetchStrategy fetchStrategy, NutsSession session) {
        ArrayList<NutsRepositoryAndFetchMode> ok = new ArrayList<NutsRepositoryAndFetchMode>();
        for (NutsFetchMode nutsFetchMode : fetchStrategy) {
            for (NutsRepository nutsRepositoryAndFetchMode : this.filterRepositories(fmode, id, repositoryFilter, nutsFetchMode)) {
                ok.add(new NutsRepositoryAndFetchMode(nutsRepositoryAndFetchMode, nutsFetchMode));
            }
        }
        return ok;
    }

    private List<NutsRepository> filterRepositories(NutsRepositorySupportedAction fmode, NutsId id, NutsRepositoryFilter repositoryFilter, NutsFetchMode mode) {
        return this.filterRepositories(fmode, id, repositoryFilter, true, null, mode);
    }

    private List<NutsRepository> filterRepositories(NutsRepositorySupportedAction fmode, NutsId id, NutsRepositoryFilter repositoryFilter, boolean sortByLevelDesc, Comparator<NutsRepository> postComp, NutsFetchMode mode) {
        ArrayList<RepoAndLevel> repos2 = new ArrayList<RepoAndLevel>();
        for (NutsRepository repository : this.ws.repos().setSession(this.session).getRepositories()) {
            if (!repository.isEnabled() || !repository.isAvailable() || !this.repoSPI(repository).isAcceptFetchMode(mode, this.session) || repositoryFilter != null && !repositoryFilter.acceptRepository(repository)) continue;
            int t = 0;
            int d = 0;
            if (fmode == NutsRepositorySupportedAction.DEPLOY) {
                try {
                    d = NutsRepositoryUtils.getSupportDeployLevel(repository, fmode, id, mode, this.session.isTransitive(), this.session);
                }
                catch (Exception ex) {
                    this._LOGOP(this.session).level(Level.FINE).error((Throwable)ex).log("unable to resolve support deploy level for : {0}", new Object[]{repository.getName()});
                }
            }
            try {
                t = NutsRepositoryUtils.getSupportSpeedLevel(repository, fmode, id, mode, this.session.isTransitive(), this.session);
            }
            catch (Exception ex) {
                this._LOGOP(this.session).level(Level.FINE).error((Throwable)ex).log("unable to resolve support speed level for : {0}", new Object[]{repository.getName()});
            }
            if (t <= 0) continue;
            repos2.add(new RepoAndLevel(repository, d, t, postComp));
        }
        if (sortByLevelDesc || postComp != null) {
            Collections.sort(repos2);
        }
        ArrayList<NutsRepository> ret = new ArrayList<NutsRepository>();
        NutsInstalledRepository installedRepository = NutsWorkspaceExt.of(this.ws).getInstalledRepository();
        if (mode == NutsFetchMode.LOCAL && fmode == NutsRepositorySupportedAction.SEARCH && (repositoryFilter == null || repositoryFilter.acceptRepository((NutsRepository)installedRepository))) {
            ret.add(installedRepository);
        }
        for (RepoAndLevel repoAndLevel : repos2) {
            ret.add(repoAndLevel.r);
        }
        return ret;
    }

    public void checkSimpleNameNutsId(NutsId id) {
        if (id == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing id", (Object[])new Object[0]));
        }
        if (NutsUtilStrings.isBlank((CharSequence)id.getGroupId())) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing groupId for %s", (Object[])new Object[]{id}));
        }
        if (NutsUtilStrings.isBlank((CharSequence)id.getArtifactId())) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing artifactId for %s", (Object[])new Object[]{id}));
        }
    }

    public void checkLongNameNutsId(NutsId id, NutsSession session) {
        this.checkSimpleNameNutsId(id);
        if (NutsUtilStrings.isBlank((CharSequence)id.getVersion().toString())) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing version for %s", (Object[])new Object[]{id}));
        }
    }

    public void validateRepositoryName(String repositoryName, Set<String> registered, NutsSession session) {
        if (!repositoryName.matches("[a-zA-Z][.a-zA-Z0-9_-]*")) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid repository id %s", (Object[])new Object[]{repositoryName}));
        }
        if (registered.contains(repositoryName)) {
            throw new NutsRepositoryAlreadyRegisteredException(session, repositoryName);
        }
    }

    public NutsIdFormat getIdFormat() {
        String k = DefaultSearchFormatPlain.class.getName() + "#NutsIdFormat";
        NutsIdFormat f = (NutsIdFormat)this.ws.env().getProperty(k);
        if (f == null) {
            f = this.ws.id().formatter();
            this.ws.env().setProperty(k, (Object)f);
        }
        return f;
    }

    public NutsDescriptorFormat getDescriptorFormat() {
        String k = DefaultSearchFormatPlain.class.getName() + "#NutsDescriptorFormat";
        NutsDescriptorFormat f = (NutsDescriptorFormat)this.ws.env().getProperty(k);
        if (f == null) {
            f = this.ws.descriptor().formatter();
            this.ws.env().setProperty(k, (Object)f);
        }
        return f;
    }

    public <T> Iterator<T> decoratePrint(Iterator<T> it, NutsSession session, NutsFetchDisplayOptions displayOptions) {
        NutsPrintStream out = this.validateSession(session).getTerminal().getOut();
        return new NutsPrintIterator<T>(it, this.ws, out, displayOptions, session);
    }

    public NutsDescriptor getEffectiveDescriptor(NutsDefinition def) {
        NutsDescriptor d = def.getEffectiveDescriptor();
        if (d == null) {
            return NutsWorkspaceExt.of(this.ws).resolveEffectiveDescriptor(def.getDescriptor(), null);
        }
        return d;
    }

    public void checkNutsId(NutsId id) {
        NutsWorkspaceUtils.checkNutsIdBase(this.ws, id);
        if (id.getVersion().isBlank()) {
            throw new NutsIllegalArgumentException(NutsWorkspaceUtils.defaultSession(this.ws), NutsMessage.cstyle((String)"missing name for %s", (Object[])new Object[]{id}));
        }
    }

    public Events events() {
        return new Events(this);
    }

    public void traceMessage(NutsFetchStrategy fetchMode, NutsId id, NutsLogVerb tracePhase, String message, long startTime) {
        if (this._LOG(this.session).isLoggable(Level.FINEST)) {
            long time = startTime != 0L ? System.currentTimeMillis() - startTime : 0L;
            String fetchString = "[" + CoreStringUtils.alignLeft(fetchMode.name(), 7) + "] ";
            this._LOGOP(this.session).level(Level.FINEST).verb(tracePhase).formatted().time(time).log("{0}{1} {2}", new Object[]{fetchString, id, CoreStringUtils.alignLeft(message, 18)});
        }
    }

    public NutsExecutionEntry parseClassExecutionEntry(InputStream classStream, String sourceName) {
        CorePlatformUtils.MainClassType mainClass = null;
        try {
            mainClass = CorePlatformUtils.getMainClassType(classStream);
        }
        catch (Exception ex) {
            this._LOGOP(this.session).level(Level.FINE).error((Throwable)ex).log("invalid file format {0}", new Object[]{sourceName});
        }
        if (mainClass != null) {
            return new DefaultNutsExecutionEntry(mainClass.getName(), false, mainClass.isApp() && mainClass.isMain());
        }
        return null;
    }

    public NutsExecutionEntry[] parseJarExecutionEntries(InputStream jarStream, String sourceName) {
        if (!(jarStream instanceof BufferedInputStream)) {
            jarStream = new BufferedInputStream(jarStream);
        }
        final ArrayList classes = new ArrayList();
        final ArrayList manifestClass = new ArrayList();
        try {
            ZipUtils.visitZipStream(jarStream, new Predicate<String>(){

                @Override
                public boolean test(String path) {
                    return path.endsWith(".class") || path.equals("META-INF/MANIFEST.MF");
                }
            }, new InputStreamVisitor(){

                @Override
                public boolean visit(String path, InputStream inputStream) throws IOException {
                    if (path.endsWith(".class")) {
                        NutsExecutionEntry mainClass = NutsWorkspaceUtils.this.parseClassExecutionEntry(inputStream, path);
                        if (mainClass != null) {
                            classes.add(mainClass);
                        }
                    } else {
                        String v;
                        Manifest manifest = new Manifest(inputStream);
                        Attributes a = manifest.getMainAttributes();
                        if (a != null && a.containsKey("Main-Class") && !NutsUtilStrings.isBlank((CharSequence)(v = a.getValue("Main-Class")))) {
                            manifestClass.add(v);
                        }
                    }
                    return true;
                }
            });
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        ArrayList<NutsExecutionEntry> entries = new ArrayList<NutsExecutionEntry>();
        String defaultEntry = null;
        if (manifestClass.size() > 0) {
            defaultEntry = (String)manifestClass.get(0);
        }
        boolean defaultFound = false;
        for (NutsExecutionEntry entry : classes) {
            if (defaultEntry != null && defaultEntry.equals(entry.getName())) {
                entries.add(new DefaultNutsExecutionEntry(entry.getName(), true, entry.isApp()));
                defaultFound = true;
                continue;
            }
            entries.add(entry);
        }
        if (defaultEntry != null && !defaultFound) {
            this._LOGOP(this.session).level(Level.SEVERE).verb(NutsLogVerb.FAIL).log("invalid default entry " + defaultEntry + " in " + sourceName, new Object[0]);
        }
        return entries.toArray(new NutsExecutionEntry[0]);
    }

    public InputStream openURL(String o) {
        return new SimpleHttpClient(o, this.session).openStream();
    }

    public InputStream openURL(URL o) {
        return new SimpleHttpClient(o, this.session).openStream();
    }

    public static class Events {
        private NutsWorkspaceUtils u;

        public Events(NutsWorkspaceUtils u) {
            this.u = u;
        }

        public void fireOnInstall(NutsInstallEvent event) {
            this.u._LOGOP(event.getSession()).level(Level.FINEST).verb(NutsLogVerb.UPDATE).formatted().log("installed {0}", new Object[]{event.getDefinition().getId()});
            for (NutsInstallListener listener : this.u.ws.events().getInstallListeners()) {
                listener.onInstall(event);
            }
            for (NutsInstallListener listener : (NutsInstallListener[])event.getSession().getListeners(NutsInstallListener.class)) {
                listener.onInstall(event);
            }
        }

        public void fireOnRequire(NutsInstallEvent event) {
            this.u._LOGOP(event.getSession()).level(Level.FINEST).verb(NutsLogVerb.UPDATE).formatted().log("required {0}", new Object[]{event.getDefinition().getId()});
            for (NutsInstallListener listener : this.u.ws.events().getInstallListeners()) {
                listener.onRequire(event);
            }
            for (NutsInstallListener listener : (NutsInstallListener[])event.getSession().getListeners(NutsInstallListener.class)) {
                listener.onRequire(event);
            }
        }

        public void fireOnUpdate(NutsUpdateEvent event) {
            if (this.u._LOG(event.getSession()).isLoggable(Level.FINEST)) {
                if (event.getOldValue() == null) {
                    this.u._LOGOP(event.getSession()).level(Level.FINEST).verb(NutsLogVerb.UPDATE).formatted().log("updated {0}", new Object[]{event.getNewValue().getId()});
                } else {
                    this.u._LOGOP(event.getSession()).level(Level.FINEST).verb(NutsLogVerb.UPDATE).formatted().log("updated {0} (old is {1})", new Object[]{event.getOldValue().getId().getLongNameId(), event.getNewValue().getId().getLongNameId()});
                }
            }
            for (NutsInstallListener listener : this.u.ws.events().getInstallListeners()) {
                listener.onUpdate(event);
            }
            for (NutsInstallListener listener : (NutsInstallListener[])event.getSession().getListeners(NutsInstallListener.class)) {
                listener.onUpdate(event);
            }
        }

        public void fireOnUninstall(NutsInstallEvent event) {
            if (this.u._LOG(event.getSession()).isLoggable(Level.FINEST)) {
                this.u._LOGOP(event.getSession()).level(Level.FINEST).verb(NutsLogVerb.UPDATE).formatted().log("uninstalled {0}", new Object[]{event.getDefinition().getId()});
            }
            for (NutsInstallListener listener : this.u.ws.events().getInstallListeners()) {
                listener.onUninstall(event);
            }
            for (NutsInstallListener listener : (NutsInstallListener[])event.getSession().getListeners(NutsInstallListener.class)) {
                listener.onUninstall(event);
            }
        }

        public void fireOnAddRepository(NutsWorkspaceEvent event) {
            if (this.u._LOG(event.getSession()).isLoggable(Level.CONFIG)) {
                this.u._LOGOP(event.getSession()).level(Level.CONFIG).verb(NutsLogVerb.UPDATE).formatted().log("added repo ##{0}##", new Object[]{event.getRepository().getName()});
            }
            for (NutsWorkspaceListener listener : this.u.ws.events().getWorkspaceListeners()) {
                listener.onAddRepository(event);
            }
            for (NutsWorkspaceListener listener : (NutsWorkspaceListener[])event.getSession().getListeners(NutsWorkspaceListener.class)) {
                listener.onAddRepository(event);
            }
        }

        public void fireOnRemoveRepository(NutsWorkspaceEvent event) {
            if (this.u._LOG(event.getSession()).isLoggable(Level.FINEST)) {
                this.u._LOGOP(event.getSession()).level(Level.FINEST).verb(NutsLogVerb.UPDATE).formatted().log("removed repo ##{0}##", new Object[]{event.getRepository().getName()});
            }
            for (NutsWorkspaceListener listener : this.u.ws.events().getWorkspaceListeners()) {
                listener.onRemoveRepository(event);
            }
            for (NutsWorkspaceListener listener : (NutsWorkspaceListener[])event.getSession().getListeners(NutsWorkspaceListener.class)) {
                listener.onRemoveRepository(event);
            }
        }
    }

    private static class RepoAndLevel
    implements Comparable<RepoAndLevel> {
        NutsRepository r;
        int deployOrder;
        int speedOrder;
        Comparator<NutsRepository> postComp;

        public RepoAndLevel(NutsRepository r, int deployOrder, int speedOrder, Comparator<NutsRepository> postComp) {
            this.r = r;
            this.deployOrder = deployOrder;
            this.speedOrder = speedOrder;
            this.postComp = postComp;
        }

        @Override
        public int compareTo(RepoAndLevel o2) {
            int x = Integer.compare(this.deployOrder, o2.deployOrder);
            if (x != 0) {
                return x;
            }
            x = Integer.compare(o2.speedOrder, this.speedOrder);
            if (x != 0) {
                return x;
            }
            if (this.postComp != null) {
                x = this.postComp.compare(this.r, o2.r);
            }
            return x;
        }
    }
}

