/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.logging.Level;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsSdkLocation;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextManager;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsUtilPlatforms;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.config.NutsSdkLocationComparator;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class NutsJavaSdkUtils {
    private NutsLogger LOG;
    private final NutsWorkspace ws;

    private NutsJavaSdkUtils(NutsWorkspace ws) {
        this.ws = ws;
    }

    public static NutsJavaSdkUtils of(NutsSession ws) {
        return NutsJavaSdkUtils.of(ws.getWorkspace());
    }

    public static NutsJavaSdkUtils of(NutsWorkspace ws) {
        return new NutsJavaSdkUtils(ws);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = session.getWorkspace().log().of(NutsJavaSdkUtils.class);
        }
        return this.LOG;
    }

    public NutsSdkLocation resolveJdkLocation(String requestedJavaVersion, NutsSession session) {
        requestedJavaVersion = NutsUtilStrings.trim((String)requestedJavaVersion);
        NutsSdkLocation bestJava = session.getWorkspace().sdks().setSession(session).findByVersion("java", session.getWorkspace().version().filter().byValue(requestedJavaVersion));
        if (bestJava == null) {
            String appSuffix = session.getWorkspace().env().getOsFamily() == NutsOsFamily.WINDOWS ? ".exe" : "";
            String packaging = "jre";
            if (new File(System.getProperty("java.home"), "bin" + File.separator + "javac" + appSuffix).isFile()) {
                packaging = "jdk";
            }
            String product = "JDK";
            NutsSdkLocation current = new NutsSdkLocation(session.getWorkspace().env().getPlatform(), product, product + "-" + System.getProperty("java.version"), System.getProperty("java.home"), System.getProperty("java.version"), packaging, 0);
            current.setConfigVersion("0.8.0");
            NutsVersionFilter requestedJavaVersionFilter = session.getWorkspace().version().parser().parse(requestedJavaVersion).filter();
            if (requestedJavaVersionFilter == null || requestedJavaVersionFilter.acceptVersion(session.getWorkspace().version().parser().parse(current.getVersion()), session)) {
                bestJava = current;
            }
            if (bestJava == null) {
                if (!NutsUtilStrings.isBlank((CharSequence)requestedJavaVersion)) {
                    this._LOGOP(session).level(Level.FINE).verb(NutsLogVerb.WARNING).log("No valid JRE found. recommended {0} . Using default java.home at {1}", new Object[]{requestedJavaVersion, System.getProperty("java.home")});
                } else {
                    this._LOGOP(session).level(Level.FINE).verb(NutsLogVerb.WARNING).log("No valid JRE found. Using default java.home at {0}", new Object[]{System.getProperty("java.home")});
                }
                bestJava = current;
            }
        }
        return bestJava;
    }

    public NutsSdkLocation[] searchJdkLocations(NutsSession session) {
        String[] conf = new String[]{};
        switch (session.getWorkspace().env().getOsFamily()) {
            case LINUX: 
            case UNIX: 
            case UNKNOWN: {
                conf = new String[]{"/usr/java", "/usr/lib64/jvm", "/usr/lib/jvm"};
                break;
            }
            case WINDOWS: {
                conf = new String[]{NutsUtilPlatforms.getWindowsProgramFiles() + "\\Java", NutsUtilPlatforms.getWindowsProgramFilesX86() + "\\Java"};
                break;
            }
            case MACOS: {
                conf = new String[]{"/Library/Java/JavaVirtualMachines", "/System/Library/Frameworks/JavaVM.framework"};
            }
        }
        ArrayList<NutsSdkLocation> all = new ArrayList<NutsSdkLocation>();
        for (String s : conf) {
            all.addAll(Arrays.asList(this.searchJdkLocations(s, session)));
        }
        return all.toArray(new NutsSdkLocation[0]);
    }

    public Future<NutsSdkLocation[]> searchJdkLocationsFuture(final NutsSession session) {
        LinkedHashSet<String> conf = new LinkedHashSet<String>();
        File file = new File(System.getProperty("java.home"));
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        final ArrayList<Future<NutsSdkLocation[]>> all = new ArrayList<Future<NutsSdkLocation[]>>();
        NutsSdkLocation base = this.resolveJdkLocation(file.getPath(), null, session);
        if (base != null) {
            all.add(CompletableFuture.completedFuture(new NutsSdkLocation[]{base}));
        }
        switch (session.getWorkspace().env().getOsFamily()) {
            case LINUX: 
            case UNIX: 
            case UNKNOWN: {
                conf.addAll(Arrays.asList("/usr/java", "/usr/lib64/jvm", "/usr/lib/jvm"));
                break;
            }
            case WINDOWS: {
                conf.addAll(Arrays.asList(NutsUtilPlatforms.getWindowsProgramFiles() + "\\Java", NutsUtilPlatforms.getWindowsProgramFilesX86() + "\\Java"));
                break;
            }
            case MACOS: {
                conf.addAll(Arrays.asList("/Library/Java/JavaVirtualMachines", "/System/Library/Frameworks/JavaVM.framework"));
            }
        }
        for (String s : conf) {
            all.add(this.searchJdkLocationsFuture(Paths.get(s, new String[0]), session));
        }
        return session.getWorkspace().concurrent().executorService().submit(new Callable<NutsSdkLocation[]>(){

            @Override
            public NutsSdkLocation[] call() throws Exception {
                ArrayList<NutsSdkLocation> locs = new ArrayList<NutsSdkLocation>();
                for (Future nutsSdkLocationFuture : all) {
                    NutsSdkLocation[] e = (NutsSdkLocation[])nutsSdkLocationFuture.get();
                    if (e == null) continue;
                    locs.addAll(Arrays.asList(e));
                }
                locs.sort(new NutsSdkLocationComparator(session.getWorkspace()));
                return locs.toArray(new NutsSdkLocation[0]);
            }
        });
    }

    public NutsSdkLocation[] searchJdkLocations(String loc, NutsSession session) {
        Path s = Paths.get(loc, new String[0]);
        ArrayList<NutsSdkLocation> all = new ArrayList<NutsSdkLocation>();
        if (Files.isDirectory(s, new LinkOption[0])) {
            try (DirectoryStream<Path> it = Files.newDirectoryStream(s);){
                for (Path d : it) {
                    NutsSdkLocation r = this.resolveJdkLocation(d.toString(), null, session);
                    if (r == null) continue;
                    all.add(r);
                    if (session == null || !session.isPlainTrace()) continue;
                    NutsTextManager factory = session.getWorkspace().text();
                    session.out().printf("detected java %s %s at %s%n", new Object[]{r.getPackaging(), factory.forStyled(r.getVersion(), NutsTextStyle.version()), factory.forStyled(r.getPath(), NutsTextStyle.path())});
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        all.sort(new NutsSdkLocationComparator(session.getWorkspace()));
        return all.toArray(new NutsSdkLocation[0]);
    }

    public Future<NutsSdkLocation[]> searchJdkLocationsFuture(Path s, final NutsSession session) {
        if (session == null) {
            throw new IllegalArgumentException("Session cannot be null");
        }
        final ArrayList<Future<NutsSdkLocation>> all = new ArrayList<Future<NutsSdkLocation>>();
        if (Files.isDirectory(s, new LinkOption[0])) {
            try (DirectoryStream<Path> it = Files.newDirectoryStream(s);){
                for (final Path d : it) {
                    all.add(session.getWorkspace().concurrent().executorService().submit(new Callable<NutsSdkLocation>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public NutsSdkLocation call() throws Exception {
                            NutsSdkLocation r;
                            block5: {
                                r = null;
                                try {
                                    r = NutsJavaSdkUtils.this.resolveJdkLocation(d.toString(), null, session);
                                    if (r == null || !session.isPlainTrace()) break block5;
                                    NutsWorkspace nutsWorkspace = session.getWorkspace();
                                    synchronized (nutsWorkspace) {
                                        NutsTextManager factory = session.getWorkspace().text();
                                        session.out().printf("detected java %s %s at %s%n", new Object[]{r.getPackaging(), factory.forStyled(r.getVersion(), NutsTextStyle.version()), factory.forStyled(r.getPath(), NutsTextStyle.path())});
                                    }
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                            return r;
                        }
                    }));
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return session.getWorkspace().concurrent().executorService().submit(new Callable<NutsSdkLocation[]>(){

            @Override
            public NutsSdkLocation[] call() throws Exception {
                ArrayList<NutsSdkLocation> locs = new ArrayList<NutsSdkLocation>();
                for (Future nutsSdkLocationFuture : all) {
                    NutsSdkLocation e = (NutsSdkLocation)nutsSdkLocationFuture.get();
                    if (e == null) continue;
                    locs.add(e);
                }
                return locs.toArray(new NutsSdkLocation[0]);
            }
        });
    }

    public NutsSdkLocation resolveJdkLocation(String path, String preferredName, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.ws, session);
        if (path == null) {
            throw new NutsException(session, NutsMessage.formatted((String)"missing path"));
        }
        String appSuffix = session.getWorkspace().env().getOsFamily() == NutsOsFamily.WINDOWS ? ".exe" : "";
        Path bin = Paths.get(path, new String[0]).resolve("bin");
        Path javaExePath = bin.resolve("java" + appSuffix);
        if (!Files.isRegularFile(javaExePath, new LinkOption[0])) {
            return null;
        }
        String product = null;
        String jdkVersion = null;
        String cmdOutputString = null;
        int cmdRresult = 0;
        boolean loggedError = false;
        try {
            int MAX_ITER = 5;
            for (int i = 0; i < 5; ++i) {
                NutsExecCommand cmd = session.getWorkspace().exec().setSession(session).setExecutionType(NutsExecutionType.SYSTEM).addCommand(new String[]{javaExePath.toString(), "-version"}).setRedirectErrorStream(true).grabOutputString().setFailFast(true).run();
                cmdRresult = cmd.getResult();
                cmdOutputString = cmd.getOutputString();
                if (cmdOutputString.length() > 0) break;
                this._LOGOP(session).level(i == 4 ? Level.WARNING : Level.FINER).verb(NutsLogVerb.WARNING).log("unable to execute {0}. returned empty string ({1}/{2})", new Object[]{javaExePath, i + 1, 5});
            }
            if (cmdOutputString.length() > 0) {
                int j;
                String prefix = "java version \"";
                int i = cmdOutputString.indexOf(prefix);
                if (i >= 0) {
                    j = cmdOutputString.indexOf("\"", i += prefix.length());
                    if (i >= 0) {
                        jdkVersion = cmdOutputString.substring(i, j);
                        product = "JDK";
                    }
                }
                if (jdkVersion == null && (i = cmdOutputString.indexOf(prefix = "openjdk version \"")) >= 0) {
                    j = cmdOutputString.indexOf("\"", i += prefix.length());
                    if (i > 0) {
                        jdkVersion = cmdOutputString.substring(i, j);
                        product = "OpenJDK";
                    }
                }
            }
        }
        catch (Exception ex) {
            loggedError = true;
            this._LOGOP(session).error((Throwable)ex).level(Level.SEVERE).verb(NutsLogVerb.WARNING).log("unable to execute {0}. JDK Home ignored", new Object[]{javaExePath});
        }
        if (jdkVersion == null) {
            if (!loggedError) {
                this._LOGOP(session).level(Level.SEVERE).verb(NutsLogVerb.WARNING).log("execute {0} failed with result code {1} and result string \"{2}\". JDK Home ignored", new Object[]{javaExePath.toString(), cmdRresult, cmdOutputString});
            }
            return null;
        }
        String packaging = "jre";
        if (Files.isRegularFile(bin.resolve("javac" + appSuffix), new LinkOption[0]) && Files.isRegularFile(bin.resolve("jps" + appSuffix), new LinkOption[0])) {
            packaging = "jdk";
        }
        preferredName = NutsUtilStrings.isBlank((CharSequence)preferredName) ? product + "-" + jdkVersion : NutsUtilStrings.trim((String)preferredName);
        NutsSdkLocation r = new NutsSdkLocation(NutsWorkspaceUtils.of(session).createSdkId("java", jdkVersion), product, preferredName, path, jdkVersion, packaging, 0);
        r.setConfigVersion("0.8.0");
        return r;
    }

    public NutsId createJdkId(String version, NutsSession session) {
        if (NutsUtilStrings.isBlank((CharSequence)version)) {
            throw new NutsException(session, NutsMessage.formatted((String)"missing version"));
        }
        NutsVersion jv = session.getWorkspace().version().parser().parse(version);
        long n1 = jv.getNumber(0, BigInteger.ZERO).longValue();
        long n2 = jv.getNumber(1, BigInteger.ZERO).longValue();
        long classFileId = 0L;
        String standard = n1 + "." + n2;
        if (n1 == 1L) {
            classFileId = 44L + n2;
        }
        if (classFileId == 0L) {
            classFileId = 52L;
        }
        return session.getWorkspace().id().builder().setArtifactId("java").setProperty("s", standard).setProperty("c", String.valueOf(classFileId)).setVersion(version).build();
    }

    public String resolveJavaCommandByVersion(String requestedJavaVersion, boolean javaw, NutsSession session) {
        Path file;
        String bestJavaPath = this.resolveJdkLocation(requestedJavaVersion, session).getPath();
        if ((bestJavaPath.contains("/") || bestJavaPath.contains("\\") || bestJavaPath.equals(".") || bestJavaPath.equals("..")) && Files.isDirectory(file = Paths.get(session.getWorkspace().locations().getWorkspaceLocation(), new String[0]).resolve(bestJavaPath), new LinkOption[0]) && Files.isDirectory(file.resolve("bin"), new LinkOption[0])) {
            boolean winOs;
            boolean bl = winOs = session.getWorkspace().env().getOsFamily() == NutsOsFamily.WINDOWS;
            bestJavaPath = winOs ? (javaw ? file.resolve("bin" + File.separatorChar + "javaw.exe").toString() : file.resolve("bin" + File.separatorChar + "java.exe").toString()) : file.resolve("bin" + File.separatorChar + "java").toString();
        }
        return bestJavaPath;
    }

    public String resolveJavaCommandByHome(String javaHome, NutsSession session) {
        String appSuffix = session.getWorkspace().env().getOsFamily() == NutsOsFamily.WINDOWS ? ".exe" : "";
        String exe = "java" + appSuffix;
        if ((javaHome == null || javaHome.isEmpty()) && (NutsUtilStrings.isBlank((CharSequence)(javaHome = System.getProperty("java.home"))) || "null".equals(javaHome))) {
            return exe;
        }
        return javaHome + File.separator + "bin" + File.separator + exe;
    }
}

