/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsDependencyScopePattern;
import net.thevpc.nuts.runtime.core.util.CoreEnumUtils;

public class NutsDependencyScopes {
    private static final Logger LOG = Logger.getLogger(NutsDependencyScopes.class.getName());

    public static int compareScopes(String s1, String s2) {
        int y;
        int x = NutsDependencyScopes.getScopesPriority(s1);
        int c = Integer.compare(x, y = NutsDependencyScopes.getScopesPriority(s2));
        if (c != 0) {
            return x;
        }
        if (x == -1) {
            return NutsDependencyScopes.normalizeScope(s1).compareTo(NutsDependencyScopes.normalizeScope(s2));
        }
        return 0;
    }

    public static NutsDependencyScope parseScope(String scope, boolean lenient) {
        scope = NutsDependencyScopes.normalizeScope(scope);
        return CoreEnumUtils.parseEnumString(scope, NutsDependencyScope.class, lenient);
    }

    public static boolean isDefaultScope(String s1) {
        return NutsDependencyScopes.normalizeScope(s1).equals(NutsDependencyScope.API.id());
    }

    public static boolean isCompileScope(String scope) {
        if (scope == null) {
            return true;
        }
        NutsDependencyScope r = NutsDependencyScopes.parseScope(scope, true);
        return r != null && r.isCompile();
    }

    public static int getScopesPriority(String s1) {
        NutsDependencyScope r = NutsDependencyScopes.parseScope(s1, true);
        if (r == null) {
            return -1;
        }
        switch (r) {
            case IMPLEMENTATION: {
                return 26;
            }
            case API: {
                return 25;
            }
            case RUNTIME: {
                return 24;
            }
            case PROVIDED: {
                return 23;
            }
            case SYSTEM: {
                return 22;
            }
            case OTHER: {
                return 21;
            }
            case TEST_IMPLEMENTATION: {
                return 16;
            }
            case TEST_API: {
                return 15;
            }
            case TEST_RUNTIME: {
                return 14;
            }
            case TEST_PROVIDED: {
                return 13;
            }
            case TEST_SYSTEM: {
                return 12;
            }
            case TEST_OTHER: {
                return 11;
            }
            case IMPORT: {
                return 1;
            }
        }
        return -1;
    }

    public static EnumSet<NutsDependencyScope> add(Collection<NutsDependencyScope> a, NutsDependencyScopePattern ... b) {
        EnumSet<NutsDependencyScope> aa = EnumSet.copyOf(a);
        EnumSet<NutsDependencyScope> bb = NutsDependencyScopes.expand(b == null ? null : Arrays.asList(b));
        aa.addAll(bb);
        return aa;
    }

    public static EnumSet<NutsDependencyScope> add(Collection<NutsDependencyScope> a, NutsDependencyScope ... b) {
        EnumSet<NutsDependencyScope> aa = EnumSet.copyOf(a);
        List<Object> bb = b == null ? Collections.emptyList() : Arrays.asList(b);
        aa.addAll(bb);
        return aa;
    }

    public static EnumSet<NutsDependencyScope> removeScopes(Collection<NutsDependencyScope> a, Collection<NutsDependencyScope> b) {
        EnumSet<NutsDependencyScope> aa = EnumSet.copyOf(a);
        Collection<Object> bb = b == null ? Collections.emptyList() : b;
        aa.removeAll(bb);
        return aa;
    }

    public static EnumSet<NutsDependencyScope> removeScopePatterns(Collection<NutsDependencyScope> a, Collection<NutsDependencyScopePattern> b) {
        EnumSet<NutsDependencyScope> aa = EnumSet.copyOf(a);
        EnumSet<NutsDependencyScope> bb = NutsDependencyScopes.expand(b);
        aa.removeAll(bb);
        return aa;
    }

    public static EnumSet<NutsDependencyScope> remove(Collection<NutsDependencyScope> a, NutsDependencyScopePattern ... b) {
        EnumSet<NutsDependencyScope> aa = EnumSet.copyOf(a);
        EnumSet<NutsDependencyScope> bb = NutsDependencyScopes.expand(b == null ? null : Arrays.asList(b));
        aa.removeAll(bb);
        return aa;
    }

    public static EnumSet<NutsDependencyScope> remove(Collection<NutsDependencyScope> a, NutsDependencyScope ... b) {
        EnumSet<NutsDependencyScope> aa = EnumSet.copyOf(a);
        Collection<Object> bb = b == null ? Collections.emptySet() : Arrays.asList(b);
        aa.removeAll(bb);
        return aa;
    }

    public static EnumSet<NutsDependencyScope> expand(Collection<NutsDependencyScopePattern> other) {
        EnumSet<NutsDependencyScope> a = EnumSet.noneOf(NutsDependencyScope.class);
        if (other != null) {
            for (NutsDependencyScopePattern s : other) {
                if (s == null) continue;
                a.addAll(NutsDependencyScopes.expand(s));
            }
        }
        return a;
    }

    public static EnumSet<NutsDependencyScope> expand(NutsDependencyScopePattern other) {
        if (other == null) {
            return EnumSet.noneOf(NutsDependencyScope.class);
        }
        EnumSet<NutsDependencyScope> v = EnumSet.noneOf(NutsDependencyScope.class);
        switch (other) {
            case RUN: {
                v.add(NutsDependencyScope.API);
                v.add(NutsDependencyScope.IMPLEMENTATION);
                v.add(NutsDependencyScope.SYSTEM);
                v.add(NutsDependencyScope.RUNTIME);
                break;
            }
            case RUN_TEST: {
                v.addAll(NutsDependencyScopes.expand(NutsDependencyScopePattern.RUN));
                v.add(NutsDependencyScope.TEST_API);
                v.add(NutsDependencyScope.TEST_RUNTIME);
                break;
            }
            case COMPILE: {
                v.add(NutsDependencyScope.API);
                v.add(NutsDependencyScope.IMPLEMENTATION);
                v.add(NutsDependencyScope.SYSTEM);
                v.add(NutsDependencyScope.PROVIDED);
                break;
            }
            case TEST: {
                v.add(NutsDependencyScope.TEST_API);
                v.add(NutsDependencyScope.TEST_RUNTIME);
                v.add(NutsDependencyScope.TEST_PROVIDED);
                break;
            }
            case ALL: {
                v.add(NutsDependencyScope.API);
                v.add(NutsDependencyScope.IMPLEMENTATION);
                v.add(NutsDependencyScope.RUNTIME);
                v.add(NutsDependencyScope.SYSTEM);
                v.add(NutsDependencyScope.PROVIDED);
                v.add(NutsDependencyScope.TEST_API);
                v.add(NutsDependencyScope.TEST_RUNTIME);
                v.add(NutsDependencyScope.TEST_PROVIDED);
                v.add(NutsDependencyScope.OTHER);
                break;
            }
            case API: {
                v.add(NutsDependencyScope.API);
            }
            case IMPORT: {
                v.add(NutsDependencyScope.IMPORT);
            }
            case IMPLEMENTATION: {
                v.add(NutsDependencyScope.IMPLEMENTATION);
            }
            case PROVIDED: {
                v.add(NutsDependencyScope.PROVIDED);
            }
            case RUNTIME: {
                v.add(NutsDependencyScope.RUNTIME);
            }
            case SYSTEM: {
                v.add(NutsDependencyScope.SYSTEM);
            }
            case TEST_COMPILE: {
                v.add(NutsDependencyScope.TEST_API);
            }
            case TEST_PROVIDED: {
                v.add(NutsDependencyScope.TEST_PROVIDED);
            }
            case TEST_RUNTIME: {
                v.add(NutsDependencyScope.TEST_RUNTIME);
            }
            case TEST_SYSTEM: {
                v.add(NutsDependencyScope.TEST_SYSTEM);
            }
            case TEST_API: {
                v.add(NutsDependencyScope.TEST_API);
            }
            case TEST_IMPLEMENTATION: {
                v.add(NutsDependencyScope.TEST_IMPLEMENTATION);
            }
            case TEST_OTHER: {
                v.add(NutsDependencyScope.TEST_OTHER);
            }
            case OTHER: {
                v.add(NutsDependencyScope.OTHER);
            }
            default: {
                throw new IllegalArgumentException("unsupported scope pattern " + other);
            }
        }
        return v;
    }

    public static String normalizeScope(String s1) {
        if (s1 == null) {
            s1 = "";
        }
        if ((s1 = s1.toLowerCase().trim()).isEmpty()) {
            return NutsDependencyScope.API.id();
        }
        switch (s1 = s1.replace('-', '_')) {
            case "compileonly": 
            case "compile-only": {
                return NutsDependencyScope.PROVIDED.id();
            }
            case "test": 
            case "testcompile": 
            case "test_compile": 
            case "testapi": 
            case "test_api": {
                return NutsDependencyScope.TEST_API.id();
            }
            case "testruntime": 
            case "test_runtime": {
                return NutsDependencyScope.TEST_RUNTIME.id();
            }
            case "testsystem": 
            case "test_system": {
                return NutsDependencyScope.TEST_SYSTEM.id();
            }
            case "testprovided": 
            case "test_provided": 
            case "testcompileonly": 
            case "test_compile_only": {
                return NutsDependencyScope.TEST_PROVIDED.id();
            }
            case "compile": {
                return NutsDependencyScope.API.id();
            }
        }
        return s1;
    }

    public static NutsDependencyScope parseDependencyScope(String value) {
        value = NutsDependencyScopes.normalizeScope(value);
        try {
            String enumString = value.toUpperCase();
            return NutsDependencyScope.valueOf((String)enumString);
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "unable to parse NutsDependencyScope : " + value, ex);
            return NutsDependencyScope.OTHER;
        }
    }

    public static NutsDependencyScopePattern parseDependencyScopePattern(String value) {
        value = NutsDependencyScopes.normalizeScope(value);
        try {
            String enumString = value.toUpperCase();
            return NutsDependencyScopePattern.valueOf((String)enumString);
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "unable to parse NutsDependencyScope : " + value, ex);
            return NutsDependencyScopePattern.OTHER;
        }
    }
}

