/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedArgumentException;
import net.thevpc.nuts.runtime.bundles.iter.IteratorUtils;
import net.thevpc.nuts.runtime.core.commands.ws.AbstractNutsResultList;
import net.thevpc.nuts.runtime.core.util.CoreCollectionUtils;

public class NutsCollectionResult<T>
extends AbstractNutsResultList<T> {
    private final Object o;
    private final char type;

    public NutsCollectionResult(NutsSession ws, String nutsBase) {
        super(ws, nutsBase);
        this.o = null;
        this.type = (char)110;
    }

    public NutsCollectionResult(NutsSession ws, String nutsBase, Iterator<T> o) {
        super(ws, nutsBase);
        if (o == null) {
            this.o = null;
            this.type = (char)110;
        } else {
            this.o = o;
            this.type = (char)105;
        }
    }

    public NutsCollectionResult(NutsSession ws, String nutsBase, Collection<T> o) {
        super(ws, nutsBase);
        if (o == null) {
            this.o = null;
            this.type = (char)110;
        } else {
            this.o = o;
            this.type = (char)(o instanceof List ? 108 : 99);
        }
    }

    public NutsCollectionResult(NutsSession ws, String nutsBase, List<T> o) {
        super(ws, nutsBase);
        if (o == null) {
            this.o = null;
            this.type = (char)110;
        } else {
            this.o = o;
            this.type = (char)108;
        }
    }

    @Override
    public List<T> list() {
        switch (this.type) {
            case 'n': {
                return Collections.emptyList();
            }
            case 'i': {
                return CoreCollectionUtils.toList((Iterator)this.o);
            }
            case 'l': {
                return (List)this.o;
            }
            case 'c': {
                return new ArrayList((Collection)this.o);
            }
        }
        throw new NutsUnsupportedArgumentException(this.session, NutsMessage.cstyle((String)"illegal type %s", (Object[])new Object[]{Character.valueOf(this.type)}));
    }

    @Override
    public Stream<T> stream() {
        switch (this.type) {
            case 'n': {
                return Collections.emptyList().stream();
            }
            case 'i': {
                return StreamSupport.stream(Spliterators.spliteratorUnknownSize((Iterator)this.o, 16), false);
            }
            case 'l': {
                return ((Collection)this.o).stream();
            }
            case 'c': {
                return ((Collection)this.o).stream();
            }
        }
        throw new NutsUnsupportedArgumentException(this.session, NutsMessage.cstyle((String)"illegal type %s", (Object[])new Object[]{Character.valueOf(this.type)}));
    }

    public Iterator<T> iterator() {
        switch (this.type) {
            case 'n': {
                return IteratorUtils.emptyIterator();
            }
            case 'i': {
                return (Iterator)this.o;
            }
            case 'l': {
                return ((Collection)this.o).iterator();
            }
            case 'c': {
                return ((Collection)this.o).iterator();
            }
        }
        throw new NutsUnsupportedArgumentException(this.session, NutsMessage.cstyle((String)"illegal type %s", (Object[])new Object[]{Character.valueOf(this.type)}));
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.o);
        hash = 47 * hash + this.type;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsCollectionResult other = (NutsCollectionResult)obj;
        if (this.type != other.type) {
            return false;
        }
        return Objects.equals(this.o, other.o);
    }

    public String toString() {
        switch (this.type) {
            case 'n': {
                return "NullBasedResult@" + Integer.toHexString(this.hashCode());
            }
            case 'i': {
                return "IteratorBasedResult@" + Integer.toHexString(this.hashCode());
            }
            case 'l': {
                return "ListBasedResult@" + Integer.toHexString(this.hashCode());
            }
            case 'c': {
                return "CollectionBasedResult@" + Integer.toHexString(this.hashCode());
            }
        }
        return super.toString();
    }
}

