/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import net.thevpc.nuts.NutsClassLoaderNode;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependencyTreeNode;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsSession;

public final class NutsClassLoaderUtils {
    public static NutsClassLoaderNode definitionToClassLoaderNode(NutsDefinition def, NutsSession session) {
        if (session == null) {
            throw new NullPointerException("session cannot be null");
        }
        if (def.getContent() == null || def.getContent().getURL() == null || def.getDependencies() == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"definition must provide content and dependencies", (Object[])new Object[0]));
        }
        return new NutsClassLoaderNode(def.getId().toString(), def.getContent().getURL(), true, (NutsClassLoaderNode[])def.getDependencies().nodes().stream().map(x -> NutsClassLoaderUtils.toClassLoaderNode(x, session)).toArray(NutsClassLoaderNode[]::new));
    }

    private static NutsClassLoaderNode toClassLoaderNode(NutsDependencyTreeNode d, NutsSession session) {
        NutsContent cc = session.getWorkspace().fetch().setId(d.getDependency().toId()).setSession(session).getResultContent();
        if (cc == null) {
            throw new NutsNotFoundException(session, d.getDependency().toId());
        }
        URL url = cc.getURL();
        if (url == null) {
            throw new NutsNotFoundException(session, d.getDependency().toId());
        }
        return new NutsClassLoaderNode(d.getDependency().toId().toString(), url, true, (NutsClassLoaderNode[])Arrays.stream(d.getChildren()).map(x -> NutsClassLoaderUtils.toClassLoaderNode(x, session)).toArray(NutsClassLoaderNode[]::new));
    }

    public static URL[] resolveClasspathURLs(ClassLoader contextClassLoader) {
        ArrayList<URL> all = new ArrayList<URL>();
        if (contextClassLoader != null) {
            if (contextClassLoader instanceof URLClassLoader) {
                all.addAll(Arrays.asList(((URLClassLoader)contextClassLoader).getURLs()));
            } else {
                try {
                    Enumeration<URL> r = contextClassLoader.getResources("META-INF/MANIFEST.MF");
                    while (r.hasMoreElements()) {
                        URL u = r.nextElement();
                        if ("jrt".equals(u.getProtocol()) || !"jar".equals(u.getProtocol()) || !u.getFile().endsWith("!/META-INF/MANIFEST.MF")) continue;
                        String jar = u.getFile().substring(0, u.getFile().length() - "!/META-INF/MANIFEST.MF".length());
                        all.add(new URL(jar));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return all.toArray(new URL[0]);
    }
}

