/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Level;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsDefaultContent;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdType;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedOperationException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.io.UnzipOptions;
import net.thevpc.nuts.runtime.bundles.io.ZipUtils;
import net.thevpc.nuts.runtime.core.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.core.model.DefaultNutsDefinition;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultSourceControlHelper {
    private NutsLogger LOG;
    private NutsWorkspace ws;

    public DefaultSourceControlHelper(NutsWorkspace ws) {
        this.ws = ws;
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = session.getWorkspace().log().of(DefaultSourceControlHelper.class);
        }
        return this.LOG;
    }

    public NutsId commit(Path folder, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.ws, session);
        this.ws.security().setSession(session).checkAllowed("deploy", "commit");
        if (folder == null || !Files.isDirectory(folder, new LinkOption[0])) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"not a directory %s", (Object[])new Object[]{folder}));
        }
        Path file = folder.resolve("nuts.json");
        NutsDescriptor d = this.ws.descriptor().parser().setSession(session).parse(file);
        String oldVersion = NutsUtilStrings.trim((String)d.getId().getVersion().getValue());
        if (oldVersion.endsWith("-CHECKED-OUT")) {
            oldVersion = oldVersion.substring(0, oldVersion.length() - "-CHECKED-OUT".length());
            String newVersion = this.ws.version().parser().parse(oldVersion).inc().getValue();
            NutsDefinition newVersionFound = null;
            try {
                newVersionFound = this.ws.fetch().setId(d.getId().builder().setVersion(newVersion).build()).setSession(session).getResultDefinition();
            }
            catch (NutsNotFoundException ex) {
                this._LOGOP(session).level(Level.FINE).error((Throwable)ex).log("failed to fetch {0}", new Object[]{d.getId().builder().setVersion(newVersion).build()});
            }
            d = newVersionFound == null ? d.builder().setId(d.getId().builder().setVersion(newVersion).build()).build() : d.builder().setId(d.getId().builder().setVersion(oldVersion + ".1").build()).build();
            NutsId newId = this.ws.deploy().setContent(folder).setDescriptor(d).setSession(session).getResult()[0];
            this.ws.descriptor().formatter(d).print(file);
            CoreIOUtils.delete(session, folder);
            return newId;
        }
        throw new NutsUnsupportedOperationException(session, NutsMessage.cstyle((String)"commit not supported", (Object[])new Object[0]));
    }

    public NutsDefinition checkout(String id, Path folder, NutsSession session) {
        return this.checkout(this.ws.id().parser().setLenient(false).parse(id), folder, session);
    }

    public NutsDefinition checkout(NutsId id, Path folder, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.ws, session);
        this.ws.security().setSession(session).checkAllowed("install", "checkout");
        NutsDefinition nutToInstall = this.ws.fetch().setId(id).setSession(session).setOptional(Boolean.valueOf(false)).setDependencies(true).getResultDefinition();
        if ("zip".equals(nutToInstall.getDescriptor().getPackaging())) {
            try {
                ZipUtils.unzip(session, nutToInstall.getPath().toString(), this.ws.io().expandPath(folder.toString()), new UnzipOptions().setSkipRoot(false));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            Path file = folder.resolve("nuts.json");
            NutsDescriptor d = this.ws.descriptor().parser().setSession(session).parse(file);
            NutsVersion oldVersion = d.getId().getVersion();
            NutsId newId = d.getId().builder().setVersion(oldVersion + "-CHECKED-OUT").build();
            d = d.builder().setId(newId).build();
            this.ws.descriptor().formatter(d).print(file);
            NutsIdType idType = NutsWorkspaceExt.of(this.ws).resolveNutsIdType(newId, session);
            return new DefaultNutsDefinition(nutToInstall.getRepositoryUuid(), nutToInstall.getRepositoryName(), newId, d, (NutsContent)new NutsDefaultContent(session.getWorkspace().io().path(folder.toString()), false, false), null, idType, null, session);
        }
        throw new NutsUnsupportedOperationException(session, NutsMessage.cstyle((String)"checkout not supported", (Object[])new Object[0]));
    }
}

