/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;

public class CoreDigestHelper {
    private final List<Throwable> errors = new ArrayList<Throwable>();
    private final MessageDigest md;
    private boolean collected;
    private String collectedString;

    public CoreDigestHelper() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public CoreDigestHelper append(URL ... urls) {
        try {
            if (urls != null) {
                for (URL url : urls) {
                    this.append(url);
                }
            }
        }
        catch (Exception e) {
            this.errors.add(e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreDigestHelper append(URL url) {
        if (url != null) {
            File ff = CoreIOUtils.toFile(url);
            if (ff != null) {
                this.append(ff.toPath());
                return this;
            }
            InputStream is = null;
            try {
                is = url.openStream();
                if (is != null) {
                    this.append(is);
                }
            }
            catch (Exception e) {
                this.errors.add(e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this;
    }

    public CoreDigestHelper append(Path p) {
        if (p != null) {
            if (Files.isDirectory(p, new LinkOption[0])) {
                this.updateDirectory(p);
            } else if (Files.isRegularFile(p, new LinkOption[0])) {
                try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
                    this.append(is);
                }
                catch (IOException ex) {
                    this.errors.add(ex);
                }
            }
        }
        return this;
    }

    private void updateDirectory(Path p) {
        try {
            Files.walkFileTree(p, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    CoreDigestHelper.this.append(new ByteArrayInputStream(dir.toString().getBytes()));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    CoreDigestHelper.this.append(new ByteArrayInputStream(file.toString().getBytes()));
                    CoreDigestHelper.this.append(Files.newInputStream(file, new OpenOption[0]));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            this.errors.add(e);
        }
    }

    private CoreDigestHelper append(InputStream is) {
        try {
            int numBytes;
            byte[] bytes = new byte[4096];
            while ((numBytes = is.read(bytes)) != -1) {
                this.md.update(bytes, 0, numBytes);
            }
        }
        catch (IOException ex) {
            this.errors.add(ex);
        }
        return this;
    }

    public String getDigest() {
        if (!this.collected) {
            this.collected = true;
            byte[] digest = this.md.digest();
            this.collectedString = NutsUtilStrings.toHexString((byte[])digest);
        }
        return this.collectedString;
    }
}

