/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.security;

import com.sun.security.auth.UserPrincipal;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUserConfig;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.config.NutsWorkspaceConfigManagerExt;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.security.NutsWorkspaceSecurityConfiguration;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class NutsWorkspaceLoginModule
implements LoginModule {
    private CallbackHandler handler;
    private Subject subject;
    private UserPrincipal userPrincipal;
    private String login;
    private static final ThreadLocal<NutsWorkspace> WORKSPACE = new ThreadLocal();

    public static void configure(NutsWorkspace workspace) {
        WORKSPACE.set(workspace);
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.handler = callbackHandler;
        this.subject = subject;
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("login"), new PasswordCallback("password", true)};
        try {
            if (this.handler == null) {
                return false;
            }
            this.handler.handle(callbacks);
            String name = ((NameCallback)callbacks[0]).getName();
            PasswordCallback callback = (PasswordCallback)callbacks[1];
            char[] password = callback == null ? null : callback.getPassword();
            NutsWorkspace workspace = WORKSPACE.get();
            if (workspace == null) {
                throw new LoginException("Authentication failed : No Workspace");
            }
            if ("anonymous".equals(name)) {
                this.login = name;
                return true;
            }
            NutsSession defaultSession = NutsWorkspaceUtils.defaultSession(workspace);
            NutsUserConfig registeredUser = NutsWorkspaceConfigManagerExt.of(workspace.config()).getModel().getUser(name, defaultSession);
            if (registeredUser != null) {
                try {
                    workspace.security().setSession(defaultSession).checkCredentials(registeredUser.getCredentials().toCharArray(), password);
                    this.login = name;
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new LoginException("Authentication failed");
        }
        catch (IOException e) {
            throw new LoginException(CoreStringUtils.exceptionToString(e));
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException(CoreStringUtils.exceptionToString(e));
        }
    }

    @Override
    public boolean commit() throws LoginException {
        this.userPrincipal = new UserPrincipal(this.login);
        this.subject.getPrincipals().add(this.userPrincipal);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        return true;
    }

    static {
        Configuration configuration = Configuration.getConfiguration();
        if (configuration.getAppConfigurationEntry("nuts") == null) {
            Configuration.setConfiguration(new NutsWorkspaceSecurityConfiguration(configuration));
            Configuration.getConfiguration();
        }
    }
}

