/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.security;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.thevpc.nuts.NutsAddUserCommand;
import net.thevpc.nuts.NutsAuthenticationAgent;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsLoginException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsRemoveUserCommand;
import net.thevpc.nuts.NutsSecurityException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUpdateUserCommand;
import net.thevpc.nuts.NutsUser;
import net.thevpc.nuts.NutsUserConfig;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceEvent;
import net.thevpc.nuts.NutsWorkspaceListener;
import net.thevpc.nuts.runtime.bundles.common.CorePlatformUtils;
import net.thevpc.nuts.runtime.core.config.NutsWorkspaceConfigManagerExt;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.DefaultNutsWorkspace;
import net.thevpc.nuts.runtime.standalone.config.ConfigEventType;
import net.thevpc.nuts.runtime.standalone.config.DefaultNutsWorkspaceConfigModel;
import net.thevpc.nuts.runtime.standalone.config.NutsWorkspaceConfigSecurity;
import net.thevpc.nuts.runtime.standalone.security.DefaultNutsUser;
import net.thevpc.nuts.runtime.standalone.security.NutsAuthorizations;
import net.thevpc.nuts.runtime.standalone.security.NutsWorkspaceLoginModule;
import net.thevpc.nuts.runtime.standalone.security.WrapperNutsAuthenticationAgent;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultNutsAddUserCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultNutsRemoveUserCommand;
import net.thevpc.nuts.runtime.standalone.wscommands.DefaultNutsUpdateUserCommand;

public class DefaultNutsWorkspaceSecurityModel {
    private final ThreadLocal<Stack<LoginContext>> loginContextStack = new ThreadLocal();
    private final DefaultNutsWorkspace ws;
    private final WrapperNutsAuthenticationAgent agent;
    private final Map<String, NutsAuthorizations> authorizations = new HashMap<String, NutsAuthorizations>();
    private NutsLogger LOG;

    public DefaultNutsWorkspaceSecurityModel(DefaultNutsWorkspace ws) {
        this.ws = ws;
        this.agent = new WrapperNutsAuthenticationAgent(ws, session -> ws.env().setSession(session).getEnvMap(), (x, s) -> this.getAuthenticationAgent(x, s));
        ws.events().addWorkspaceListener((NutsWorkspaceListener)new ClearAuthOnWorkspaceChange());
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = this.ws.log().setSession(session).of(DefaultNutsWorkspaceSecurityModel.class);
        }
        return this.LOG;
    }

    public void login(final String username, final char[] password, NutsSession session) {
        this.login(new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)callback;
                        nameCallback.setName(username);
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        PasswordCallback passwordCallback = (PasswordCallback)callback;
                        passwordCallback.setPassword(password);
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback, "the submitted Callback is unsupported");
                }
            }
        }, session);
    }

    public boolean setSecureMode(boolean secure, char[] adminPassword, NutsSession session) {
        if (secure) {
            return this.switchSecureMode(adminPassword, session);
        }
        return this.switchUnsecureMode(adminPassword, session);
    }

    public boolean switchUnsecureMode(char[] adminPassword, NutsSession session) {
        char[] credentials;
        NutsUser adminSecurity;
        if (adminPassword == null) {
            adminPassword = new char[]{};
        }
        if ((adminSecurity = this.findUser("admin", session)) == null || !adminSecurity.hasCredentials()) {
            if (this._LOG(session).isLoggable(Level.CONFIG)) {
                this._LOGOP(session).level(Level.CONFIG).verb(NutsLogVerb.WARNING).log("admin user has no credentials. reset to default", new Object[0]);
            }
            NutsUserConfig u = NutsWorkspaceConfigManagerExt.of(this.ws.config()).getModel().getUser("admin", session);
            u.setCredentials(CoreStringUtils.chrToStr(this.createCredentials("admin".toCharArray(), false, null, session)));
            NutsWorkspaceConfigManagerExt.of(this.ws.config()).getModel().setUser(u, session);
        }
        if (Arrays.equals(credentials = CoreIOUtils.evalSHA1(adminPassword), adminPassword)) {
            Arrays.fill(credentials, '\u0000');
            throw new NutsSecurityException(session, NutsMessage.plain((String)"invalid credentials"));
        }
        Arrays.fill(credentials, '\u0000');
        boolean activated = false;
        if (this.isSecure(session)) {
            NutsWorkspaceConfigManagerExt.of(this.ws.config()).getModel().setSecure(false, session);
            activated = true;
        }
        return activated;
    }

    public boolean switchSecureMode(char[] adminPassword, NutsSession session) {
        if (adminPassword == null) {
            adminPassword = new char[]{};
        }
        boolean deactivated = false;
        char[] credentials = CoreIOUtils.evalSHA1(adminPassword);
        if (Arrays.equals(credentials, adminPassword)) {
            Arrays.fill(credentials, '\u0000');
            throw new NutsSecurityException(session, NutsMessage.plain((String)"invalid credentials"));
        }
        Arrays.fill(credentials, '\u0000');
        if (!this.isSecure(session)) {
            NutsWorkspaceConfigManagerExt.of(this.ws.config()).getModel().setSecure(true, session);
            deactivated = true;
        }
        return deactivated;
    }

    public boolean isAdmin(NutsSession session) {
        return "admin".equals(this.getCurrentUsername(session));
    }

    public void logout(NutsSession session) {
        Stack<LoginContext> r = this.loginContextStack.get();
        if (r == null || r.isEmpty()) {
            throw new NutsLoginException(session, NutsMessage.cstyle((String)"not logged in", (Object[])new Object[0]));
        }
        try {
            LoginContext loginContext = r.pop();
            loginContext.logout();
        }
        catch (LoginException ex) {
            throw new NutsLoginException(session, NutsMessage.plain((String)"login failed"), (Throwable)ex);
        }
    }

    public NutsUser findUser(String username, NutsSession session) {
        NutsUserConfig security = NutsWorkspaceConfigManagerExt.of(this.ws.config()).getModel().getUser(username, session);
        Stack<String> inherited = new Stack<String>();
        if (security != null) {
            Stack<String> visited = new Stack<String>();
            visited.push(username);
            Stack<String> curr = new Stack<String>();
            curr.addAll(Arrays.asList(security.getGroups()));
            while (!curr.empty()) {
                String s = (String)curr.pop();
                visited.add(s);
                NutsUserConfig ss = NutsWorkspaceConfigManagerExt.of(this.ws.config()).getModel().getUser(s, session);
                if (ss == null) continue;
                inherited.addAll(Arrays.asList(ss.getPermissions()));
                for (String group : ss.getGroups()) {
                    if (visited.contains(group)) continue;
                    curr.push(group);
                }
            }
        }
        return security == null ? null : new DefaultNutsUser(security, inherited.toArray(new String[0]));
    }

    public NutsUser[] findUsers(NutsSession session) {
        ArrayList<NutsUser> all = new ArrayList<NutsUser>();
        for (NutsUserConfig secu : NutsWorkspaceConfigManagerExt.of(this.ws.config()).getModel().getUsers(session)) {
            all.add(this.findUser(secu.getUser(), session));
        }
        return all.toArray(new NutsUser[0]);
    }

    public NutsAddUserCommand addUser(String name, NutsSession session) {
        return (NutsAddUserCommand)new DefaultNutsAddUserCommand(this.ws).setUsername(name).setSession(session);
    }

    public NutsUpdateUserCommand updateUser(String name, NutsSession session) {
        return new DefaultNutsUpdateUserCommand(this.ws).setUsername(name).setSession(session);
    }

    public NutsRemoveUserCommand removeUser(String name, NutsSession session) {
        return new DefaultNutsRemoveUserCommand(this.ws).setUsername(name).setSession(session);
    }

    public void checkAllowed(String permission, String operationName, NutsSession session) {
        if (!this.isAllowed(permission, session)) {
            if (NutsUtilStrings.isBlank((CharSequence)operationName)) {
                throw new NutsSecurityException(session, NutsMessage.cstyle((String)"%s not allowed!", (Object[])new Object[]{permission}));
            }
            throw new NutsSecurityException(session, NutsMessage.cstyle((String)"%s : %s not allowed!", (Object[])new Object[]{operationName, permission}));
        }
    }

    private NutsAuthorizations getAuthorizations(String n, NutsSession session) {
        NutsAuthorizations aa = this.authorizations.get(n);
        if (aa != null) {
            return aa;
        }
        NutsUserConfig s = NutsWorkspaceConfigManagerExt.of(this.ws.config()).getModel().getUser(n, session);
        if (s != null) {
            String[] rr = s.getPermissions();
            aa = new NutsAuthorizations(Arrays.asList(rr == null ? new String[]{} : rr));
            this.authorizations.put(n, aa);
        } else {
            aa = new NutsAuthorizations(Collections.emptyList());
        }
        return aa;
    }

    public boolean isAllowed(String permission, NutsSession session) {
        if (!this.isSecure(session)) {
            return true;
        }
        String name = this.getCurrentUsername(session);
        if (NutsUtilStrings.isBlank((CharSequence)name)) {
            return false;
        }
        if ("admin".equals(name)) {
            return true;
        }
        Stack<String> items = new Stack<String>();
        HashSet<String> visitedGroups = new HashSet<String>();
        visitedGroups.add(name);
        items.push(name);
        while (!items.isEmpty()) {
            String n = (String)items.pop();
            NutsAuthorizations s = this.getAuthorizations(n, session);
            Boolean ea = s.explicitAccept(permission);
            if (ea != null) {
                return ea;
            }
            NutsUserConfig uc = NutsWorkspaceConfigManagerExt.of(this.ws.config()).getModel().getUser(n, session);
            if (uc == null) continue;
            for (String g : uc.getGroups()) {
                if (visitedGroups.contains(g)) continue;
                visitedGroups.add(g);
                items.push(g);
            }
        }
        return false;
    }

    public String[] getCurrentLoginStack(NutsSession session) {
        ArrayList<String> logins = new ArrayList<String>();
        Stack<LoginContext> c = this.loginContextStack.get();
        if (c != null) {
            for (LoginContext loginContext : c) {
                Iterator<Principal> iterator;
                Subject subject = loginContext.getSubject();
                if (subject == null || !(iterator = subject.getPrincipals().iterator()).hasNext()) continue;
                Principal principal = iterator.next();
                logins.add(principal.getName());
            }
        }
        if (logins.isEmpty()) {
            if (this.ws.isInitializing()) {
                logins.add("admin");
            } else {
                logins.add("anonymous");
            }
        }
        return logins.toArray(new String[0]);
    }

    public String getCurrentUsername(NutsSession session) {
        if (this.ws.isInitializing()) {
            return "admin";
        }
        String name = null;
        Subject currentSubject = this.getLoginSubject();
        if (currentSubject != null) {
            for (Principal principal : currentSubject.getPrincipals()) {
                name = principal.getName();
                if (NutsUtilStrings.isBlank((CharSequence)name) || NutsUtilStrings.isBlank((CharSequence)name)) continue;
                return name;
            }
        }
        return "anonymous";
    }

    private Subject getLoginSubject() {
        LoginContext c = this.getLoginContext();
        if (c == null) {
            return null;
        }
        return c.getSubject();
    }

    public void login(final CallbackHandler handler, NutsSession session) {
        LoginContext login;
        NutsWorkspaceLoginModule.configure(this.ws);
        try {
            login = CorePlatformUtils.runWithinLoader(new Callable<LoginContext>(){

                @Override
                public LoginContext call() throws Exception {
                    return new LoginContext("nuts", handler);
                }
            }, NutsWorkspaceLoginModule.class.getClassLoader(), session);
            login.login();
        }
        catch (LoginException ex) {
            throw new NutsLoginException(session, NutsMessage.plain((String)"login failed"), (Throwable)ex);
        }
        Stack<LoginContext> r = this.loginContextStack.get();
        if (r == null) {
            r = new Stack();
            this.loginContextStack.set(r);
        }
        r.push(login);
    }

    private LoginContext getLoginContext() {
        Stack<LoginContext> c = this.loginContextStack.get();
        if (c == null) {
            return null;
        }
        if (c.isEmpty()) {
            return null;
        }
        return c.peek();
    }

    public NutsAuthenticationAgent getAuthenticationAgent(String authenticationAgentId, NutsSession session) {
        if (NutsUtilStrings.isBlank((CharSequence)(authenticationAgentId = NutsUtilStrings.trim((String)authenticationAgentId)))) {
            authenticationAgentId = NutsWorkspaceConfigManagerExt.of(this.ws.config()).getModel().getStoredConfigSecurity().getAuthenticationAgent();
        }
        NutsAuthenticationAgent a = NutsWorkspaceConfigManagerExt.of(this.ws.config()).getModel().createAuthenticationAgent(authenticationAgentId, session);
        return a;
    }

    public void setAuthenticationAgent(String authenticationAgentId, NutsSession session) {
        DefaultNutsWorkspaceConfigModel cc = NutsWorkspaceConfigManagerExt.of(this.ws.config()).getModel();
        if (cc.createAuthenticationAgent(authenticationAgentId, session) == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unsupported Authentication Agent %s", (Object[])new Object[]{authenticationAgentId}));
        }
        NutsWorkspaceConfigSecurity conf = cc.getStoredConfigSecurity();
        if (!Objects.equals(conf.getAuthenticationAgent(), authenticationAgentId)) {
            conf.setAuthenticationAgent(authenticationAgentId);
            cc.fireConfigurationChanged("authentication-agent", session, ConfigEventType.SECURITY);
        }
    }

    public boolean isSecure(NutsSession session) {
        return NutsWorkspaceConfigManagerExt.of(this.ws.config()).getModel().getStoredConfigSecurity().isSecure();
    }

    public void checkCredentials(char[] credentialsId, char[] password, NutsSession session) throws NutsSecurityException {
        this.agent.checkCredentials(credentialsId, password, session);
    }

    public char[] getCredentials(char[] credentialsId, NutsSession session) {
        return this.agent.getCredentials(credentialsId, session);
    }

    public boolean removeCredentials(char[] credentialsId, NutsSession session) {
        return this.agent.removeCredentials(credentialsId, session);
    }

    public char[] createCredentials(char[] credentials, boolean allowRetrieve, char[] credentialId, NutsSession session) {
        return this.agent.createCredentials(credentials, allowRetrieve, credentialId, session);
    }

    public NutsWorkspace getWorkspace() {
        return this.ws;
    }

    private class ClearAuthOnWorkspaceChange
    implements NutsWorkspaceListener {
        public void onConfigurationChanged(NutsWorkspaceEvent event) {
            DefaultNutsWorkspaceSecurityModel.this.authorizations.clear();
        }
    }
}

