/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.security;

import javax.security.auth.callback.CallbackHandler;
import net.thevpc.nuts.NutsAddUserCommand;
import net.thevpc.nuts.NutsAuthenticationAgent;
import net.thevpc.nuts.NutsRemoveUserCommand;
import net.thevpc.nuts.NutsSecurityException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUpdateUserCommand;
import net.thevpc.nuts.NutsUser;
import net.thevpc.nuts.NutsWorkspaceSecurityManager;
import net.thevpc.nuts.runtime.standalone.security.DefaultNutsWorkspaceSecurityModel;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsWorkspaceSecurityManager
implements NutsWorkspaceSecurityManager {
    public final DefaultNutsWorkspaceSecurityModel model;
    public NutsSession session;

    public DefaultNutsWorkspaceSecurityManager(DefaultNutsWorkspaceSecurityModel model) {
        this.model = model;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsWorkspaceSecurityManager setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public NutsWorkspaceSecurityManager login(String username, char[] password) {
        this.checkSession();
        this.model.login(username, password, this.session);
        return this;
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
    }

    public boolean setSecureMode(boolean secure, char[] adminPassword) {
        this.checkSession();
        return this.model.setSecureMode(secure, adminPassword, this.session);
    }

    public boolean switchUnsecureMode(char[] adminPassword) {
        this.checkSession();
        return this.model.switchUnsecureMode(adminPassword, this.session);
    }

    public boolean switchSecureMode(char[] adminPassword) {
        this.checkSession();
        return this.model.switchSecureMode(adminPassword, this.session);
    }

    public boolean isAdmin() {
        this.checkSession();
        return this.model.isAdmin(this.session);
    }

    public NutsWorkspaceSecurityManager logout() {
        this.checkSession();
        this.model.logout(this.session);
        return this;
    }

    public NutsUser findUser(String username) {
        this.checkSession();
        return this.model.findUser(username, this.session);
    }

    public NutsUser[] findUsers() {
        this.checkSession();
        return this.model.findUsers(this.session);
    }

    public NutsAddUserCommand addUser(String name) {
        this.checkSession();
        return this.model.addUser(name, this.session);
    }

    public NutsUpdateUserCommand updateUser(String name) {
        this.checkSession();
        return this.model.updateUser(name, this.session);
    }

    public NutsRemoveUserCommand removeUser(String name) {
        this.checkSession();
        return this.model.removeUser(name, this.session);
    }

    public NutsWorkspaceSecurityManager checkAllowed(String permission, String operationName) {
        this.checkSession();
        this.model.checkAllowed(permission, operationName, this.session);
        return this;
    }

    public boolean isAllowed(String permission) {
        this.checkSession();
        return this.model.isAllowed(permission, this.session);
    }

    public String[] getCurrentLoginStack() {
        this.checkSession();
        return this.model.getCurrentLoginStack(this.session);
    }

    public String getCurrentUsername() {
        this.checkSession();
        return this.model.getCurrentUsername(this.session);
    }

    public NutsWorkspaceSecurityManager login(CallbackHandler handler) {
        this.checkSession();
        this.model.login(handler, this.session);
        return this;
    }

    public NutsAuthenticationAgent getAuthenticationAgent(String authenticationAgentId) {
        this.checkSession();
        return this.model.getAuthenticationAgent(authenticationAgentId, this.session);
    }

    public NutsWorkspaceSecurityManager setAuthenticationAgent(String authenticationAgentId) {
        this.checkSession();
        this.model.setAuthenticationAgent(authenticationAgentId, this.session);
        return this;
    }

    public boolean isSecure() {
        this.checkSession();
        return this.model.isSecure(this.session);
    }

    public NutsWorkspaceSecurityManager checkCredentials(char[] credentialsId, char[] password) throws NutsSecurityException {
        this.checkSession();
        this.model.checkCredentials(credentialsId, password, this.session);
        return this;
    }

    public char[] getCredentials(char[] credentialsId) {
        this.checkSession();
        return this.model.getCredentials(credentialsId, this.session);
    }

    public boolean removeCredentials(char[] credentialsId) {
        this.checkSession();
        return this.model.removeCredentials(credentialsId, this.session);
    }

    public char[] createCredentials(char[] credentials, boolean allowRetrieve, char[] credentialId) {
        this.checkSession();
        return this.model.createCredentials(credentials, allowRetrieve, credentialId, this.session);
    }
}

