/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repos;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsPushException;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfigManager;
import net.thevpc.nuts.NutsRepositoryNotFoundException;
import net.thevpc.nuts.NutsSearchId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.iter.IteratorUtils;
import net.thevpc.nuts.runtime.bundles.iter.LazyIterator;
import net.thevpc.nuts.runtime.core.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.core.commands.repo.NutsRepositorySupportedAction;
import net.thevpc.nuts.runtime.core.events.DefaultNutsContentEvent;
import net.thevpc.nuts.runtime.core.filters.NutsSearchIdByDescriptor;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryExt;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryUtils;
import net.thevpc.nuts.runtime.standalone.repos.NutsRepositoryFolderHelper;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsDeployRepositoryCommand;
import net.thevpc.nuts.spi.NutsPushRepositoryCommand;
import net.thevpc.nuts.spi.NutsRepositoryCommand;
import net.thevpc.nuts.spi.NutsRepositorySPI;

public class NutsRepositoryMirroringHelper {
    private NutsRepository repo;
    protected NutsRepositoryFolderHelper cache;

    public NutsRepositoryMirroringHelper(NutsRepository repo, NutsRepositoryFolderHelper cache) {
        this.repo = repo;
        this.cache = cache;
    }

    protected Iterator<NutsId> searchVersionsImpl_appendMirrors(Iterator<NutsId> namedNutIdIterator, final NutsId id, final NutsIdFilter idFilter, final NutsFetchMode fetchMode, final NutsSession session) {
        if (!session.isTransitive()) {
            return namedNutIdIterator;
        }
        ArrayList list = new ArrayList();
        list.add(namedNutIdIterator);
        if (this.repo.config().setSession(session).isSupportedMirroring()) {
            for (NutsRepository repo : this.repo.config().setSession(session).getMirrors()) {
                int sup = 0;
                try {
                    sup = NutsRepositoryUtils.getSupportSpeedLevel(repo, NutsRepositorySupportedAction.SEARCH, id, fetchMode, session.isTransitive(), session);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (sup <= 0) continue;
                final NutsRepositorySPI repoSPI = NutsWorkspaceUtils.of(session).repoSPI(repo);
                list.add(IteratorUtils.safeIgnore(new LazyIterator<NutsId>(){

                    @Override
                    public Iterator<NutsId> iterator() {
                        return repoSPI.searchVersions().setId(id).setFilter(idFilter).setSession(session).setFetchMode(fetchMode).getResult();
                    }
                }));
            }
        }
        return IteratorUtils.concat(list);
    }

    protected NutsContent fetchContent(NutsId id, NutsDescriptor descriptor, String localPath, NutsFetchMode fetchMode, NutsSession session) {
        Path cacheContent = this.cache.getLongNameIdLocalFile(id, session);
        NutsRepositoryConfigManager rconfig = this.repo.config().setSession(session);
        if (session.isTransitive() && rconfig.isSupportedMirroring()) {
            for (NutsRepository mirror : rconfig.setSession(session).getMirrors()) {
                try {
                    NutsRepositorySPI repoSPI = NutsWorkspaceUtils.of(session).repoSPI(mirror);
                    NutsContent c = repoSPI.fetchContent().setId(id).setDescriptor(descriptor).setLocalPath(cacheContent.toString()).setSession(session).setFetchMode(fetchMode).getResult();
                    if (c != null) {
                        if (localPath == null) {
                            return c;
                        }
                        this.getWorkspace().io().copy().setSession(session).from(c.getFilePath()).to(localPath).setSafe(true).run();
                        return c;
                    }
                }
                catch (NutsNotFoundException nutsNotFoundException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public NutsWorkspace getWorkspace() {
        return this.repo.getWorkspace();
    }

    protected String getIdFilename(NutsId id, NutsSession session) {
        return NutsRepositoryExt.of(this.repo).getIdFilename(id, session);
    }

    protected NutsDescriptor fetchDescriptorImplInMirrors(NutsId id, NutsFetchMode fetchMode, NutsSession session) {
        String idFilename = this.getIdFilename(id, session);
        Path versionFolder = this.cache.getLongNameIdLocalFolder(id, session);
        NutsRepositoryConfigManager rconf = this.repo.config().setSession(session);
        if (session.isTransitive() && rconf.isSupportedMirroring()) {
            for (NutsRepository remote : rconf.getMirrors()) {
                NutsDescriptor nutsDescriptor = null;
                try {
                    NutsRepositorySPI repoSPI = NutsWorkspaceUtils.of(session).repoSPI(remote);
                    nutsDescriptor = repoSPI.fetchDescriptor().setId(id).setSession(session).setFetchMode(fetchMode).getResult();
                }
                catch (Exception repoSPI) {
                    // empty catch block
                }
                if (nutsDescriptor == null) continue;
                Path goodFile = null;
                goodFile = versionFolder.resolve(idFilename);
                this.getWorkspace().descriptor().setSession(session).formatter(nutsDescriptor).print(goodFile);
                return nutsDescriptor;
            }
        }
        return null;
    }

    public Iterator<NutsId> search(Iterator<NutsId> li, final NutsIdFilter filter, final NutsFetchMode fetchMode, final NutsSession session) {
        NutsRepositoryConfigManager rconfig = this.repo.config().setSession(session);
        if (!session.isTransitive() || !rconfig.isSupportedMirroring()) {
            return li;
        }
        ArrayList all = new ArrayList();
        all.add(li);
        for (NutsRepository remote : rconfig.setSession(session).getMirrors()) {
            final NutsRepositorySPI repoSPI = NutsWorkspaceUtils.of(session).repoSPI(remote);
            all.add(IteratorUtils.safeIgnore(new LazyIterator<NutsId>(){

                @Override
                public Iterator<NutsId> iterator() {
                    return repoSPI.search().setFilter(filter).setSession(session).setFetchMode(fetchMode).getResult();
                }
            }));
        }
        return IteratorUtils.concat(all);
    }

    public void push(NutsPushRepositoryCommand cmd) {
        NutsSession session = cmd.getSession();
        NutsWorkspaceUtils.checkSession(this.getWorkspace(), session);
        NutsId id = cmd.getId();
        String repository = cmd.getRepository();
        NutsSession nonTransitiveSession = session.copy().setTransitive(Boolean.valueOf(false));
        NutsRepositorySPI repoSPI = NutsWorkspaceUtils.of(session).repoSPI(this.repo);
        NutsDescriptor desc = repoSPI.fetchDescriptor().setId(id).setSession(nonTransitiveSession).setFetchMode(NutsFetchMode.LOCAL).getResult();
        NutsContent local = repoSPI.fetchContent().setId(id).setSession(nonTransitiveSession).setFetchMode(NutsFetchMode.LOCAL).getResult();
        if (local == null) {
            throw new NutsNotFoundException(session, id);
        }
        if (!this.repo.config().setSession(session).isSupportedMirroring()) {
            throw new NutsRepositoryNotFoundException(session, "Not Repo for pushing " + id);
        }
        NutsRepository repo = this.repo;
        if (NutsUtilStrings.isBlank((CharSequence)repository)) {
            ArrayList<NutsRepository> all = new ArrayList<NutsRepository>();
            for (NutsRepository remote : repo.config().setSession(session).getMirrors()) {
                int lvl = NutsRepositoryUtils.getSupportSpeedLevel(remote, NutsRepositorySupportedAction.DEPLOY, id, NutsFetchMode.LOCAL, false, session);
                if (lvl <= 0) continue;
                all.add(remote);
            }
            if (all.isEmpty()) {
                throw new NutsRepositoryNotFoundException(session, "Not Repo for pushing " + id);
            }
            if (all.size() > 1) {
                throw new NutsPushException(session, id, NutsMessage.cstyle((String)"unable to perform push for %s. At least two Repositories (%s) provides the same nuts %s", (Object[])new Object[]{id, all.stream().map(NutsRepository::getName).collect(Collectors.joining(",")), id}));
            }
            repo = (NutsRepository)all.get(0);
        } else {
            repo = this.repo.config().setSession(session.copy().setTransitive(Boolean.valueOf(false))).getMirror(repository);
        }
        if (repo == null) {
            throw new NutsRepositoryNotFoundException(session, repository);
        }
        NutsId effId = this.getWorkspace().config().createContentFaceId(id.builder().setProperties("").build(), desc);
        NutsDeployRepositoryCommand dep = repoSPI.deploy().setId(effId).setContent(local.getFilePath()).setDescriptor(desc).setSession(session).run();
        NutsRepositoryUtils.of(repo).events().fireOnPush(new DefaultNutsContentEvent(local.getLocation(), (NutsRepositoryCommand)dep, session, repo));
    }

    public NutsId searchLatestVersion(NutsId bestId, NutsId id, NutsIdFilter filter, NutsFetchMode fetchMode, NutsSession session) {
        NutsRepositoryConfigManager rconfig = this.repo.config().setSession(session);
        if (session.isTransitive() && rconfig.isSupportedMirroring()) {
            for (NutsRepository remote : rconfig.setSession(session).getMirrors()) {
                NutsDescriptor nutsDescriptor = null;
                try {
                    NutsRepositorySPI repoSPI = NutsWorkspaceUtils.of(session).repoSPI(remote);
                    nutsDescriptor = repoSPI.fetchDescriptor().setId(id).setSession(session).setFetchMode(fetchMode).getResult();
                }
                catch (Exception repoSPI) {
                    // empty catch block
                }
                if (nutsDescriptor == null || filter != null && !filter.acceptSearchId((NutsSearchId)new NutsSearchIdByDescriptor(nutsDescriptor), session)) continue;
                NutsWorkspaceExt dws = NutsWorkspaceExt.of(this.getWorkspace());
                NutsId id2 = dws.resolveEffectiveId(nutsDescriptor, session).builder().setFaceDescriptor().build();
                Path localNutFile = this.cache.getLongNameIdLocalFile(id2, session);
                this.getWorkspace().descriptor().formatter(nutsDescriptor).print(localNutFile);
                if (bestId != null && id2.getVersion().compareTo(bestId.getVersion()) <= 0) continue;
                bestId = id2;
            }
        }
        return bestId;
    }
}

