/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repos;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsDefaultContent;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchModeNotSupportedException;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIdLocation;
import net.thevpc.nuts.NutsInput;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.NutsUnsupportedOperationException;
import net.thevpc.nuts.runtime.bundles.iter.IteratorUtils;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.repos.FilesFoldersApi;
import net.thevpc.nuts.runtime.standalone.repos.NutsCachedRepository;
import net.thevpc.nuts.runtime.standalone.repos.RemoteRepoApi;

public class NutsHttpFolderRepository
extends NutsCachedRepository {
    private final NutsLogger LOG;
    private RemoteRepoApi versionApi = RemoteRepoApi.DEFAULT;
    private RemoteRepoApi findApi = RemoteRepoApi.DEFAULT;
    private FilesFoldersApi.IteratorModel findModel = new FilesFoldersApi.AbstractIteratorModel(){

        @Override
        public void undeploy(NutsId id, NutsSession session) throws NutsExecutionException {
            throw new NutsUnsupportedOperationException(session, NutsMessage.cstyle((String)"not supported undeploy.", (Object[])new Object[0]));
        }

        @Override
        public boolean isDescFile(String pathname) {
            return NutsHttpFolderRepository.this.isDescFile0(pathname);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NutsDescriptor parseDescriptor(String pathname, InputStream in, NutsFetchMode fetchMode, NutsRepository repository, NutsSession session, String rootURL) throws IOException {
            try {
                NutsDescriptor nutsDescriptor = NutsHttpFolderRepository.this.getWorkspace().descriptor().parser().setSession(session).parse(in);
                return nutsDescriptor;
            }
            finally {
                in.close();
            }
        }
    };

    public NutsHttpFolderRepository(NutsAddRepositoryOptions options, NutsSession session, NutsRepository parentRepository) {
        super(options, session, parentRepository, 1000, false, "nuts");
        this.LOG = session.getWorkspace().log().of(NutsHttpFolderRepository.class);
    }

    private boolean isDescFile0(String pathname) {
        return pathname.equals("nuts.json") || pathname.endsWith("/nuts.json") || pathname.endsWith(".nuts");
    }

    protected InputStream getDescStream(NutsId id, NutsSession session) {
        String url = this.getDescPath(id, session);
        return this.openStream(url, id, "artifact descriptor", session);
    }

    protected String getPath(NutsId id, NutsSession session) {
        return this.getIdRemotePath(id, session);
    }

    protected String getDescPath(NutsId id, NutsSession session) {
        String groupId = id.getGroupId();
        String artifactId = id.getArtifactId();
        String version = id.getVersion().getValue();
        return CoreIOUtils.buildUrl(this.config().getLocation(true), groupId.replace('.', '/') + "/" + artifactId + "/" + version + "/" + "nuts.json");
    }

    protected InputStream openStream(String path, Object source, String sourceTypeName, NutsSession session) {
        return this.getWorkspace().io().monitor().setSource(path).setOrigin(source).setSourceTypeName(sourceTypeName).setSession(session).create();
    }

    protected NutsInput openStream(NutsId id, String path, Object source, String sourceTypeName, NutsSession session) {
        return this.getWorkspace().io().monitor().setSource(path).setOrigin(source).setSourceTypeName(sourceTypeName).setSession(session).createSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<NutsId> findVersionsImplGithub(NutsId id, NutsIdFilter idFilter, NutsSession session) {
        String location = this.config().getLocation(true);
        String[] all = location.split("/+");
        String userName = all[2];
        String repo = all[3];
        String apiUrlBase = "https://api.github.com/repos/" + userName + "/" + repo + "/contents";
        String groupId = id.getGroupId();
        String artifactId = id.getArtifactId();
        InputStream metadataStream = null;
        ArrayList<NutsId> ret = new ArrayList<NutsId>();
        try {
            String metadataURL = CoreIOUtils.buildUrl(apiUrlBase, groupId.replace('.', '/') + "/" + artifactId);
            try {
                metadataStream = this.openStream(id, metadataURL, id.builder().setFace("catalog").build(), "artifact catalog", session).open();
            }
            catch (UncheckedIOException | NutsIOException ex) {
                throw new NutsNotFoundException(session, id, ex);
            }
            List info = (List)this.getWorkspace().elem().setContentType(NutsContentType.JSON).parse((Reader)new InputStreamReader(metadataStream), List.class);
            if (info != null) {
                for (Map version : info) {
                    if (!"dir".equals(version.get("type"))) continue;
                    String versionName = (String)version.get("name");
                    NutsId nutsId = id.builder().setVersion(versionName).build();
                    if (idFilter != null && !idFilter.acceptId(nutsId, session)) continue;
                    ret.add(this.getWorkspace().id().builder().setGroupId(groupId).setArtifactId(artifactId).setVersion(versionName).build());
                }
            }
        }
        finally {
            if (metadataStream != null) {
                try {
                    metadataStream.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        return ret.iterator();
    }

    public Iterator<NutsId> findVersionsImplFilesFolders(NutsId id, NutsIdFilter idFilter, RemoteRepoApi versionApi, NutsSession session) {
        String groupId = id.getGroupId();
        String artifactId = id.getArtifactId();
        try {
            String artifactUrl = CoreIOUtils.buildUrl(this.config().getLocation(true), groupId.replace('.', '/') + "/" + artifactId);
            FilesFoldersApi.Item[] all = FilesFoldersApi.getDirItems(true, false, versionApi, artifactUrl, session);
            ArrayList<NutsId> n = new ArrayList<NutsId>();
            for (FilesFoldersApi.Item s : all) {
                if (s.isFolder() && s.getName().equals("LATEST")) continue;
                String versionFilesUrl = artifactUrl + "/" + s.getName();
                FilesFoldersApi.Item[] versionFiles = FilesFoldersApi.getDirItems(false, true, versionApi, versionFilesUrl, session);
                boolean validVersion = false;
                for (FilesFoldersApi.Item v : versionFiles) {
                    if (!"nuts.properties".equals(v.getName())) continue;
                    validVersion = true;
                    break;
                }
                if (!validVersion) continue;
                NutsId id2 = id.builder().setVersion(s.getName()).build();
                if (idFilter != null && !idFilter.acceptId(id2, session)) continue;
                n.add(id2);
            }
            return n.iterator();
        }
        catch (Exception ex) {
            this.LOG.with().session(session).level(Level.SEVERE).error((Throwable)ex).log("error find versions : {0}", new Object[]{ex});
            return null;
        }
    }

    @Override
    public Iterator<NutsId> searchVersionsCore(NutsId id, NutsIdFilter idFilter, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        if (id.getVersion().isSingleValue()) {
            String groupId = id.getGroupId();
            String artifactId = id.getArtifactId();
            ArrayList<NutsId> ret = new ArrayList<NutsId>();
            String metadataURL = CoreIOUtils.buildUrl(this.config().getLocation(true), groupId.replace('.', '/') + "/" + artifactId + "/" + id.getVersion().toString() + "/" + this.getIdFilename(id.builder().setFaceDescriptor().build(), session));
            try (InputStream metadataStream = this.openStream(id, metadataURL, id.builder().setFace("catalog").build(), "artifact catalog", session).open();){
                ret.add(id);
            }
            catch (IOException | UncheckedIOException exception) {
                // empty catch block
            }
            return ret.iterator();
        }
        NutsIdFilter filter2 = ((NutsIdFilter)this.getWorkspace().id().filter().nonnull((NutsFilter)idFilter)).and(this.getWorkspace().id().filter().byName(new String[]{id.getShortName()}));
        switch (this.versionApi) {
            case DEFAULT: 
            case MAVEN: 
            case DIR_TEXT: {
                return this.findVersionsImplFilesFolders(id, filter2, RemoteRepoApi.DIR_TEXT, session);
            }
            case DIR_LIST: {
                return this.findVersionsImplFilesFolders(id, filter2, RemoteRepoApi.DIR_LIST, session);
            }
            case GITHUB: {
                return this.findVersionsImplGithub(id, filter2, session);
            }
            case UNSUPPORTED: {
                return null;
            }
        }
        throw new NutsUnsupportedEnumException(session, (Enum)this.versionApi);
    }

    @Override
    public NutsId searchLatestVersionCore(NutsId id, NutsIdFilter filter, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        Iterator<NutsId> allVersions = this.searchVersionsCore(id, filter, fetchMode, session);
        NutsId a = null;
        while (allVersions != null && allVersions.hasNext()) {
            NutsId next = allVersions.next();
            if (a != null && next.getVersion().compareTo(a.getVersion()) <= 0) continue;
            a = next;
        }
        return a;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NutsDescriptor fetchDescriptorCore(NutsId id, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        try (InputStream stream = this.getDescStream(id, session);){
            NutsDescriptor nutsDescriptor = this.getWorkspace().descriptor().parser().setSession(session).parse(stream);
            return nutsDescriptor;
        }
        catch (IOException | UncheckedIOException | NutsIOException ex) {
            throw new NutsNotFoundException(session, id, ex);
        }
    }

    @Override
    public NutsContent fetchContentCore(NutsId id, NutsDescriptor descriptor, String localFile, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            throw new NutsNotFoundException(session, id, (Throwable)new NutsFetchModeNotSupportedException(session, (NutsRepository)this, fetchMode, id.toString(), null));
        }
        if (descriptor.getLocations().length == 0) {
            String path = this.getPath(id, session);
            this.getWorkspace().io().copy().setSession(session).from(path).to(localFile).setSafe(true).setLogProgress(true).run();
            return new NutsDefaultContent(session.getWorkspace().io().path(localFile), false, false);
        }
        for (NutsIdLocation location : descriptor.getLocations()) {
            if (!CoreNutsUtils.acceptClassifier(location, id.getClassifier())) continue;
            try {
                this.getWorkspace().io().copy().setSession(session).from(location.getUrl()).to(localFile).setSafe(true).setLogProgress(true).run();
                return new NutsDefaultContent(session.getWorkspace().io().path(localFile), false, false);
            }
            catch (Exception ex) {
                this.LOG.with().session(session).level(Level.SEVERE).error((Throwable)ex).log("unable to download location for id {0} in location {1} : {2}", new Object[]{id, location.getUrl(), ex});
            }
        }
        return null;
    }

    @Override
    public Iterator<NutsId> searchCore(NutsIdFilter filter, String[] roots, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            return null;
        }
        switch (this.findApi) {
            case DEFAULT: 
            case MAVEN: 
            case DIR_TEXT: 
            case GITHUB: {
                ArrayList li = new ArrayList();
                for (String root : roots) {
                    if (root.endsWith("/*")) {
                        String name = root.substring(0, root.length() - 2);
                        li.add(FilesFoldersApi.createIterator(this.getWorkspace(), this, this.config().getLocation(true), name, filter, RemoteRepoApi.DIR_TEXT, session, Integer.MAX_VALUE, this.findModel));
                        continue;
                    }
                    li.add(FilesFoldersApi.createIterator(this.getWorkspace(), this, this.config().getLocation(true), root, filter, RemoteRepoApi.DIR_TEXT, session, 2, this.findModel));
                }
                return IteratorUtils.concat(li);
            }
            case DIR_LIST: {
                ArrayList li = new ArrayList();
                for (String root : roots) {
                    if (root.endsWith("/*")) {
                        String name = root.substring(0, root.length() - 2);
                        li.add(FilesFoldersApi.createIterator(this.getWorkspace(), this, this.config().getLocation(true), name, filter, RemoteRepoApi.DIR_LIST, session, Integer.MAX_VALUE, this.findModel));
                        continue;
                    }
                    li.add(FilesFoldersApi.createIterator(this.getWorkspace(), this, this.config().getLocation(true), root, filter, RemoteRepoApi.DIR_LIST, session, 2, this.findModel));
                }
                return IteratorUtils.concat(li);
            }
            case UNSUPPORTED: {
                return null;
            }
        }
        throw new NutsUnsupportedEnumException(session, (Enum)this.versionApi);
    }

    @Override
    public boolean isAcceptFetchMode(NutsFetchMode mode, NutsSession session) {
        return true;
    }

    @Override
    public boolean isRemote() {
        return true;
    }
}

