/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repos;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsDefaultContent;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsFetchModeNotSupportedException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.bundles.io.CommonRootsHelper;
import net.thevpc.nuts.runtime.bundles.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.bundles.iter.IteratorUtils;
import net.thevpc.nuts.runtime.bundles.string.GlobUtils;
import net.thevpc.nuts.runtime.core.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.core.commands.repo.NutsRepositorySupportedAction;
import net.thevpc.nuts.runtime.core.common.SuccessFailResult;
import net.thevpc.nuts.runtime.standalone.repocommands.AbstractNutsUpdateRepositoryStatisticsCommand;
import net.thevpc.nuts.runtime.standalone.repos.AbstractNutsRepositoryBase;
import net.thevpc.nuts.runtime.standalone.repos.NutsRepositoryFolderHelper;
import net.thevpc.nuts.runtime.standalone.repos.NutsRepositoryMirroringHelper;
import net.thevpc.nuts.spi.NutsDeployRepositoryCommand;
import net.thevpc.nuts.spi.NutsPushRepositoryCommand;
import net.thevpc.nuts.spi.NutsRepositoryUndeployCommand;
import net.thevpc.nuts.spi.NutsUpdateRepositoryStatisticsCommand;

public class NutsCachedRepository
extends AbstractNutsRepositoryBase {
    public NutsLogger LOG;
    protected final NutsRepositoryFolderHelper lib;
    protected final NutsRepositoryFolderHelper cache;
    private final NutsRepositoryMirroringHelper mirroring;

    public NutsCachedRepository(NutsAddRepositoryOptions options, NutsSession session, NutsRepository parent, int speed, boolean supportedMirroring, String repositoryType) {
        super(options, session, parent, speed, supportedMirroring, repositoryType);
        this.cache = new NutsRepositoryFolderHelper(this, this.workspace, Paths.get(this.config().setSession(session).getStoreLocation(NutsStoreLocation.CACHE), new String[0]), true);
        this.lib = new NutsRepositoryFolderHelper(this, this.workspace, Paths.get(this.config().setSession(session).getStoreLocation(NutsStoreLocation.LIB), new String[0]), false);
        this.mirroring = new NutsRepositoryMirroringHelper(this, this.cache);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = session.getWorkspace().log().of(NutsCachedRepository.class);
        }
        return this.LOG;
    }

    @Override
    public NutsDescriptor fetchDescriptorImpl(NutsId id, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            NutsDescriptor cacheDesc;
            NutsDescriptor libDesc = this.lib.fetchDescriptorImpl(id, session);
            if (libDesc != null) {
                return libDesc;
            }
            if (this.cache.isReadEnabled() && (cacheDesc = this.cache.fetchDescriptorImpl(id, session)) != null) {
                return cacheDesc;
            }
        }
        RuntimeException mirrorsEx = null;
        SuccessFailResult res = (SuccessFailResult)session.getWorkspace().concurrent().lock().setSource((Object)id.builder().setFaceDescriptor().build()).call(() -> {
            try {
                NutsDescriptor success = this.fetchDescriptorCore(id, fetchMode, session);
                if (success != null) {
                    if (this.cache.isWriteEnabled()) {
                        NutsId id0 = NutsWorkspaceExt.of(this.getWorkspace()).resolveEffectiveId(success, session);
                        if (!id0.getLongName().equals(success.getId().getLongName())) {
                            success = success.builder().setId(id0).build();
                        }
                        this.cache.deployDescriptor(success.getId(), success, NutsConfirmationMode.YES, session.copy().setConfirm(NutsConfirmationMode.YES));
                    }
                    return SuccessFailResult.success(success);
                }
                return SuccessFailResult.fail(new NutsNotFoundException(session, id));
            }
            catch (RuntimeException ex) {
                return SuccessFailResult.fail(ex);
            }
        });
        if (res.getSuccess() != null) {
            return (NutsDescriptor)res.getSuccess();
        }
        NutsDescriptor m = null;
        try {
            m = this.mirroring.fetchDescriptorImplInMirrors(id, fetchMode, session);
        }
        catch (RuntimeException ex) {
            mirrorsEx = ex;
        }
        if (m != null) {
            return m;
        }
        if (res.getFail() != null) {
            throw (RuntimeException)res.getFail();
        }
        if (mirrorsEx != null) {
            throw mirrorsEx;
        }
        return m;
    }

    @Override
    public NutsDescriptor deployImpl(NutsDeployRepositoryCommand command) {
        return this.lib.deploy(command, NutsConfirmationMode.YES);
    }

    @Override
    public void pushImpl(NutsPushRepositoryCommand command) {
        this.mirroring.push(command);
    }

    @Override
    public final Iterator<NutsId> searchImpl(NutsIdFilter filter, NutsFetchMode fetchMode, NutsSession session) {
        List<CommonRootsHelper.PathBase> roots = CommonRootsHelper.resolveRootPaths(filter);
        ArrayList li = new ArrayList();
        ArrayList<String> rootStrings = new ArrayList<String>();
        for (CommonRootsHelper.PathBase root : roots) {
            li.add(this.lib.findInFolder(Paths.get(root.getName(), new String[0]), filter, root.isDeep() ? Integer.MAX_VALUE : 2, session));
            if (this.cache.isReadEnabled() && session.isCached()) {
                li.add(this.cache.findInFolder(Paths.get(root.getName(), new String[0]), filter, root.isDeep() ? Integer.MAX_VALUE : 2, session));
            }
            if (root.isDeep()) {
                rootStrings.add(root.getName() + "/*");
                continue;
            }
            rootStrings.add(root.getName());
        }
        Iterator<NutsId> p = null;
        try {
            p = this.searchCore(filter, rootStrings.toArray(new String[0]), fetchMode, session);
        }
        catch (NutsNotFoundException root) {
        }
        catch (Exception ex) {
            this._LOGOP(session).level(Level.SEVERE).error((Throwable)ex).log("search latest versions error : {0}", new Object[]{ex});
        }
        if (p != null) {
            li.add(p);
        }
        return this.mirroring.search(IteratorBuilder.ofList(li).distinct(NutsId::getLongName).build(), filter, fetchMode, session);
    }

    @Override
    public final NutsContent fetchContentImpl(NutsId id, NutsDescriptor descriptor, String localPath, NutsFetchMode fetchMode, NutsSession session) {
        if (fetchMode != NutsFetchMode.REMOTE) {
            NutsContent c = this.lib.fetchContentImpl(id, localPath, session);
            if (c != null) {
                return c;
            }
            if (this.cache.isReadEnabled() && (c = this.cache.fetchContentImpl(id, localPath, session)) != null) {
                return c;
            }
        }
        RuntimeException mirrorsEx = null;
        NutsContent c = null;
        SuccessFailResult res = (SuccessFailResult)session.getWorkspace().concurrent().lock().setSource((Object)id.builder().setFaceContent().build()).call(() -> {
            if (this.cache.isWriteEnabled()) {
                Path cachePath = this.cache.getLongNameIdLocalFile(id, session);
                NutsContent c2 = this.fetchContentCore(id, descriptor, cachePath.toString(), fetchMode, session);
                if (c2 != null) {
                    String localPath2 = localPath;
                    if (localPath2 != null) {
                        this.getWorkspace().io().copy().setSession(session).from(cachePath).to(localPath2).run();
                    } else {
                        localPath2 = cachePath.toString();
                    }
                    return SuccessFailResult.success(new NutsDefaultContent(session.getWorkspace().io().path(localPath2), true, false));
                }
                return SuccessFailResult.fail(new NutsNotFoundException(session, id));
            }
            NutsContent c2 = null;
            RuntimeException impl2Ex = null;
            try {
                c2 = this.fetchContentCore(id, descriptor, localPath, fetchMode, session);
            }
            catch (RuntimeException ex) {
                impl2Ex = ex;
            }
            if (c2 != null) {
                return SuccessFailResult.success(c2);
            }
            if (impl2Ex != null) {
                return SuccessFailResult.fail(impl2Ex);
            }
            return SuccessFailResult.fail(new NutsNotFoundException(session, id));
        });
        if (res.getSuccess() != null) {
            return (NutsContent)res.getSuccess();
        }
        try {
            c = this.mirroring.fetchContent(id, descriptor, localPath, fetchMode, session);
        }
        catch (RuntimeException ex) {
            mirrorsEx = ex;
        }
        if (c != null) {
            return c;
        }
        if (res.getFail() != null) {
            if (res.getFail() instanceof NutsNotFoundException) {
                throw (RuntimeException)res.getFail();
            }
            throw new NutsNotFoundException(session, id, res.getFail());
        }
        if (mirrorsEx != null) {
            if (mirrorsEx instanceof NutsNotFoundException) {
                throw mirrorsEx;
            }
            throw new NutsNotFoundException(session, id, (Throwable)mirrorsEx);
        }
        throw new NutsNotFoundException(session, id);
    }

    protected boolean isAllowedOverrideNut(NutsId id) {
        return true;
    }

    @Override
    public final void undeployImpl(NutsRepositoryUndeployCommand options) {
        this.lib.undeploy(options);
    }

    @Override
    public final Iterator<NutsId> searchVersionsImpl(NutsId id, NutsIdFilter idFilter, NutsFetchMode fetchMode, NutsSession session) {
        ArrayList all = new ArrayList();
        if (fetchMode != NutsFetchMode.REMOTE) {
            try {
                all.add(this.lib.searchVersions(id, idFilter, true, session));
                if (this.cache.isReadEnabled()) {
                    all.add(this.cache.searchVersions(id, idFilter, true, session));
                }
                Object var6_6 = null;
            }
            catch (NutsNotFoundException nutsNotFoundException) {
                // empty catch block
            }
        }
        try {
            Iterator<NutsId> p = null;
            p = this.searchVersionsCore(id, idFilter, fetchMode, session);
            if (p != null) {
                all.add(p);
            }
        }
        catch (NutsNotFoundException p) {
        }
        catch (Exception ex) {
            this._LOGOP(session).level(Level.SEVERE).error((Throwable)ex).log("search versions error : {0}", new Object[]{ex});
        }
        Iterator<Object> namedNutIdIterator = IteratorBuilder.ofList(all).distinct(NutsId::getLongName).build();
        if (namedNutIdIterator == null) {
            namedNutIdIterator = IteratorUtils.emptyIterator();
        }
        return this.mirroring.searchVersionsImpl_appendMirrors(namedNutIdIterator, id, idFilter, fetchMode, session);
    }

    @Override
    public final NutsId searchLatestVersion(NutsId id, NutsIdFilter filter, NutsFetchMode fetchMode, NutsSession session) {
        if (id.getVersion().isBlank() && filter == null) {
            NutsId bestId = this.lib.searchLatestVersion(id, filter, session);
            NutsId c1 = null;
            if (this.cache.isReadEnabled()) {
                c1 = this.cache.searchLatestVersion(id, filter, session);
                if (bestId == null || c1 != null && c1.getVersion().compareTo(bestId.getVersion()) > 0) {
                    bestId = c1;
                }
            }
            try {
                c1 = this.searchLatestVersionCore(id, filter, fetchMode, session);
                if (bestId == null || c1 != null && c1.getVersion().compareTo(bestId.getVersion()) > 0) {
                    bestId = c1;
                }
            }
            catch (NutsFetchModeNotSupportedException | NutsNotFoundException throwable) {
            }
            catch (Exception ex) {
                this._LOGOP(session).level(Level.SEVERE).error((Throwable)ex).log("search latest versions error : {0}", new Object[]{ex});
            }
            return this.mirroring.searchLatestVersion(bestId, id, filter, fetchMode, session);
        }
        return super.searchLatestVersion(id, filter, fetchMode, session);
    }

    @Override
    public final NutsUpdateRepositoryStatisticsCommand updateStatistics() {
        return new AbstractNutsUpdateRepositoryStatisticsCommand(this){

            @Override
            public NutsUpdateRepositoryStatisticsCommand run() {
                NutsCachedRepository.this.lib.reindexFolder(this.getSession());
                if (NutsCachedRepository.this.cache.isWriteEnabled()) {
                    NutsCachedRepository.this.cache.reindexFolder(this.getSession());
                }
                NutsCachedRepository.this.updateStatistics2(this.getSession());
                return this;
            }
        };
    }

    public Iterator<NutsId> searchVersionsCore(NutsId id, NutsIdFilter idFilter, NutsFetchMode fetchMode, NutsSession session) {
        return null;
    }

    public NutsId searchLatestVersionCore(NutsId id, NutsIdFilter filter, NutsFetchMode fetchMode, NutsSession session) {
        return null;
    }

    public NutsDescriptor fetchDescriptorCore(NutsId id, NutsFetchMode fetchMode, NutsSession session) {
        return null;
    }

    public NutsContent fetchContentCore(NutsId id, NutsDescriptor descriptor, String localPath, NutsFetchMode fetchMode, NutsSession session) {
        return null;
    }

    public Iterator<NutsId> searchCore(NutsIdFilter filter, String[] roots, NutsFetchMode fetchMode, NutsSession session) {
        return null;
    }

    public void updateStatistics2(NutsSession session) {
    }

    @Override
    public boolean acceptAction(NutsId id, NutsRepositorySupportedAction supportedAction, NutsFetchMode mode, NutsSession session) {
        String groups = this.config().setSession(session).getGroups();
        if (NutsUtilStrings.isBlank((CharSequence)groups)) {
            return true;
        }
        return GlobUtils.ofExact(groups).matcher(id.getGroupId()).matches();
    }

    public boolean isAcceptFetchMode(NutsFetchMode mode, NutsSession session) {
        return true;
    }

    public boolean isRemote() {
        return true;
    }
}

