/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repos;

import java.util.Iterator;
import java.util.Stack;
import java.util.logging.Level;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnexpectedException;
import net.thevpc.nuts.NutsUnsupportedOperationException;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.repos.FilesFoldersApi;
import net.thevpc.nuts.runtime.standalone.repos.RemoteRepoApi;

class FilesFoldersApiIdIterator
implements Iterator<NutsId> {
    private final NutsRepository repository;
    private final Stack<PathAndDepth> stack = new Stack();
    private final NutsIdFilter filter;
    private final NutsSession session;
    private final NutsWorkspace workspace;
    private final FilesFoldersApi.IteratorModel model;
    private final int maxDepth;
    private NutsId last;
    private long visitedFoldersCount;
    private long visitedFilesCount;
    private String rootUrl;
    private RemoteRepoApi strategy;

    public FilesFoldersApiIdIterator(NutsWorkspace workspace, NutsRepository repository, String rootUrl, String basePath, NutsIdFilter filter, RemoteRepoApi strategy, NutsSession session, FilesFoldersApi.IteratorModel model, int maxDepth) {
        this.repository = repository;
        this.strategy = strategy;
        if (strategy != RemoteRepoApi.DIR_LIST && strategy != RemoteRepoApi.DIR_TEXT) {
            throw new NutsUnexpectedException(session, NutsMessage.cstyle((String)"unexpected strategy ", (Object[])new Object[]{strategy}));
        }
        this.session = session;
        this.filter = filter;
        this.workspace = workspace;
        this.model = model;
        this.maxDepth = maxDepth;
        if (rootUrl == null) {
            throw new NullPointerException("Could not iterate over null folder");
        }
        if (rootUrl.endsWith("/") && !rootUrl.endsWith("//")) {
            rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
        }
        this.rootUrl = rootUrl;
        String startUrl = rootUrl;
        if (basePath != null && basePath.length() > 0 && !basePath.equals("/")) {
            if (!startUrl.endsWith("/") && !basePath.startsWith("/")) {
                startUrl = startUrl + "/";
            }
            startUrl = startUrl + basePath;
        }
        this.stack.push(new PathAndDepth(startUrl, true, 0));
    }

    @Override
    public boolean hasNext() {
        this.last = null;
        while (!this.stack.isEmpty()) {
            PathAndDepth file = this.stack.pop();
            if (file.folder) {
                FilesFoldersApi.Item[] children = FilesFoldersApi.getDirItems(true, true, this.strategy, file.path, this.session);
                ++this.visitedFoldersCount;
                boolean deep = file.depth < this.maxDepth;
                for (FilesFoldersApi.Item child : children) {
                    if (child.isFolder()) {
                        if (!deep || file.depth >= this.maxDepth) continue;
                        this.stack.push(new PathAndDepth(file.path + "/" + child.getName(), true, file.depth + 1));
                        continue;
                    }
                    if (!this.model.isDescFile(child.getName())) continue;
                    this.stack.push(new PathAndDepth(file.path + "/" + child.getName(), false, file.depth));
                }
                continue;
            }
            ++this.visitedFilesCount;
            NutsId t = null;
            try {
                t = this.model.parseId(file.path, this.rootUrl, this.filter, this.repository, this.session);
            }
            catch (Exception ex) {
                this.session.getWorkspace().log().of(FilesFoldersApi.class).with().session(this.session).level(Level.FINE).error((Throwable)ex).log("error parsing url : {0} : {1}", new Object[]{file.path, this.toString()});
            }
            if (t == null) continue;
            this.last = t;
            break;
        }
        return this.last != null;
    }

    @Override
    public NutsId next() {
        NutsId ret = this.last;
        this.last = null;
        return ret;
    }

    @Override
    public void remove() {
        if (this.last != null) {
            this.model.undeploy(this.last, this.session);
        }
        throw new NutsUnsupportedOperationException(this.session, NutsMessage.cstyle((String)"unsupported Remove", (Object[])new Object[0]));
    }

    public long getVisitedFoldersCount() {
        return this.visitedFoldersCount;
    }

    public long getVisitedFilesCount() {
        return this.visitedFilesCount;
    }

    private static class PathAndDepth {
        private String path;
        private int depth;
        private boolean folder;

        public PathAndDepth(String path, boolean folder, int depth) {
            this.path = path;
            this.folder = folder;
            this.depth = depth;
        }
    }
}

