/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repos;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSearchId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnexpectedException;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.parsers.StringTokenizerUtils;
import net.thevpc.nuts.runtime.core.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.core.filters.NutsSearchIdByDescriptor;
import net.thevpc.nuts.runtime.core.filters.NutsSearchIdById;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.repos.FilesFoldersApiIdIterator;
import net.thevpc.nuts.runtime.standalone.repos.RemoteRepoApi;
import net.thevpc.nuts.runtime.standalone.repos.WebHtmlListParser;

public class FilesFoldersApi {
    private static Item[] getDirList(boolean folders, boolean files, String baseUrl, NutsSession session) {
        ArrayList<Item> all = new ArrayList<Item>();
        NutsWorkspace ws = session.getWorkspace();
        String dotFilesUrl = baseUrl;
        try {
            session.getTerminal().printProgress("%-8s %s", new Object[]{"browse", session.getWorkspace().io().path(baseUrl).toCompressedForm()});
            List<String> splitted = null;
            try (InputStream foldersFileStream = ws.io().monitor().setSource(dotFilesUrl).setSession(session).create();){
                splitted = new WebHtmlListParser().parse(foldersFileStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (splitted != null) {
                for (String s : splitted) {
                    if (s.endsWith("/")) {
                        int y = (s = s.substring(0, s.length() - 1)).lastIndexOf(47);
                        if (y > 0) {
                            s = s.substring(y + 1);
                        }
                        if (s.length() <= 0 || s.equals("..") || !folders) continue;
                        all.add(new Item(true, s));
                        continue;
                    }
                    if (!files) continue;
                    int y = s.lastIndexOf(47);
                    if (y > 0) {
                        s = s.substring(y + 1);
                    }
                    all.add(new Item(false, s));
                }
            }
        }
        catch (UncheckedIOException | NutsIOException ex) {
            ws.log().of(FilesFoldersApi.class).with().session(session).level(Level.FINE).verb(NutsLogVerb.FAIL).log("unable to navigate : file not found {0}", new Object[]{dotFilesUrl});
        }
        return all.toArray(new Item[0]);
    }

    public static Item[] getDirItems(boolean folders, boolean files, RemoteRepoApi strategy, String baseUrl, NutsSession session) {
        switch (strategy) {
            case DIR_TEXT: {
                return FilesFoldersApi.getDirText(folders, files, baseUrl, session);
            }
            case DIR_LIST: {
                return FilesFoldersApi.getDirList(folders, files, baseUrl, session);
            }
        }
        throw new NutsUnexpectedException(session, NutsMessage.cstyle((String)"unexpected strategy %s", (Object[])new Object[]{strategy}));
    }

    private static Item[] getDirText(boolean folders, boolean files, String baseUrl, NutsSession session) {
        ArrayList<Item> all = new ArrayList<Item>();
        NutsWorkspace ws = session.getWorkspace();
        InputStream foldersFileStream = null;
        String dotFilesUrl = baseUrl + "/" + ".files";
        NutsVersion versionString = ws.version().parser().parse("0.5.5");
        try {
            session.getTerminal().printProgress("%-8s %s", new Object[]{"browse", session.getWorkspace().io().path(baseUrl).toCompressedForm()});
            foldersFileStream = ws.io().monitor().setSource(dotFilesUrl).setSession(session).create();
            List<String> splitted = StringTokenizerUtils.split(CoreIOUtils.loadString(foldersFileStream, true), "\n\r");
            for (String s : splitted) {
                int y;
                if ((s = s.trim()).length() <= 0) continue;
                if (s.startsWith("#")) {
                    if (!all.isEmpty() || !(s = s.substring(1).trim()).startsWith("version=")) continue;
                    versionString = ws.version().parser().parse(s.substring("version=".length()).trim());
                    continue;
                }
                if (versionString.compareTo("0.5.7") < 0) {
                    if (files) {
                        all.add(new Item(false, s));
                        continue;
                    }
                    break;
                }
                if (s.endsWith("/")) {
                    y = (s = s.substring(0, s.length() - 1)).lastIndexOf(47);
                    if (y > 0) {
                        s = s.substring(y + 1);
                    }
                    if (s.length() <= 0 || s.equals("..") || !folders) continue;
                    all.add(new Item(true, s));
                    continue;
                }
                if (!files) continue;
                y = s.lastIndexOf(47);
                if (y > 0) {
                    s = s.substring(y + 1);
                }
                all.add(new Item(false, s));
            }
        }
        catch (UncheckedIOException | NutsIOException ex) {
            ws.log().of(FilesFoldersApi.class).with().session(session).level(Level.FINE).verb(NutsLogVerb.FAIL).log("unable to navigate : file not found {0}", new Object[]{dotFilesUrl});
        }
        if (versionString.compareTo("0.5.7") < 0 && folders) {
            String[] foldersFileContent = null;
            String dotFolderUrl = baseUrl + "/" + ".folder";
            try (InputStream stream = ws.io().monitor().setSource(dotFolderUrl).setSession(session).create();){
                foldersFileContent = (String[])StringTokenizerUtils.split(CoreIOUtils.loadString(stream, true), "\n\r").stream().map(x -> x.trim()).filter(x -> x.length() > 0).toArray(String[]::new);
            }
            catch (IOException | UncheckedIOException | NutsIOException ex) {
                ws.log().of(FilesFoldersApi.class).with().session(session).level(Level.FINE).verb(NutsLogVerb.FAIL).log("unable to navigate : file not found {0}", new Object[]{dotFolderUrl});
            }
            if (foldersFileContent != null) {
                for (String folder : foldersFileContent) {
                    all.add(new Item(true, folder));
                }
            }
        }
        return all.toArray(new Item[0]);
    }

    public static Iterator<NutsId> createIterator(NutsWorkspace workspace, NutsRepository repository, String rootUrl, String basePath, NutsIdFilter filter, RemoteRepoApi strategy, NutsSession session, int maxDepth, IteratorModel model) {
        return new FilesFoldersApiIdIterator(workspace, repository, rootUrl, basePath, filter, strategy, session, model, maxDepth);
    }

    public static class Item {
        boolean folder;
        String name;

        public Item(boolean folder, String name) {
            this.folder = folder;
            this.name = name;
        }

        public boolean isFolder() {
            return this.folder;
        }

        public String getName() {
            return this.name;
        }
    }

    public static interface IteratorModel {
        public void undeploy(NutsId var1, NutsSession var2) throws NutsExecutionException;

        public boolean isDescFile(String var1);

        public NutsDescriptor parseDescriptor(String var1, InputStream var2, NutsFetchMode var3, NutsRepository var4, NutsSession var5, String var6) throws IOException;

        public NutsId parseId(String var1, String var2, NutsIdFilter var3, NutsRepository var4, NutsSession var5) throws IOException;
    }

    public static abstract class AbstractIteratorModel
    implements IteratorModel {
        public NutsId validate(NutsId id, NutsDescriptor t, String pathname, String rootPath, NutsIdFilter filter, NutsRepository repository, NutsSession session) throws IOException {
            if (t != null) {
                if (!CoreNutsUtils.isEffectiveId(t.getId())) {
                    NutsDescriptor nutsDescriptor = null;
                    try {
                        nutsDescriptor = NutsWorkspaceExt.of(session.getWorkspace()).resolveEffectiveDescriptor(t, session);
                    }
                    catch (Exception ex) {
                        session.getWorkspace().log().of(FilesFoldersApi.class).with().session(session).level(Level.FINE).error((Throwable)ex).log("error resolving effective descriptor for {0} in url {1} : {2}", new Object[]{t.getId(), pathname, ex});
                    }
                    t = nutsDescriptor;
                }
                if (filter == null || filter.acceptSearchId((NutsSearchId)new NutsSearchIdByDescriptor(t), session)) {
                    NutsId nutsId = t.getId().builder().setRepository(repository.getName()).build();
                    return nutsId;
                }
            }
            if (id != null && (filter == null || filter.acceptSearchId((NutsSearchId)new NutsSearchIdById(id), session))) {
                return id;
            }
            return null;
        }

        @Override
        public NutsId parseId(String pathname, String rootPath, NutsIdFilter filter, NutsRepository repository, NutsSession session) throws IOException {
            NutsDescriptor t = null;
            try {
                t = this.parseDescriptor(pathname, session.getWorkspace().io().monitor().setSource(pathname).setSession(session).create(), NutsFetchMode.LOCAL, repository, session, rootPath);
            }
            catch (Exception ex) {
                session.getWorkspace().log().of(FilesFoldersApi.class).with().session(session).level(Level.FINE).error((Throwable)ex).log("error parsing url : {0} : {1}", new Object[]{pathname, this.toString()});
            }
            if (t != null) {
                return this.validate(null, t, pathname, rootPath, filter, repository, session);
            }
            return null;
        }
    }
}

