/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repos;

import java.util.LinkedHashMap;
import java.util.Map;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfig;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryConfigModel;
import net.thevpc.nuts.runtime.standalone.repos.DefaultNutsRepoConfigManager;

public class DefaultNutsRepositoryEnvModel {
    private NutsRepository repository;

    public DefaultNutsRepositoryEnvModel(NutsRepository repo) {
        this.repository = repo;
    }

    public NutsWorkspace getWorkspace() {
        return this.repository.getWorkspace();
    }

    public NutsRepository getRepository() {
        return this.repository;
    }

    public Map<String, String> toMap(boolean inherit, NutsSession session) {
        return this.config_getEnv(inherit, session);
    }

    public Map<String, String> toMap(NutsSession session) {
        return this.config_getEnv(true, session);
    }

    public String get(String key, String defaultValue, boolean inherit, NutsSession session) {
        return this.config_getEnv(key, defaultValue, inherit, session);
    }

    public String get(String property, String defaultValue, NutsSession session) {
        return this.config_getEnv(property, defaultValue, true, session);
    }

    public void set(String property, String value, NutsSession session) {
        this.config_setEnv(property, value, session);
    }

    private NutsRepositoryConfigModel getConfig0() {
        return ((DefaultNutsRepoConfigManager)this.repository.config()).getModel();
    }

    public String config_getEnv(String key, String defaultValue, boolean inherit, NutsSession session) {
        NutsRepositoryConfigModel model = ((DefaultNutsRepoConfigManager)this.repository.config()).getModel();
        NutsRepositoryConfig config = model.getConfig(session);
        String t = null;
        if (config.getEnv() != null) {
            t = (String)config.getEnv().get(defaultValue);
        }
        if (!NutsUtilStrings.isBlank(t)) {
            return t;
        }
        if (inherit && !NutsUtilStrings.isBlank((CharSequence)(t = this.repository.getWorkspace().env().getEnv(key, null)))) {
            return t;
        }
        return defaultValue;
    }

    private Map<String, String> config_getEnv(boolean inherit, NutsSession session) {
        NutsRepositoryConfigModel model = ((DefaultNutsRepoConfigManager)this.repository.config()).getModel();
        NutsRepositoryConfig config = model.getConfig(session);
        LinkedHashMap<String, String> p = new LinkedHashMap<String, String>();
        if (inherit) {
            p.putAll(this.repository.getWorkspace().env().getEnvMap());
        }
        if (config.getEnv() != null) {
            p.putAll(config.getEnv());
        }
        return p;
    }

    private void config_setEnv(String property, String value, NutsSession session) {
        NutsRepositoryConfigModel model = ((DefaultNutsRepoConfigManager)this.repository.config()).getModel();
        NutsRepositoryConfig config = model.getConfig(session);
        if (NutsUtilStrings.isBlank((CharSequence)value)) {
            if (config.getEnv() != null) {
                config.getEnv().remove(property);
                model.fireConfigurationChanged("env", session);
            }
        } else {
            if (config.getEnv() == null) {
                config.setEnv(new LinkedHashMap());
            }
            if (!value.equals(config.getEnv().get(property))) {
                config.getEnv().put(property, value);
                model.fireConfigurationChanged("env", session);
            }
        }
    }
}

