/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repos;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsIndexStore;
import net.thevpc.nuts.NutsInvalidRepositoryException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfig;
import net.thevpc.nuts.NutsRepositoryConfigManager;
import net.thevpc.nuts.NutsRepositoryEvent;
import net.thevpc.nuts.NutsRepositoryListener;
import net.thevpc.nuts.NutsRepositoryNotFoundException;
import net.thevpc.nuts.NutsRepositoryRef;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsUnsupportedOperationException;
import net.thevpc.nuts.NutsUserConfig;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.config.NutsRepositoryConfigManagerExt;
import net.thevpc.nuts.runtime.core.repos.DefaultNutsRepositoryManager;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryConfigModel;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryExt;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryUtils;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.NutsStoreLocationsMap;
import net.thevpc.nuts.runtime.standalone.repos.DefaultNutsRepositoryEvent;
import net.thevpc.nuts.runtime.standalone.repos.NutsRepositoryRegistryHelper;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsRepositoryConfigModel
implements NutsRepositoryConfigModel {
    private NutsLogger LOG;
    private final NutsRepository repository;
    private final int speed;
    private final String storeLocation;
    private NutsRepositoryConfig config;
    private final Map<String, NutsUserConfig> configUsers = new LinkedHashMap<String, NutsUserConfig>();
    private boolean configurationChanged = false;
    private int deployOrder;
    private boolean temporary;
    private boolean enabled = true;
    private String globalName;
    private boolean supportedMirroring;
    private final NutsRepositoryRegistryHelper repositoryRegistryHelper;
    private String repositoryName;
    private String repositoryType;
    private NutsRepositoryRef repositoryRef;

    public DefaultNutsRepositoryConfigModel(NutsRepository repository, NutsAddRepositoryOptions options, NutsSession session, int speed, boolean supportedMirroring, String repositoryType) {
        if (options == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing repository options", (Object[])new Object[0]));
        }
        if (options.getConfig() == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing repository options config", (Object[])new Object[0]));
        }
        this.repositoryRef = CoreNutsUtils.optionsToRef(options);
        String storeLocation = options.getLocation();
        NutsRepositoryConfig config = options.getConfig();
        String globalName = options.getConfig().getName();
        String repositoryName = options.getName();
        speed = Math.max(0, speed);
        if (NutsUtilStrings.isBlank((CharSequence)repositoryType)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing repository type", (Object[])new Object[0]));
        }
        if (NutsUtilStrings.isBlank((CharSequence)repositoryName)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing repository name", (Object[])new Object[0]));
        }
        if (NutsUtilStrings.isBlank((CharSequence)globalName)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing repository global name", (Object[])new Object[0]));
        }
        if (NutsUtilStrings.isBlank((CharSequence)storeLocation)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing folder", (Object[])new Object[0]));
        }
        Path pfolder = Paths.get(storeLocation, new String[0]);
        if (Files.exists(pfolder, new LinkOption[0]) && !Files.isDirectory(pfolder, new LinkOption[0])) {
            throw new NutsInvalidRepositoryException(session, storeLocation, NutsMessage.cstyle((String)"unable to resolve root as a valid folder %s", (Object[])new Object[]{storeLocation}));
        }
        this.repositoryRegistryHelper = new NutsRepositoryRegistryHelper(repository.getWorkspace());
        this.repository = repository;
        this.repositoryName = repositoryName;
        this.globalName = globalName;
        this.storeLocation = storeLocation;
        this.speed = speed;
        this.deployOrder = options.getDeployOrder();
        this.temporary = options.isTemporary();
        this.enabled = options.isEnabled();
        this.supportedMirroring = supportedMirroring;
        this.repositoryType = repositoryType;
        this.setConfig(config, session, false);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = session.getWorkspace().log().of(DefaultNutsRepositoryConfigModel.class);
        }
        return this.LOG;
    }

    @Override
    public NutsRepository getRepository() {
        return this.repository;
    }

    @Override
    public NutsWorkspace getWorkspace() {
        return this.repository.getWorkspace();
    }

    @Override
    public NutsRepositoryRef getRepositoryRef(NutsSession session) {
        return new NutsRepositoryRef(this.repositoryRef);
    }

    @Override
    public String getName() {
        return this.repositoryName;
    }

    @Override
    public int getDeployOrder(NutsSession session) {
        return this.deployOrder;
    }

    public void setEnv(String property, String value, NutsSession session) {
        if (NutsUtilStrings.isBlank((CharSequence)value)) {
            if (this.config.getEnv() != null) {
                this.config.getEnv().remove(property);
                this.fireConfigurationChanged("env", session);
            }
        } else {
            if (this.config.getEnv() == null) {
                this.config.setEnv(new LinkedHashMap());
            }
            if (!value.equals(this.config.getEnv().get(property))) {
                this.config.getEnv().put(property, value);
                this.fireConfigurationChanged("env", session);
            }
        }
    }

    @Override
    public int getSpeed(NutsSession session) {
        int s = this.speed;
        if (this.isSupportedMirroring(session)) {
            for (NutsRepository mirror : this.getMirrors(session)) {
                s += mirror.config().setSession(session).getSpeed();
            }
        }
        return s;
    }

    @Override
    public String getType(NutsSession session) {
        return this.repositoryType;
    }

    @Override
    public String getGroups(NutsSession session) {
        return this.config.getGroups();
    }

    @Override
    public String getLocation(boolean expand, NutsSession session) {
        String s = this.config.getLocation();
        if (s != null && expand) {
            s = this.repository.getWorkspace().io().expandPath(s);
        }
        return s;
    }

    @Override
    public String getStoreLocation() {
        return this.storeLocation;
    }

    @Override
    public NutsStoreLocationStrategy getStoreLocationStrategy(NutsSession session) {
        NutsStoreLocationStrategy strategy = this.config.getStoreLocationStrategy();
        if (strategy == null) {
            strategy = NutsStoreLocationStrategy.values()[0];
        }
        return strategy;
    }

    @Override
    public String getStoreLocation(NutsStoreLocation folderType, NutsSession session) {
        NutsStoreLocationsMap hlm = new NutsStoreLocationsMap(this.config.getStoreLocations());
        String n = hlm.get(folderType);
        if (this.temporary) {
            if (NutsUtilStrings.isBlank((CharSequence)n)) {
                n = folderType.toString().toLowerCase();
                n = n.trim();
            }
            return Paths.get(this.getStoreLocation(), new String[0]).resolve(n).toString();
        }
        switch (this.getStoreLocationStrategy(session)) {
            case STANDALONE: {
                if (NutsUtilStrings.isBlank((CharSequence)n)) {
                    n = folderType.toString().toLowerCase();
                }
                n = n.trim();
                return Paths.get(this.getStoreLocation(), new String[0]).resolve(n).toString();
            }
            case EXPLODED: {
                Path storeLocation = Paths.get(this.repository.getWorkspace().locations().getStoreLocation(folderType), new String[0]);
                return storeLocation.resolve("repos").resolve(this.getName()).resolve(this.getUuid()).toString();
            }
        }
        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unsupported strategy type %s", (Object[])new Object[]{this.getStoreLocation()}));
    }

    @Override
    public String getUuid() {
        return this.config.getUuid();
    }

    @Override
    public String getLocation() {
        return this.config.getLocation();
    }

    public void setConfig(NutsRepositoryConfig newConfig, NutsSession session, boolean fireChange) {
        if (newConfig == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing config", (Object[])new Object[0]));
        }
        this.config = newConfig;
        if (this.config.getUuid() == null) {
            fireChange = true;
            this.config.setUuid(UUID.randomUUID().toString());
        }
        if (this.config.getStoreLocationStrategy() == null) {
            fireChange = true;
            this.config.setStoreLocationStrategy(this.repository.getWorkspace().locations().getRepositoryStoreLocationStrategy());
        }
        if (NutsUtilStrings.isBlank((CharSequence)this.config.getType())) {
            fireChange = true;
            this.config.setType(this.repositoryType);
        } else if (!this.config.getType().equals(this.repositoryType)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid Repository Type : expected %s, found %s", (Object[])new Object[]{this.repositoryType, this.config.getType()}));
        }
        this.globalName = newConfig.getName();
        this.configUsers.clear();
        if (this.config.getUsers() != null) {
            for (NutsUserConfig user : this.config.getUsers()) {
                this.configUsers.put(user.getUser(), user);
            }
        }
        this.removeAllMirrors(session);
        if (this.config.getMirrors() != null) {
            for (NutsRepositoryRef ref : this.config.getMirrors()) {
                NutsRepository r = ((DefaultNutsRepositoryManager)this.repository.getWorkspace().repos()).getModel().createRepository(CoreNutsUtils.refToOptions(ref), this.repository, session);
                this.addMirror(r, session);
            }
        }
        if (fireChange) {
            this.fireConfigurationChanged("*", session);
        }
    }

    @Override
    public void addMirror(NutsRepository repo, NutsSession session) {
        this.repositoryRegistryHelper.addRepository(repo, session);
        NutsRepositoryUtils.of(this.repository).events().fireOnAddRepository(new DefaultNutsRepositoryEvent(session, this.repository, repo, "mirror", null, repo));
    }

    @Override
    public void setIndexEnabled(boolean enabled, NutsSession session) {
        if (enabled != this.config.isIndexEnabled()) {
            this.config.setIndexEnabled(enabled);
            this.fireConfigurationChanged("index-enabled", session);
        }
    }

    @Override
    public boolean isIndexEnabled(NutsSession session) {
        return this.config.isIndexEnabled();
    }

    @Override
    public void setUser(NutsUserConfig user, NutsSession session) {
        this.configUsers.put(user.getUser(), user);
        this.fireConfigurationChanged("user", session);
    }

    @Override
    public void removeUser(String userId, NutsSession session) {
        if (this.configUsers.containsKey(userId)) {
            this.configUsers.remove(userId);
            this.fireConfigurationChanged("user", session);
        }
    }

    @Override
    public NutsUserConfig getUser(String userId, NutsSession session) {
        NutsUserConfig u = this.configUsers.get(userId);
        if (u == null && ("admin".equals(userId) || "anonymous".equals(userId))) {
            u = new NutsUserConfig(userId, null, null, null);
            this.configUsers.put(userId, u);
            this.fireConfigurationChanged("user", this.repository.getWorkspace().createSession());
        }
        return u;
    }

    @Override
    public NutsUserConfig[] getUsers(NutsSession session) {
        return this.configUsers.values().toArray(new NutsUserConfig[0]);
    }

    @Override
    public void setMirrorEnabled(String repoName, boolean enabled, NutsSession session) {
        NutsRepositoryRef e = this.repositoryRegistryHelper.findRepositoryRef(repoName);
        if (e != null && e.isEnabled() != enabled) {
            e.setEnabled(enabled);
            this.fireConfigurationChanged("mirror", session);
        }
    }

    @Override
    public boolean save(boolean force, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.repository.getWorkspace(), session);
        boolean ok = false;
        if (force || !this.repository.getWorkspace().config().isReadOnly() && this.isConfigurationChanged()) {
            NutsWorkspaceUtils.of(session).checkReadOnly();
            this.repository.security().setSession(session).checkAllowed("save", "save");
            Path file = Paths.get(this.getStoreLocation(), new String[0]).resolve("nuts-repository.json");
            boolean created = false;
            if (!Files.exists(file, new LinkOption[0])) {
                created = true;
            }
            CoreIOUtils.mkdirs(Paths.get(this.getStoreLocation(), new String[0]));
            this.config.setConfigVersion("0.8.0");
            if (this.config.getEnv() != null && this.config.getEnv().isEmpty()) {
                this.config.setEnv(null);
            }
            this.config.setMirrors(Arrays.asList(this.repositoryRegistryHelper.getRepositoryRefs()));
            this.config.setUsers((List)(this.configUsers.isEmpty() ? null : new ArrayList<NutsUserConfig>(this.configUsers.values())));
            this.repository.getWorkspace().elem().setSession(session).setContentType(NutsContentType.JSON).setValue((Object)this.config).print(file);
            this.configurationChanged = false;
            if (this._LOG(session).isLoggable(Level.CONFIG)) {
                if (created) {
                    this._LOGOP(session).level(Level.CONFIG).verb(NutsLogVerb.SUCCESS).log(CoreStringUtils.alignLeft(this.repository.getName(), 20) + " created repository " + this.repository.getName() + " at " + this.getStoreLocation(), new Object[0]);
                } else {
                    this._LOGOP(session).level(Level.CONFIG).verb(NutsLogVerb.SUCCESS).log(CoreStringUtils.alignLeft(this.repository.getName(), 20) + " updated repository " + this.repository.getName() + " at " + this.getStoreLocation(), new Object[0]);
                }
            }
            ok = true;
        }
        NutsException error = null;
        for (NutsRepository repo : this.getMirrors(session)) {
            try {
                NutsRepositoryConfigManager config = repo.config();
                if (!(config instanceof NutsRepositoryConfigManagerExt)) continue;
                ok |= ((NutsRepositoryConfigManagerExt)config).getModel().save(force, session);
            }
            catch (NutsException ex) {
                error = ex;
            }
        }
        if (error != null) {
            throw error;
        }
        return ok;
    }

    public void save(NutsSession session) {
        this.save(true, session);
    }

    @Override
    public void fireConfigurationChanged(String configName, NutsSession session) {
        this.configurationChanged = true;
        DefaultNutsRepositoryEvent evt = new DefaultNutsRepositoryEvent(session, null, this.repository, "config." + configName, null, true);
        for (NutsRepositoryListener workspaceListener : this.repository.getRepositoryListeners()) {
            workspaceListener.onConfigurationChanged((NutsRepositoryEvent)evt);
        }
    }

    public boolean isConfigurationChanged() {
        return this.configurationChanged;
    }

    @Override
    public void setEnabled(boolean enabled, NutsSession session) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled(NutsSession session) {
        return this.enabled;
    }

    @Override
    public boolean isTemporary(NutsSession session) {
        return this.temporary;
    }

    @Override
    public void setTemporary(boolean transientRepository, NutsSession session) {
        this.temporary = transientRepository;
    }

    @Override
    public boolean isIndexSubscribed(NutsSession session) {
        NutsIndexStore s = this.getIndexStore();
        return s != null && s.isSubscribed(session);
    }

    private NutsIndexStore getIndexStore() {
        return NutsRepositoryExt.of(this.repository).getIndexStore();
    }

    @Override
    public void subscribeIndex(NutsSession session) {
        NutsIndexStore s = this.getIndexStore();
        if (s != null) {
            s.subscribe(session);
        }
    }

    @Override
    public void unsubscribeIndex(NutsSession session) {
        NutsIndexStore s = this.getIndexStore();
        if (s != null) {
            s.unsubscribe(session);
        }
    }

    @Override
    public String getGlobalName(NutsSession session) {
        return this.globalName;
    }

    @Override
    public boolean isSupportedMirroring(NutsSession session) {
        return this.supportedMirroring;
    }

    @Override
    public void removeMirror(String repositoryId, NutsSession session) {
        if (!this.isSupportedMirroring(session)) {
            throw new NutsUnsupportedOperationException(session, NutsMessage.cstyle((String)"unsupported operation '%s'", (Object[])new Object[]{"removeMirror"}));
        }
        this.repository.security().setSession(session).checkAllowed("remove-repo", "remove-repository");
        NutsRepository r = this.repositoryRegistryHelper.removeRepository(repositoryId);
        if (r == null) {
            throw new NutsRepositoryNotFoundException(session, repositoryId);
        }
        NutsRepositoryUtils.of(this.repository).events().fireOnRemoveRepository(new DefaultNutsRepositoryEvent(session, this.repository, r, "mirror", r, null));
    }

    @Override
    public NutsRepository getMirror(String repositoryIdPath, NutsSession session) {
        NutsRepository r = this.findMirror(repositoryIdPath, session);
        if (r != null) {
            return r;
        }
        throw new NutsRepositoryNotFoundException(session, repositoryIdPath);
    }

    @Override
    public NutsRepository findMirror(String repositoryNameOrId, NutsSession session) {
        NutsRepository y = this.repositoryRegistryHelper.findRepository(repositoryNameOrId);
        if (y != null) {
            return y;
        }
        if (session.isTransitive() && this.isSupportedMirroring(session)) {
            for (NutsRepository mirror : this.getMirrors(session)) {
                NutsRepository m = mirror.config().setSession(session.copy().setTransitive(Boolean.valueOf(true))).findMirror(repositoryNameOrId);
                if (m == null) continue;
                if (y == null) {
                    y = m;
                    continue;
                }
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"ambiguous repository name %s ; found two Ids %s and %s", (Object[])new Object[]{repositoryNameOrId, y.getUuid(), m.getUuid()}));
            }
        }
        return y;
    }

    @Override
    public NutsRepository findMirrorById(String repositoryNameOrId, NutsSession session) {
        NutsRepository y = this.repositoryRegistryHelper.findRepositoryById(repositoryNameOrId);
        if (y != null) {
            return y;
        }
        if (session.isTransitive() && this.isSupportedMirroring(session)) {
            for (NutsRepository mirror : this.getMirrors(session)) {
                NutsRepository m = mirror.config().setSession(session.copy().setTransitive(Boolean.valueOf(true))).findMirrorById(repositoryNameOrId);
                if (m == null) continue;
                if (y == null) {
                    y = m;
                    continue;
                }
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"ambiguous repository name %s ; found two Ids %s and %s", (Object[])new Object[]{repositoryNameOrId, y.getUuid(), m.getUuid()}));
            }
        }
        return y;
    }

    @Override
    public NutsRepository findMirrorByName(String repositoryNameOrId, NutsSession session) {
        NutsRepository y = this.repositoryRegistryHelper.findRepositoryByName(repositoryNameOrId);
        if (y != null) {
            return y;
        }
        if (session.isTransitive() && this.isSupportedMirroring(session)) {
            for (NutsRepository mirror : this.getMirrors(session)) {
                NutsRepository m = mirror.config().setSession(session.copy().setTransitive(Boolean.valueOf(true))).findMirrorByName(repositoryNameOrId);
                if (m == null) continue;
                if (y == null) {
                    y = m;
                    continue;
                }
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"ambiguous repository name %s ; found two Ids %s and %s", (Object[])new Object[]{repositoryNameOrId, y.getUuid(), m.getUuid()}));
            }
        }
        return y;
    }

    @Override
    public NutsRepository[] getMirrors(NutsSession session) {
        return this.repositoryRegistryHelper.getRepositories();
    }

    @Override
    public NutsRepository addMirror(NutsAddRepositoryOptions options, NutsSession session) {
        if (!this.isSupportedMirroring(session)) {
            throw new NutsUnsupportedOperationException(session, NutsMessage.cstyle((String)"unsupported operation '%s'", (Object[])new Object[]{"addMirror"}));
        }
        if (options.isTemporary()) {
            return null;
        }
        NutsRepository repo = ((DefaultNutsRepositoryManager)this.repository.getWorkspace().repos()).getModel().createRepository(options, this.repository, session);
        this.addMirror(repo, session);
        return repo;
    }

    @Override
    public Path getTempMirrorsRoot(NutsSession session) {
        return Paths.get(this.getStoreLocation(), new String[0]).resolve("repos");
    }

    @Override
    public Path getMirrorsRoot(NutsSession session) {
        return Paths.get(this.getStoreLocation(), new String[0]).resolve("repos");
    }

    @Override
    public NutsRepositoryConfig getStoredConfig(NutsSession session) {
        return this.config;
    }

    public void removeAllMirrors(NutsSession options) {
        for (NutsRepository repo : this.repositoryRegistryHelper.getRepositories()) {
            this.removeMirror(repo.getUuid(), options);
        }
    }

    @Override
    public NutsRepositoryConfig getConfig(NutsSession session) {
        return this.config;
    }
}

