/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repos;

import java.util.logging.Level;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryExt;
import net.thevpc.nuts.runtime.core.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.repocommands.AbstractNutsPushRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsPushRepositoryCommand;

public class DefaultNutsPushRepositoryCommand
extends AbstractNutsPushRepositoryCommand {
    private NutsLogger LOG;

    public DefaultNutsPushRepositoryCommand(NutsRepository repo) {
        super(repo);
        this.LOG = repo.getWorkspace().log().of(DefaultNutsPushRepositoryCommand.class);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = session.getWorkspace().log().of(DefaultNutsPushRepositoryCommand.class);
        }
        return this.LOG;
    }

    @Override
    public NutsPushRepositoryCommand run() {
        block2: {
            NutsSession session = this.getSession();
            NutsWorkspaceUtils.checkSession(this.getRepo().getWorkspace(), session);
            this.getRepo().security().setSession(session).checkAllowed("push", "push");
            try {
                NutsRepositoryExt.of(this.getRepo()).pushImpl(this);
                this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.SUCCESS).log("{0} push {1}", new Object[]{CoreStringUtils.alignLeft(this.getRepo().getName(), 20), this.getId()});
            }
            catch (RuntimeException ex) {
                if (!this.LOG.isLoggable(Level.FINEST)) break block2;
                this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.FAIL).log("{0} push {1}", new Object[]{CoreStringUtils.alignLeft(this.getRepo().getName(), 20), this.getId()});
            }
        }
        return this;
    }
}

