/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repos;

import java.nio.file.Paths;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import net.thevpc.nuts.NutsAddRepositoryOptions;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIndexStore;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsRepositoryConfig;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.bundles.string.GlobUtils;
import net.thevpc.nuts.runtime.core.commands.repo.NutsRepositorySupportedAction;
import net.thevpc.nuts.runtime.core.config.NutsRepositoryConfigManagerExt;
import net.thevpc.nuts.runtime.core.repos.AbstractNutsRepository;
import net.thevpc.nuts.runtime.core.repos.NutsRepositoryExt;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.core.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.repocommands.AbstractNutsUpdateRepositoryStatisticsCommand;
import net.thevpc.nuts.runtime.standalone.repos.DefaultNutsDeployRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repos.DefaultNutsFetchContentRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repos.DefaultNutsFetchDescriptorRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repos.DefaultNutsPushRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repos.DefaultNutsRepositoryConfigModel;
import net.thevpc.nuts.runtime.standalone.repos.DefaultNutsRepositoryUndeployCommand;
import net.thevpc.nuts.runtime.standalone.repos.DefaultNutsSearchRepositoryCommand;
import net.thevpc.nuts.runtime.standalone.repos.DefaultNutsSearchVersionsRepositoryCommand;
import net.thevpc.nuts.spi.NutsDeployRepositoryCommand;
import net.thevpc.nuts.spi.NutsFetchContentRepositoryCommand;
import net.thevpc.nuts.spi.NutsFetchDescriptorRepositoryCommand;
import net.thevpc.nuts.spi.NutsPushRepositoryCommand;
import net.thevpc.nuts.spi.NutsRepositoryUndeployCommand;
import net.thevpc.nuts.spi.NutsSearchRepositoryCommand;
import net.thevpc.nuts.spi.NutsSearchVersionsRepositoryCommand;
import net.thevpc.nuts.spi.NutsUpdateRepositoryStatisticsCommand;

public abstract class AbstractNutsRepositoryBase
extends AbstractNutsRepository
implements NutsRepositoryExt {
    private static final long serialVersionUID = 1L;
    protected NutsIndexStore nutsIndexStore;
    private final NutsLogger LOG;

    public AbstractNutsRepositoryBase(NutsAddRepositoryOptions options, NutsSession session, NutsRepository parentRepository, int speed, boolean supportedMirroring, String repositoryType) {
        this.initSession = session;
        this.LOG = session.getWorkspace().log().of(AbstractNutsRepositoryBase.class);
        this.init(options, session, parentRepository, speed, supportedMirroring, repositoryType);
    }

    @Override
    public NutsIndexStore getIndexStore() {
        return this.nutsIndexStore;
    }

    protected void init(NutsAddRepositoryOptions options, NutsSession initSession, NutsRepository parent, int speed, boolean supportedMirroring, String repositoryType) {
        NutsRepositoryConfig optionsConfig = options.getConfig();
        this.workspace = initSession.getWorkspace();
        this.parentRepository = parent;
        this.configModel = new DefaultNutsRepositoryConfigModel(this, options, initSession, speed, supportedMirroring, repositoryType);
        this.nutsIndexStore = initSession.getWorkspace().config().getIndexStoreClientFactory().createIndexStore((NutsRepository)this);
        this.setEnabled(options.isEnabled());
    }

    @Override
    public boolean acceptAction(NutsId id, NutsRepositorySupportedAction supportedAction, NutsFetchMode mode, NutsSession session) {
        String groups = this.config().getGroups();
        if (NutsUtilStrings.isBlank((CharSequence)groups)) {
            return true;
        }
        return GlobUtils.ofExact(groups).matcher(id.getGroupId()).matches();
    }

    @Override
    public String toString() {
        NutsRepositoryConfigManagerExt c = NutsRepositoryConfigManagerExt.of(this.config());
        String name = this.getName();
        String storePath = null;
        String loc = c.getModel().getLocation();
        String impl = this.getClass().getSimpleName();
        if (c != null) {
            storePath = Paths.get(c.getModel().getStoreLocation(), new String[0]).toAbsolutePath().toString();
        }
        LinkedHashMap<String, String> a = new LinkedHashMap<String, String>();
        if (name != null) {
            a.put("name", name);
        }
        a.put("impl", impl);
        if (storePath != null) {
            a.put("store", storePath);
        }
        if (loc != null) {
            a.put("location", loc);
        }
        return a.toString();
    }

    @Override
    public void checkAllowedFetch(NutsId id, NutsSession session) {
    }

    public NutsFetchDescriptorRepositoryCommand fetchDescriptor() {
        return new DefaultNutsFetchDescriptorRepositoryCommand(this);
    }

    @Override
    public NutsId searchLatestVersion(NutsId id, NutsIdFilter filter, NutsFetchMode fetchMode, NutsSession session) {
        Iterator allVersions = this.searchVersions().setSession(session).setId(id).setFilter(filter).setFetchMode(fetchMode).getResult();
        NutsId a = null;
        while (allVersions.hasNext()) {
            NutsId next = (NutsId)allVersions.next();
            if (a != null && next.getVersion().compareTo(a.getVersion()) <= 0) continue;
            a = next;
        }
        return a;
    }

    protected void traceMessage(NutsSession session, NutsFetchMode fetchMode, Level lvl, NutsId id, NutsLogVerb tracePhase, String title, long startTime, NutsMessage extraMessage) {
        CoreNutsUtils.traceMessage(this.LOG, lvl, this.getName(), session, fetchMode, id, tracePhase, title, startTime, extraMessage);
    }

    public NutsDeployRepositoryCommand deploy() {
        return new DefaultNutsDeployRepositoryCommand(this);
    }

    public NutsPushRepositoryCommand push() {
        return new DefaultNutsPushRepositoryCommand(this);
    }

    public NutsSearchRepositoryCommand search() {
        return new DefaultNutsSearchRepositoryCommand(this);
    }

    public NutsFetchContentRepositoryCommand fetchContent() {
        return new DefaultNutsFetchContentRepositoryCommand(this);
    }

    public NutsSearchVersionsRepositoryCommand searchVersions() {
        return new DefaultNutsSearchVersionsRepositoryCommand(this);
    }

    public NutsRepositoryUndeployCommand undeploy() {
        return new DefaultNutsRepositoryUndeployCommand(this);
    }

    protected String getIdComponentExtension(String packaging, NutsSession session) {
        return session.getWorkspace().locations().getDefaultIdContentExtension(packaging);
    }

    @Override
    protected String getIdExtension(NutsId id, NutsSession session) {
        return session.getWorkspace().locations().getDefaultIdExtension(id);
    }

    @Override
    public String getIdBasedir(NutsId id, NutsSession session) {
        return session.getWorkspace().locations().setSession(session).getDefaultIdBasedir(id);
    }

    protected String getIdRemotePath(NutsId id, NutsSession session) {
        return CoreIOUtils.buildUrl(this.config().setSession(session).getLocation(true), this.getIdRelativePath(id, session));
    }

    protected String getIdRelativePath(NutsId id, NutsSession session) {
        return this.getIdBasedir(id, session) + "/" + this.getIdFilename(id, session);
    }

    public NutsUpdateRepositoryStatisticsCommand updateStatistics() {
        return new AbstractNutsUpdateRepositoryStatisticsCommand(this){

            @Override
            public NutsUpdateRepositoryStatisticsCommand run() {
                return this;
            }
        };
    }
}

