/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.repocommands;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.repocommands.NutsRepositoryCommandBase;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsDeployRepositoryCommand;

public abstract class AbstractNutsDeployRepositoryCommand
extends NutsRepositoryCommandBase<NutsDeployRepositoryCommand>
implements NutsDeployRepositoryCommand {
    private NutsId id;
    private Object content;
    private NutsDescriptor descriptor;

    public AbstractNutsDeployRepositoryCommand(NutsRepository repo) {
        super(repo, "deploy");
    }

    @Override
    public boolean configureFirst(NutsCommandLine cmd) {
        return super.configureFirst(cmd);
    }

    public Object getContent() {
        return this.content;
    }

    public NutsDescriptor getDescriptor() {
        return this.descriptor;
    }

    public NutsId getId() {
        return this.id;
    }

    public NutsDeployRepositoryCommand setContent(Path content) {
        this.content = content;
        return this;
    }

    public NutsDeployRepositoryCommand setContent(URL content) {
        this.content = content;
        return this;
    }

    public NutsDeployRepositoryCommand setContent(File content) {
        this.content = content;
        return this;
    }

    public NutsDeployRepositoryCommand setContent(InputStream content) {
        this.content = content;
        return this;
    }

    public NutsDeployRepositoryCommand setDescriptor(NutsDescriptor descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    public NutsDeployRepositoryCommand setId(NutsId id) {
        this.id = id;
        return this;
    }

    protected void checkParameters() {
        this.checkSession();
        NutsSession session = this.getSession();
        this.getRepo().security().setSession(session).checkAllowed("deploy", "deploy");
        NutsWorkspaceUtils.of(session).checkNutsId(this.getId());
        if (this.getContent() == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing Content", (Object[])new Object[0]));
        }
        if (this.getDescriptor() == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing Descriptor", (Object[])new Object[0]));
        }
        if ("RELEASE".equals(this.getId().getVersion().getValue()) || "LATEST".equals(this.getId().getVersion().getValue())) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid version %s", (Object[])new Object[]{this.getId().getVersion()}));
        }
    }
}

