/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsArtifactCall;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsExecutionEntry;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSingleton;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.common.Ref;
import net.thevpc.nuts.runtime.bundles.io.InputStreamVisitor;
import net.thevpc.nuts.runtime.bundles.io.ZipUtils;
import net.thevpc.nuts.runtime.core.model.DefaultNutsArtifactCall;
import net.thevpc.nuts.runtime.standalone.bridges.maven.MavenUtils;
import net.thevpc.nuts.spi.NutsDescriptorContentParserComponent;
import net.thevpc.nuts.spi.NutsDescriptorContentParserContext;

@NutsSingleton
public class JarDescriptorContentParserComponent
implements NutsDescriptorContentParserComponent {
    public static final Set<String> POSSIBLE_EXT = new HashSet<String>(Collections.singletonList("jar"));
    private NutsWorkspace ws;

    public int getSupportLevel(NutsSupportLevelContext<Object> criteria) {
        this.ws = criteria.getWorkspace();
        return 10;
    }

    public NutsDescriptor parse(final NutsDescriptorContentParserContext parserContext) {
        if (!POSSIBLE_EXT.contains(parserContext.getFileExtension())) {
            return null;
        }
        final NutsId JAVA = this.ws.id().parser().parse("java");
        final Ref nutsjson = new Ref();
        final Ref metainf = new Ref();
        final Ref maven = new Ref();
        final Ref mainClass = new Ref();
        try {
            ZipUtils.visitZipStream(parserContext.getFullStream(), new Predicate<String>(){

                @Override
                public boolean test(String path) {
                    if ("META-INF/MANIFEST.MF".equals(path)) {
                        return true;
                    }
                    if ("META-INF/nuts.json".equals(path)) {
                        return true;
                    }
                    return path.startsWith("META-INF/maven/") && path.endsWith("/pom.xml");
                }
            }, new InputStreamVisitor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean visit(String path, InputStream inputStream) throws IOException {
                    switch (path) {
                        case "META-INF/MANIFEST.MF": {
                            Manifest manifest = new Manifest(inputStream);
                            Attributes attrs = manifest.getMainAttributes();
                            for (Object o : attrs.keySet()) {
                                Attributes.Name attrName = (Attributes.Name)o;
                                if (!"Main-Class".equals(attrName.toString())) continue;
                                mainClass.set(attrs.getValue(attrName));
                            }
                            NutsDescriptor d = parserContext.getWorkspace().descriptor().descriptorBuilder().setId(JarDescriptorContentParserComponent.this.ws.id().parser().parse("temp:jar#1.0")).setExecutable(mainClass.isSet()).setPackaging("jar").setExecutor((NutsArtifactCall)new DefaultNutsArtifactCall(JAVA, new String[0])).build();
                            metainf.set(d);
                            break;
                        }
                        case "META-INF/nuts.json": {
                            try {
                                nutsjson.set(parserContext.getWorkspace().descriptor().parser().setSession(parserContext.getSession()).parse(inputStream));
                                break;
                            }
                            finally {
                                inputStream.close();
                            }
                        }
                        default: {
                            try {
                                maven.set(MavenUtils.of(parserContext.getSession()).parsePomXml(inputStream, NutsFetchMode.REMOTE, path, null));
                                break;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    return !nutsjson.isSet() || !metainf.isSet() && !maven.isSet();
                }
            });
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        if (nutsjson.isSet()) {
            return (NutsDescriptor)nutsjson.get();
        }
        NutsDescriptor baseNutsDescriptor = null;
        if (maven.isSet()) {
            baseNutsDescriptor = (NutsDescriptor)maven.get();
            if (mainClass.isSet()) {
                return baseNutsDescriptor.builder().setExecutor((NutsArtifactCall)new DefaultNutsArtifactCall(JAVA, new String[]{"--main-class", (String)mainClass.get()})).build();
            }
        } else if (metainf.isSet()) {
            baseNutsDescriptor = (NutsDescriptor)metainf.get();
        }
        if (baseNutsDescriptor == null) {
            baseNutsDescriptor = parserContext.getWorkspace().descriptor().descriptorBuilder().setId(this.ws.id().parser().parse("temp:jar#1.0")).setExecutable(true).setPackaging("jar").build();
        }
        boolean alwaysSelectAllMainClasses = false;
        NutsCommandLine cmd = parserContext.getWorkspace().commandLine().create(parserContext.getParseOptions());
        while (!cmd.isEmpty()) {
            NutsArgument a = cmd.nextBoolean(new String[]{"--all-mains"});
            if (a != null) {
                alwaysSelectAllMainClasses = a.getBoolean();
                continue;
            }
            cmd.skip();
        }
        if (mainClass.get() == null || alwaysSelectAllMainClasses) {
            NutsExecutionEntry[] classes = parserContext.getWorkspace().apps().execEntries().setSession(parserContext.getSession()).parse(parserContext.getFullStream(), "java", parserContext.getFullStream().toString());
            if (classes.length == 0) {
                return baseNutsDescriptor;
            }
            return baseNutsDescriptor.builder().setExecutor((NutsArtifactCall)new DefaultNutsArtifactCall(JAVA, new String[]{"--main-class=" + String.join((CharSequence)":", Arrays.stream(classes).map(x -> x.getName()).collect(Collectors.toList()))}, null)).setExecutable(true).build();
        }
        return baseNutsDescriptor;
    }
}

