/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.manager;

import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIdFilterManager;
import net.thevpc.nuts.NutsIdFormat;
import net.thevpc.nuts.NutsIdManager;
import net.thevpc.nuts.NutsIdParser;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.mvn.PomId;
import net.thevpc.nuts.runtime.core.format.DefaultNutsIdFormat;
import net.thevpc.nuts.runtime.core.model.DefaultNutsIdBuilder;
import net.thevpc.nuts.runtime.core.parser.DefaultNutsIdParser;
import net.thevpc.nuts.runtime.standalone.bridges.maven.MavenUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsIdManager
implements NutsIdManager {
    private NutsWorkspace ws;
    private NutsSession session;

    public DefaultNutsIdManager(NutsWorkspace ws) {
        this.ws = ws;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsIdManager setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public NutsIdFormat formatter() {
        return (NutsIdFormat)new DefaultNutsIdFormat(this.ws).setSession(this.getSession());
    }

    public NutsIdFormat formatter(NutsId id) {
        return this.formatter().setValue(id);
    }

    public NutsIdFilterManager filter() {
        return this.ws.filters().id().setSession(this.getSession());
    }

    public NutsIdBuilder builder() {
        this.checkSession();
        return new DefaultNutsIdBuilder(this.getSession());
    }

    public NutsId resolveId(Class clazz) {
        PomId u = MavenUtils.createPomIdResolver(this.session).resolvePomId(clazz, null, this.session);
        if (u == null) {
            return null;
        }
        return this.parser().parse(u.getGroupId() + ":" + u.getArtifactId() + "#" + u.getVersion());
    }

    public NutsId[] resolveIds(Class clazz) {
        PomId[] u = MavenUtils.createPomIdResolver(this.session).resolvePomIds(clazz, this.session);
        NutsId[] all = new NutsId[u.length];
        NutsIdParser parser = this.parser();
        for (int i = 0; i < all.length; ++i) {
            all[i] = parser.parse(u[i].getGroupId() + ":" + u[i].getArtifactId() + "#" + u[i].getVersion());
        }
        return all;
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
    }

    public NutsIdParser parser() {
        this.checkSession();
        return new DefaultNutsIdParser(this.getSession());
    }

    public NutsId parse(String id) {
        return this.parser().parse(id);
    }

    public NutsWorkspace getWorkspace() {
        return this.ws;
    }
}

