/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.manager;

import java.util.Set;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyBuilder;
import net.thevpc.nuts.NutsDependencyFilterManager;
import net.thevpc.nuts.NutsDependencyFormat;
import net.thevpc.nuts.NutsDependencyManager;
import net.thevpc.nuts.NutsDependencyParser;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsDependencyScopePattern;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.format.DefaultNutsDependencyFormat;
import net.thevpc.nuts.runtime.core.model.DefaultNutsDependencyBuilder;
import net.thevpc.nuts.runtime.core.parser.DefaultNutsDependencyParser;
import net.thevpc.nuts.runtime.standalone.util.NutsDependencyScopes;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsDependencyManager
implements NutsDependencyManager {
    private NutsWorkspace workspace;
    private NutsSession session;

    public DefaultNutsDependencyManager(NutsWorkspace workspace) {
        this.workspace = workspace;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsDependencyManager setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public NutsWorkspace getWorkspace() {
        return this.workspace;
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.workspace, this.session);
    }

    public NutsDependencyParser parser() {
        this.checkSession();
        return new DefaultNutsDependencyParser(this.getSession());
    }

    public NutsDependencyBuilder builder() {
        this.checkSession();
        return new DefaultNutsDependencyBuilder(this.getSession());
    }

    public NutsDependencyFormat formatter() {
        return (NutsDependencyFormat)new DefaultNutsDependencyFormat(this.getWorkspace()).setSession(this.getSession());
    }

    public NutsDependencyFormat formatter(NutsDependency dependency) {
        return this.formatter().setValue(dependency).setSession(this.getSession());
    }

    public NutsDependencyFilterManager filter() {
        return this.getWorkspace().filters().dependency().setSession(this.getSession());
    }

    public Set<NutsDependencyScope> toScopeSet(NutsDependencyScopePattern other) {
        return NutsDependencyScopes.expand(other);
    }
}

