/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.progress;

import net.thevpc.nuts.NutsProgressEvent;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsWorkspace;

public class DefaultNutsProgressEvent
implements NutsProgressEvent {
    private final Object source;
    private final NutsString message;
    private final long globalCount;
    private final long globalMillis;
    private final long partialCount;
    private final long partialMillis;
    private final long length;
    private final Throwable exception;
    private final NutsSession session;
    private final float percent;
    private final boolean indeterminate;

    public DefaultNutsProgressEvent(Object source, NutsString message, long globalCount, long globalMillis, long partialCount, long partialMillis, long length, Throwable exception, NutsSession session, boolean indeterminate) {
        this.source = source;
        this.length = length;
        this.message = message;
        this.globalCount = globalCount;
        this.globalMillis = globalMillis;
        this.partialCount = partialCount;
        this.partialMillis = partialMillis;
        this.exception = exception;
        this.session = session;
        this.indeterminate = indeterminate;
        this.percent = length > 0L ? (float)((double)globalCount * 100.0 / (double)length) : 100.0f;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsWorkspace getWorkspace() {
        return this.session.getWorkspace();
    }

    public Throwable getError() {
        return this.exception;
    }

    public long getMaxValue() {
        return this.length;
    }

    public Object getSource() {
        return this.source;
    }

    public NutsString getMessage() {
        return this.message;
    }

    public long getCurrentValue() {
        return this.globalCount;
    }

    public long getTimeMillis() {
        return this.globalMillis;
    }

    public long getPartialValue() {
        return this.partialCount;
    }

    public long getPartialMillis() {
        return this.partialMillis;
    }

    public float getPercent() {
        return this.percent;
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }
}

