/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.util.function.Function;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsWorkspace;

public class NutsWorkspaceVarExpansionFunction
implements Function<String, String> {
    private final NutsWorkspace ws;

    public NutsWorkspaceVarExpansionFunction(NutsWorkspace ws) {
        this.ws = ws;
    }

    @Override
    public String apply(String from) {
        switch (from) {
            case "home.config": {
                return this.ws.locations().getHomeLocation(NutsStoreLocation.CONFIG);
            }
            case "home.apps": {
                return this.ws.locations().getHomeLocation(NutsStoreLocation.APPS);
            }
            case "home.lib": {
                return this.ws.locations().getHomeLocation(NutsStoreLocation.LIB);
            }
            case "home.temp": {
                return this.ws.locations().getHomeLocation(NutsStoreLocation.TEMP);
            }
            case "home.var": {
                return this.ws.locations().getHomeLocation(NutsStoreLocation.VAR);
            }
            case "home.cache": {
                return this.ws.locations().getHomeLocation(NutsStoreLocation.CACHE);
            }
            case "home.log": {
                return this.ws.locations().getHomeLocation(NutsStoreLocation.LOG);
            }
            case "home.run": {
                return this.ws.locations().getHomeLocation(NutsStoreLocation.RUN);
            }
            case "workspace.hash-name": {
                return this.ws.getHashName();
            }
            case "workspace.name": {
                return this.ws.getName();
            }
            case "workspace.location": 
            case "workspace": {
                return this.ws.locations().getWorkspaceLocation().toString();
            }
            case "user.home": {
                return System.getProperty("user.home");
            }
            case "workspace.config": {
                return this.ws.locations().getStoreLocation(NutsStoreLocation.CONFIG).toString();
            }
            case "workspace.lib": {
                return this.ws.locations().getStoreLocation(NutsStoreLocation.LIB).toString();
            }
            case "workspace.apps": {
                return this.ws.locations().getStoreLocation(NutsStoreLocation.APPS).toString();
            }
            case "workspace.cache": {
                return this.ws.locations().getStoreLocation(NutsStoreLocation.CACHE).toString();
            }
            case "workspace.run": {
                return this.ws.locations().getStoreLocation(NutsStoreLocation.RUN).toString();
            }
            case "workspace.temp": {
                return this.ws.locations().getStoreLocation(NutsStoreLocation.TEMP).toString();
            }
            case "workspace.log": {
                return this.ws.locations().getStoreLocation(NutsStoreLocation.LOG).toString();
            }
            case "workspace.var": {
                return this.ws.locations().getStoreLocation(NutsStoreLocation.VAR).toString();
            }
            case "nuts.boot.version": {
                return this.ws.getApiVersion().toString();
            }
            case "nuts.boot.id": {
                return this.ws.getApiId().toString();
            }
            case "nuts.workspace-boot.version": {
                return Nuts.getVersion();
            }
            case "nuts.workspace-boot.id": {
                return "net.thevpc.nuts:nuts#" + Nuts.getVersion();
            }
            case "nuts.workspace-runtime.version": {
                String rt = this.ws.env().getBootOptions().getRuntimeId();
                return rt == null ? this.ws.getRuntimeId().getVersion().toString() : (rt.contains("#") ? rt.substring(rt.indexOf("#") + 1) : rt);
            }
            case "nuts.workspace-runtime.id": {
                String rt = this.ws.env().getBootOptions().getRuntimeId();
                return rt == null ? this.ws.getRuntimeId().getVersion().toString() : (rt.contains("#") ? rt : "net.thevpc.nuts:nuts-runtime#" + rt);
            }
        }
        String v = System.getProperty(from);
        if (v != null) {
            return v;
        }
        return "${" + from + "}";
    }
}

