/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTerminalCommand;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.common.CorePlatformUtils;
import net.thevpc.nuts.runtime.core.format.text.DefaultAnsiEscapeCommand;
import net.thevpc.nuts.runtime.core.util.CachedValue;
import net.thevpc.nuts.runtime.standalone.io.NutsPrintStreamBase;
import net.thevpc.nuts.runtime.standalone.io.NutsPrintStreamFiltered;
import net.thevpc.nuts.runtime.standalone.io.NutsPrintStreamFormatted;

public class NutsPrintStreamSystem
extends NutsPrintStreamBase {
    private OutputStream out;
    private PrintStream base;
    private CachedValue<Integer> tput_cols;

    public NutsPrintStreamSystem(OutputStream out, Boolean autoFlush, String encoding, Boolean ansi, NutsSession session) {
        this(out, autoFlush, encoding, ansi, session, new NutsPrintStreamBase.Bindings());
    }

    protected NutsPrintStreamSystem(OutputStream out, PrintStream base, CachedValue<Integer> tput_cols, Boolean autoFlush, NutsTerminalMode mode, NutsSession session, NutsPrintStreamBase.Bindings bindings) {
        super(autoFlush == null ? true : autoFlush, mode, session, bindings);
        this.out = out;
        this.base = base;
    }

    public NutsPrintStreamSystem(OutputStream out, Boolean autoFlush, String encoding, Boolean ansi, NutsSession session, NutsPrintStreamBase.Bindings bindings) {
        super(true, NutsPrintStreamSystem.resolveMode(out, ansi, session), session, bindings);
        this.out = out;
        if (out instanceof PrintStream) {
            PrintStream ps = (PrintStream)out;
            if (autoFlush == null && encoding == null) {
                this.base = ps;
            }
        }
        if (this.base == null) {
            try {
                this.base = encoding == null ? new PrintStream(out, autoFlush != null && autoFlush != false) : new PrintStream(out, autoFlush != null && autoFlush != false, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
        }
        switch (this.mode()) {
            case ANSI: {
                if (bindings.ansi != null) {
                    throw new IllegalArgumentException("already bound ansi");
                }
                bindings.ansi = this;
                if (bindings.inherited != null) break;
                bindings.inherited = this;
                break;
            }
            case INHERITED: {
                if (bindings.inherited != null) {
                    throw new IllegalArgumentException("already bound ansi");
                }
                bindings.inherited = this;
            }
        }
    }

    private static NutsTerminalMode resolveMode(OutputStream out, Boolean ansi, NutsSession session) {
        if (ansi != null) {
            return ansi != false ? NutsTerminalMode.ANSI : NutsTerminalMode.INHERITED;
        }
        NutsWorkspace ws = session.getWorkspace();
        NutsOsFamily os = ws.env().getOsFamily();
        if (os == NutsOsFamily.WINDOWS && (CorePlatformUtils.IS_CYGWIN || CorePlatformUtils.IS_MINGW_XTERM) || os == NutsOsFamily.LINUX || os == NutsOsFamily.UNIX || os == NutsOsFamily.MACOS) {
            return NutsTerminalMode.ANSI;
        }
        return NutsTerminalMode.INHERITED;
    }

    public NutsPrintStream flush() {
        this.base.flush();
        return this;
    }

    public NutsPrintStream close() {
        if (this.mode() == NutsTerminalMode.ANSI) {
            this.write("\u001b[0m".getBytes());
            this.flush();
        }
        this.base.close();
        return this;
    }

    public NutsPrintStream write(int b) {
        this.base.write(b);
        return this;
    }

    public NutsPrintStream write(byte[] buf, int off, int len) {
        this.base.write(buf, off, len);
        return this;
    }

    public NutsPrintStream write(char[] buf, int off, int len) {
        if (buf == null) {
            this.base.print("null");
        } else {
            this.base.print(new String(buf, off, len));
        }
        return this;
    }

    public NutsPrintStream print(String s) {
        this.base.print(s);
        return this;
    }

    public NutsPrintStream convertSession(NutsSession session) {
        if (session == null || session == this.session) {
            return this;
        }
        return new NutsPrintStreamSystem(this.out, this.base, this.tput_cols, this.autoFlash, this.mode(), session, new NutsPrintStreamBase.Bindings());
    }

    public NutsPrintStream run(NutsTerminalCommand command) {
        if (this.mode() == NutsTerminalMode.ANSI) {
            switch (command.getName()) {
                case "clear-line": {
                    break;
                }
            }
            this.flush();
        }
        return this;
    }

    public int getColumns() {
        NutsWorkspace ws = this.session.getWorkspace();
        int tputCallTimeout = ws.env().getOptionAsInt("nuts.term.tput.call.timeout", Integer.valueOf(60));
        Integer w = ws.env().getOptionAsInt("nuts.term.width", null);
        if (w == null) {
            Integer v;
            if (this.tput_cols == null) {
                this.tput_cols = new CachedValue<Integer>(new DefaultAnsiEscapeCommand.TputEvaluator(this.session), tputCallTimeout);
            }
            return (v = this.tput_cols.getValue()) == null ? -1 : v;
        }
        return -1;
    }

    @Override
    public NutsPrintStream print(char[] s) {
        this.base.print(s);
        return this;
    }

    @Override
    protected NutsPrintStream convertImpl(NutsTerminalMode other) {
        switch (other) {
            case FORMATTED: {
                return new NutsPrintStreamFormatted(this, this.bindings);
            }
            case FILTERED: {
                return new NutsPrintStreamFiltered(this, this.bindings);
            }
        }
        throw new IllegalArgumentException("unsupported " + this.mode() + "->" + other);
    }
}

