/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTerminalCommand;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.runtime.standalone.io.NutsPrintStreamBase;
import net.thevpc.nuts.runtime.standalone.io.NutsPrintStreamFiltered;
import net.thevpc.nuts.runtime.standalone.io.NutsPrintStreamFormatted;

public class NutsPrintStreamRaw
extends NutsPrintStreamBase {
    protected OutputStream out;
    private PrintStream base;

    protected NutsPrintStreamRaw(OutputStream out, PrintStream base, Boolean autoFlush, NutsTerminalMode mode, NutsSession session, NutsPrintStreamBase.Bindings bindings) {
        super(autoFlush == null ? true : autoFlush, mode, session, bindings);
        this.out = out;
        this.base = base;
    }

    public NutsPrintStreamRaw(OutputStream out, Boolean autoFlush, String encoding, NutsSession session, NutsPrintStreamBase.Bindings bindings) {
        super(true, NutsTerminalMode.INHERITED, session, bindings);
        this.out = out;
        if (out instanceof PrintStream) {
            PrintStream ps = (PrintStream)out;
            if (autoFlush == null && encoding == null) {
                this.base = ps;
            }
        }
        if (this.base == null) {
            try {
                this.base = encoding == null ? new PrintStream(out, autoFlush != null && autoFlush != false) : new PrintStream(out, autoFlush != null && autoFlush != false, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
        }
        switch (this.mode()) {
            case ANSI: {
                if (bindings.ansi != null) {
                    throw new IllegalArgumentException("already bound ansi");
                }
                bindings.ansi = this;
                if (bindings.inherited != null) break;
                bindings.inherited = this;
                break;
            }
            case INHERITED: {
                if (bindings.inherited != null) {
                    throw new IllegalArgumentException("already bound ansi");
                }
                bindings.inherited = this;
            }
        }
    }

    public PrintStream getBase() {
        return this.base;
    }

    public NutsPrintStream flush() {
        this.base.flush();
        return this;
    }

    public NutsPrintStream close() {
        if (this.mode() == NutsTerminalMode.ANSI) {
            this.write("\u001b[0m".getBytes());
            this.flush();
        }
        this.base.close();
        return this;
    }

    public NutsPrintStream write(int b) {
        this.base.write(b);
        return this;
    }

    public NutsPrintStream write(byte[] buf, int off, int len) {
        this.base.write(buf, off, len);
        return this;
    }

    public NutsPrintStream write(char[] s, int off, int len) {
        if (s == null) {
            this.base.print("null");
        } else {
            this.base.print(new String(s, off, len));
        }
        return this;
    }

    public NutsPrintStream print(String s) {
        this.base.print(s);
        return this;
    }

    public NutsPrintStream convertSession(NutsSession session) {
        if (session == null || session == this.session) {
            return this;
        }
        return new NutsPrintStreamRaw(this.out, this.base, this.autoFlash, this.mode(), session, new NutsPrintStreamBase.Bindings());
    }

    public NutsPrintStream run(NutsTerminalCommand command) {
        return this;
    }

    public int getColumns() {
        return -1;
    }

    @Override
    public NutsPrintStream print(char[] s) {
        this.base.print(s);
        return this;
    }

    @Override
    protected NutsPrintStream convertImpl(NutsTerminalMode other) {
        switch (other) {
            case FORMATTED: {
                return new NutsPrintStreamFormatted(this, this.bindings);
            }
            case FILTERED: {
                return new NutsPrintStreamFiltered(this, this.bindings);
            }
        }
        throw new IllegalArgumentException("unsupported " + this.mode() + "->" + other);
    }
}

