/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Locale;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTerminalCommand;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.runtime.standalone.io.OutputStreamFromNutsPrintStream;
import net.thevpc.nuts.runtime.standalone.io.PrintStreamFromNutsPrintStream;
import net.thevpc.nuts.runtime.standalone.io.WriterFromNutsPrintStream;

public abstract class NutsPrintStreamBase
implements NutsPrintStream {
    private static String LINE_SEP = System.getProperty("line.separator");
    protected NutsSession session;
    protected Bindings bindings;
    protected OutputStream osWrapper;
    protected PrintStream psWrapper;
    protected Writer writerWrapper;
    protected boolean autoFlash;
    private NutsTerminalMode mode;
    private boolean trouble = false;

    public NutsPrintStreamBase(boolean autoFlash, NutsTerminalMode mode, NutsSession session, Bindings bindings) {
        if (mode == null) {
            throw new IllegalArgumentException("null mode");
        }
        if (session == null) {
            throw new IllegalArgumentException("null session");
        }
        this.bindings = bindings;
        this.autoFlash = autoFlash;
        this.mode = mode;
        this.session = session;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsPrintStream write(byte[] b) {
        return this.write(b, 0, b.length);
    }

    public NutsPrintStream write(char[] buf) {
        if (buf == null) {
            buf = "null".toCharArray();
        }
        return this.write(buf, 0, buf.length);
    }

    public NutsPrintStream print(boolean b) {
        this.print(b ? "true" : "false");
        return this;
    }

    public NutsPrintStream print(char c) {
        this.print(String.valueOf(c));
        return this;
    }

    public NutsPrintStream print(int i) {
        this.print(String.valueOf(i));
        return this;
    }

    public NutsPrintStream print(long l) {
        this.print(String.valueOf(l));
        return this;
    }

    public NutsPrintStream print(float f) {
        this.print(String.valueOf(f));
        return this;
    }

    public NutsPrintStream print(double d) {
        this.print(String.valueOf(d));
        return this;
    }

    public NutsPrintStream print(char[] s) {
        if (s == null) {
            s = "null".toCharArray();
        }
        this.write(s, 0, s.length);
        return this;
    }

    public NutsPrintStream print(NutsString b) {
        this.print(String.valueOf(b));
        return this;
    }

    public NutsPrintStream println(NutsString b) {
        this.println(String.valueOf(b));
        return this;
    }

    public NutsPrintStream print(Object obj) {
        this.print(String.valueOf(obj));
        return this;
    }

    public NutsPrintStream println() {
        this.print(LINE_SEP);
        if (this.autoFlash) {
            this.flush();
        }
        return this;
    }

    public NutsPrintStream println(boolean x) {
        this.print(x);
        this.println();
        return this;
    }

    public NutsPrintStream println(char x) {
        this.print(x);
        this.println();
        return this;
    }

    public NutsPrintStream println(int x) {
        this.print(x);
        this.println();
        return this;
    }

    public NutsPrintStream println(long x) {
        this.print(x);
        this.println();
        return this;
    }

    public NutsPrintStream println(float x) {
        this.print(x);
        this.println();
        return this;
    }

    public NutsPrintStream println(double x) {
        this.print(x);
        this.println();
        return this;
    }

    public NutsPrintStream println(char[] x) {
        this.print(x);
        this.println();
        return this;
    }

    public NutsPrintStream println(String x) {
        this.print(x);
        this.println();
        return this;
    }

    public NutsPrintStream println(Object x) {
        this.print(x);
        this.println();
        return this;
    }

    public NutsPrintStream resetLine() {
        this.run(NutsTerminalCommand.CLEAR_LINE);
        this.run(NutsTerminalCommand.MOVE_LINE_START);
        return this;
    }

    public NutsPrintStream printj(String format, Object ... args) {
        NutsText s = this.session.getWorkspace().text().toText((Object)NutsMessage.jstyle((String)format, (Object[])args));
        this.print((NutsString)s);
        return this;
    }

    public NutsPrintStream printf(String format, Object ... args) {
        this.format(format, args);
        return this;
    }

    public NutsPrintStream printf(Locale l, String format, Object ... args) {
        this.format(l, format, args);
        return this;
    }

    public NutsPrintStream format(String format, Object ... args) {
        return this.format(null, format, args);
    }

    public NutsPrintStream format(Locale l, String format, Object ... args) {
        if (l == null) {
            NutsText s = this.session.getWorkspace().text().toText((Object)NutsMessage.cstyle((String)format, (Object[])args));
            this.print((NutsString)s);
        } else {
            NutsSession sess = this.session.copy().setLocale(l.toString());
            NutsText s = sess.getWorkspace().text().toText((Object)NutsMessage.cstyle((String)format, (Object[])args));
            this.print((NutsString)s);
        }
        return this;
    }

    public NutsPrintStream append(CharSequence csq) {
        this.append(csq, 0, csq.length());
        return this;
    }

    public NutsPrintStream append(CharSequence csq, int start, int end) {
        int bufferLength = Math.min(4096, end - start);
        char[] buffer = new char[bufferLength];
        for (int i = start; i < end; i += bufferLength) {
            int e = Math.min(i + bufferLength, end);
            String s = csq.subSequence(i, e).toString();
            this.print(s);
        }
        return this;
    }

    public NutsPrintStream append(char c) {
        this.print(c);
        return this;
    }

    public NutsTerminalMode mode() {
        return this.mode;
    }

    public boolean isAutoFlash() {
        return this.autoFlash;
    }

    public NutsPrintStream convertMode(NutsTerminalMode other) {
        if (other == null || other == this.mode()) {
            return this;
        }
        switch (other) {
            case ANSI: {
                if (this.bindings.ansi != null) {
                    return this.bindings.filtered;
                }
                return this.convertImpl(other);
            }
            case INHERITED: {
                if (this.bindings.inherited != null) {
                    return this.bindings.inherited;
                }
                return this.convertImpl(other);
            }
            case FORMATTED: {
                if (this.bindings.formatted != null) {
                    return this.bindings.formatted;
                }
                return this.convertImpl(other);
            }
            case FILTERED: {
                if (this.bindings.filtered != null) {
                    return this.bindings.filtered;
                }
                return this.convertImpl(other);
            }
        }
        throw new IllegalArgumentException("unsupported yet");
    }

    public OutputStream asOutputStream() {
        if (this.osWrapper == null) {
            this.osWrapper = new OutputStreamFromNutsPrintStream(this);
        }
        return this.osWrapper;
    }

    public PrintStream asPrintStream() {
        if (this.psWrapper == null) {
            this.psWrapper = new PrintStreamFromNutsPrintStream((OutputStreamFromNutsPrintStream)this.asOutputStream());
        }
        return this.psWrapper;
    }

    public Writer asWriter() {
        if (this.writerWrapper == null) {
            this.writerWrapper = new WriterFromNutsPrintStream(this);
        }
        return this.writerWrapper;
    }

    public boolean isNtf() {
        switch (this.mode()) {
            case FORMATTED: 
            case FILTERED: {
                return true;
            }
        }
        return false;
    }

    protected abstract NutsPrintStream convertImpl(NutsTerminalMode var1);

    public String toString() {
        return super.toString();
    }

    public static class Bindings {
        protected NutsPrintStreamBase raw;
        protected NutsPrintStreamBase filtered;
        protected NutsPrintStreamBase ansi;
        protected NutsPrintStreamBase inherited;
        protected NutsPrintStreamBase formatted;
    }
}

