/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsTempAction;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.string.StringBuilder2;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;

public class DefaultTempAction
implements NutsTempAction {
    private NutsWorkspace ws;
    private String repositoryId;
    private NutsSession session;

    public DefaultTempAction(NutsWorkspace ws) {
        this.ws = ws;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public NutsTempAction setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
        return this;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsTempAction setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public String createTempFile(String name) {
        return this.createTempFile(name, false);
    }

    public String createTempFolder(String name) {
        return this.createTempFile(name, true);
    }

    public String createTempFile(String name, boolean folder) {
        File rootFolder = null;
        NutsRepository repositoryById = null;
        if (this.repositoryId == null) {
            rootFolder = Paths.get(this.ws.locations().setSession(this.getSession()).getStoreLocation(NutsStoreLocation.TEMP), new String[0]).toFile();
        } else {
            repositoryById = this.ws.repos().setSession(this.session).getRepository(this.repositoryId);
            rootFolder = Paths.get(repositoryById.config().setSession(this.session).getStoreLocation(NutsStoreLocation.TEMP), new String[0]).toFile();
        }
        NutsId appId = this.session.getAppId();
        if (appId == null) {
            appId = this.session.getWorkspace().getRuntimeId();
        }
        if (appId != null) {
            rootFolder = new File(rootFolder, "id" + File.separator + this.ws.locations().setSession(this.session).getDefaultIdBasedir(appId));
        }
        if (name == null) {
            name = "";
        }
        rootFolder.mkdirs();
        StringBuilder2 ext = new StringBuilder2(CoreIOUtils.getFileExtension(name, true, true));
        StringBuilder2 prefix = new StringBuilder2(ext.length() > 0 ? name.substring(0, name.length() - ext.length()) : name);
        if (ext.isEmpty() && prefix.isEmpty()) {
            prefix.append("nuts-");
            if (!folder) {
                ext.append(".tmp");
            }
        } else if (ext.isEmpty()) {
            if (!folder) {
                ext.append("-tmp");
            }
        } else if (prefix.isEmpty()) {
            prefix.append(ext);
            ext.clear();
            ext.append("-tmp");
        }
        if (!prefix.endsWith("-")) {
            prefix.append('-');
        }
        if (prefix.length() < 3 && prefix.length() < 3) {
            prefix.append('A');
            if (prefix.length() < 3) {
                prefix.append('B');
            }
        }
        if (folder) {
            for (int i = 0; i < 15; ++i) {
                File temp = null;
                try {
                    temp = File.createTempFile(prefix.toString(), ext.toString(), rootFolder);
                    if (!temp.delete() || !temp.mkdir()) continue;
                    return temp.toPath().toString();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new NutsIOException(this.session, NutsMessage.cstyle((String)"could not create temp directory: %s*%s", (Object[])new Object[]{rootFolder + File.separator + prefix, ext}));
        }
        try {
            return File.createTempFile(prefix.toString(), ext.toString(), rootFolder).toPath().toString();
        }
        catch (IOException e) {
            throw new NutsIOException(this.session, (Throwable)e);
        }
    }
}

