/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.InputStream;
import java.util.logging.Level;
import net.thevpc.nuts.NutsDefaultTerminalSpec;
import net.thevpc.nuts.NutsExtensionNotFoundException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsSystemTerminal;
import net.thevpc.nuts.NutsTerminalSpec;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceExtensionManager;
import net.thevpc.nuts.NutsWorkspaceListener;
import net.thevpc.nuts.runtime.core.events.DefaultNutsWorkspaceEvent;
import net.thevpc.nuts.runtime.core.terminals.AbstractSystemTerminalAdapter;
import net.thevpc.nuts.runtime.core.terminals.DefaultNutsSessionTerminal;
import net.thevpc.nuts.runtime.core.terminals.DefaultNutsSystemTerminalBase;
import net.thevpc.nuts.runtime.core.terminals.DefaultSystemTerminal;
import net.thevpc.nuts.runtime.core.terminals.UnmodifiableSessionTerminal;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsSystemTerminalBase;

public class DefaultNutsTerminalModel {
    private NutsWorkspace ws;
    private NutsSessionTerminal terminal;
    private NutsSystemTerminal systemTerminal;
    private WorkspaceSystemTerminalAdapter workspaceSystemTerminalAdapter;
    private NutsLogger LOG;

    public DefaultNutsTerminalModel(NutsWorkspace ws) {
        this.ws = ws;
        this.workspaceSystemTerminalAdapter = new WorkspaceSystemTerminalAdapter(ws);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = this.ws.log().setSession(session).of(DefaultNutsTerminalModel.class);
        }
        return this.LOG;
    }

    public NutsWorkspace getWorkspace() {
        return this.ws;
    }

    public NutsSystemTerminal createSystemTerminal(NutsTerminalSpec spec, NutsSession session) {
        NutsSystemTerminalBase termb = (NutsSystemTerminalBase)this.ws.extensions().setSession(session).createSupported(NutsSystemTerminalBase.class, (Object)spec);
        if (termb == null) {
            throw new NutsExtensionNotFoundException(session, NutsSystemTerminalBase.class, "SystemTerminalBase");
        }
        return this.NutsSystemTerminal_of_NutsSystemTerminalBase(termb, session);
    }

    public void enableRichTerm(NutsSession session) {
        NutsSystemTerminal st = this.getSystemTerminal();
        if (!st.isAutoCompleteSupported()) {
            NutsWorkspace ws = session.getWorkspace();
            NutsId extId = ws.id().parser().parse("net.thevpc.nuts.ext:next-term#" + ws.getApiVersion());
            if (!ws.config().isExcludedExtension(extId.toString(), ws.env().getBootOptions())) {
                NutsWorkspaceExtensionManager extensions = ws.extensions();
                extensions.setSession(session).loadExtension(extId);
                NutsSystemTerminal systemTerminal = this.createSystemTerminal(new NutsDefaultTerminalSpec().setAutoComplete(Boolean.valueOf(true)), session);
                this.setSystemTerminal((NutsSystemTerminalBase)systemTerminal, session);
                if (this.getSystemTerminal().isAutoCompleteSupported()) {
                    this._LOGOP(session).level(Level.FINE).verb(NutsLogVerb.SUCCESS).log("enable rich terminal", new Object[0]);
                } else {
                    this._LOGOP(session).level(Level.FINE).verb(NutsLogVerb.FAIL).log("unable to enable rich terminal", new Object[0]);
                }
            } else {
                this._LOGOP(session).level(Level.FINE).verb(NutsLogVerb.WARNING).log("enableRichTerm discarded; next-term is excluded.", new Object[0]);
            }
        }
    }

    public NutsSystemTerminal getSystemTerminal() {
        return this.systemTerminal;
    }

    public NutsSessionTerminal getTerminal() {
        return this.terminal;
    }

    public void setTerminal(NutsSessionTerminal terminal, NutsSession session) {
        NutsWorkspaceUtils.checkSession(this.ws, session);
        if (terminal == null) {
            terminal = this.createTerminal(session);
        }
        if (!(terminal instanceof UnmodifiableSessionTerminal)) {
            terminal = new UnmodifiableSessionTerminal(terminal, session);
        }
        this.terminal = terminal;
    }

    public NutsSessionTerminal createTerminal(InputStream in, NutsPrintStream out, NutsPrintStream err, NutsSession session) {
        NutsSessionTerminal t = this.createTerminal(session);
        if (in != null) {
            t.setIn(in);
        }
        if (out != null) {
            t.setOut(out);
        }
        if (err != null) {
            t.setErr(err);
        }
        return t;
    }

    public NutsSessionTerminal createTerminal(NutsSession session) {
        return new DefaultNutsSessionTerminal(session, (NutsSystemTerminalBase)this.workspaceSystemTerminalAdapter);
    }

    private NutsSystemTerminal NutsSystemTerminal_of_NutsSystemTerminalBase(NutsSystemTerminalBase terminal, NutsSession session) {
        NutsSystemTerminal syst;
        if (terminal == null) {
            throw new NutsExtensionNotFoundException(session, NutsSystemTerminalBase.class, "SystemTerminalBase");
        }
        if (terminal instanceof NutsSystemTerminal) {
            syst = (NutsSystemTerminal)terminal;
        } else {
            try {
                syst = new DefaultSystemTerminal(terminal);
                NutsWorkspaceUtils.setSession(syst, session);
            }
            catch (Exception ex) {
                this._LOGOP(session).level(Level.FINEST).verb(NutsLogVerb.WARNING).log("unable to create system terminal : {0}", new Object[]{ex.getMessage()});
                DefaultNutsSystemTerminalBase b = new DefaultNutsSystemTerminalBase();
                NutsWorkspaceUtils.setSession(b, session);
                syst = new DefaultSystemTerminal(b);
                NutsWorkspaceUtils.setSession(syst, session);
            }
        }
        return syst;
    }

    public void setSystemTerminal(NutsSystemTerminalBase terminal, NutsSession session) {
        if (terminal == null) {
            throw new NutsExtensionNotFoundException(session, NutsSystemTerminalBase.class, "SystemTerminalBase");
        }
        NutsSystemTerminal syst = this.NutsSystemTerminal_of_NutsSystemTerminalBase(terminal, session);
        NutsSystemTerminal old = this.systemTerminal;
        this.systemTerminal = syst;
        if (old != this.systemTerminal) {
            DefaultNutsWorkspaceEvent event = null;
            if (session != null) {
                for (NutsWorkspaceListener workspaceListener : session.getWorkspace().events().getWorkspaceListeners()) {
                    if (event == null) {
                        event = new DefaultNutsWorkspaceEvent(session, null, "systemTerminal", old, this.systemTerminal);
                    }
                    workspaceListener.onUpdateProperty(event);
                }
            }
        }
    }

    private static class WorkspaceSystemTerminalAdapter
    extends AbstractSystemTerminalAdapter {
        private NutsWorkspace workspace;

        public WorkspaceSystemTerminalAdapter(NutsWorkspace workspace) {
            this.workspace = workspace;
        }

        @Override
        public NutsSystemTerminalBase getParent() {
            return this.workspace.term().setSession(NutsWorkspaceUtils.defaultSession(this.workspace)).getSystemTerminal();
        }
    }
}

