/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCommandLineConfigurable;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsQuestion;
import net.thevpc.nuts.NutsQuestionFormat;
import net.thevpc.nuts.NutsQuestionParser;
import net.thevpc.nuts.NutsQuestionValidator;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsUserCancelException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.gui.CoreNutsUtilGui;
import net.thevpc.nuts.runtime.standalone.io.DefaultNutsQuestionFormat;
import net.thevpc.nuts.runtime.standalone.io.DefaultNutsResponseParser;
import net.thevpc.nuts.runtime.standalone.io.NutsByteArrayPrintStream;
import net.thevpc.nuts.runtime.standalone.util.NutsConfigurableHelper;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsQuestion<T>
implements NutsQuestion<T> {
    private final NutsSessionTerminal terminal;
    private final NutsPrintStream out;
    private final NutsWorkspace ws;
    private String message;
    private Object[] messageParameters;
    private String cancelMessage;
    private Object[] cancelMessageParameters;
    private Object[] acceptedValues;
    private String hintMessage;
    private Object[] hintMessageParameters;
    private T defaultValue;
    private boolean resetLine;
    private Class<T> valueType;
    private NutsQuestionFormat<T> format;
    private NutsQuestionParser<T> parser;
    private NutsQuestionValidator<T> validator;
    private NutsSession session;
    private boolean traceConfirmation = false;
    private boolean executed = false;
    private boolean password = false;
    private Object lastResult = null;

    public DefaultNutsQuestion(NutsWorkspace ws, NutsSessionTerminal terminal, NutsPrintStream out) {
        this.ws = ws;
        this.terminal = terminal;
        this.out = out;
    }

    private T execute() {
        Object[] _acceptedValues;
        NutsQuestionFormat<T> ff;
        this.checkSession();
        if (!this.traceConfirmation && (this.getValueType().equals(Boolean.class) || this.getValueType().equals(Boolean.TYPE))) {
            switch (this.getSession().getConfirm()) {
                case YES: {
                    return (T)Boolean.TRUE;
                }
                case NO: {
                    return (T)Boolean.FALSE;
                }
                case ERROR: {
                    if (this.cancelMessage != null) {
                        NutsByteArrayPrintStream os = new NutsByteArrayPrintStream(this.getSession());
                        os.printf(this.message, this.getCancelMessage());
                        os.flush();
                        throw new NutsUserCancelException(this.getSession(), NutsMessage.formatted((String)os.toString()));
                    }
                    NutsByteArrayPrintStream os = new NutsByteArrayPrintStream(this.getSession());
                    os.printf(this.message, this.getCancelMessageParameters());
                    os.flush();
                    throw new NutsUserCancelException(this.getSession(), NutsMessage.cstyle((String)"cancelled : %s", (Object[])new Object[]{NutsMessage.formatted((String)os.toString())}));
                }
            }
        }
        if (!this.getSession().isPlainOut()) {
            NutsByteArrayPrintStream os = new NutsByteArrayPrintStream(this.getSession());
            os.printf(this.message, this.getMessageParameters());
            os.flush();
            throw new NutsExecutionException(this.getSession(), NutsMessage.cstyle((String)("unable to switch to interactive mode for non plain text output format. You need to provide default response (-y|-n) for question : " + os), (Object[])new Object[0]), 243);
        }
        boolean gui = this.session.isGui() && this.session.getWorkspace().env().isGraphicalDesktopEnvironment();
        String message = this.getMessage();
        if (message.endsWith("\n")) {
            message = message.substring(0, message.length() - 1);
        }
        boolean extraInfo = false;
        NutsQuestionParser<T> p = this.getParser();
        if (p == null) {
            p = new DefaultNutsResponseParser<T>(this.getSession(), this.getValueType());
        }
        if ((ff = this.getFormat()) == null) {
            ff = new DefaultNutsQuestionFormat(this.getSession());
        }
        if ((_acceptedValues = this.getAcceptedValues()) == null) {
            _acceptedValues = ff.getDefaultValues(this.getValueType(), (NutsQuestion)this);
        }
        if (_acceptedValues == null) {
            _acceptedValues = new Object[]{};
        }
        while (true) {
            Object v;
            NutsPrintStream out = this.out;
            ByteArrayOutputStream bos = null;
            if (gui) {
                bos = new ByteArrayOutputStream();
                out = this.session.getWorkspace().io().createPrintStream((OutputStream)bos);
            }
            if (this.resetLine) {
                out.resetLine();
            }
            out.printf(message, this.getMessageParameters());
            boolean first = true;
            if (this.getDefaultValue() != null) {
                if (first) {
                    first = false;
                    out.print(" (");
                } else {
                    out.print(", ");
                }
                out.printf("default is %s", new Object[]{this.ws.text().forStyled(ff.format(this.getDefaultValue(), (NutsQuestion)this), NutsTextStyle.primary1())});
            }
            if (this.getHintMessage() != null) {
                if (this.getHintMessage().length() > 0) {
                    out.print(" (");
                    out.printf(this.getHintMessage(), this.getHintMessageParameters());
                    out.print(")");
                }
            } else {
                if (_acceptedValues.length > 0) {
                    if (first) {
                        first = false;
                        out.print(" (");
                    } else {
                        out.print(", ");
                    }
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < _acceptedValues.length; ++i) {
                        Object acceptedValue = _acceptedValues[i];
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(ff.format(acceptedValue, (NutsQuestion)this));
                    }
                    out.printf("accepts %s", new Object[]{this.ws.text().forStyled(sb.toString(), NutsTextStyle.primary4())});
                }
                if (!first) {
                    out.print(")");
                }
            }
            out.flush();
            switch (this.getSession().getConfirm()) {
                case ERROR: {
                    out.flush();
                    out.println(" : cancel");
                    throw new NutsUserCancelException(this.getSession());
                }
            }
            if (this.getValueType().equals(Boolean.class) || this.getValueType().equals(Boolean.TYPE)) {
                switch (this.getSession().getConfirm()) {
                    case YES: {
                        out.flush();
                        out.println(" : yes");
                        throw new NutsUserCancelException(this.getSession());
                    }
                    case NO: {
                        out.flush();
                        out.println(" : no");
                        throw new NutsUserCancelException(this.getSession());
                    }
                }
            }
            if (this.password) {
                if (extraInfo) {
                    out.print("?\n");
                    out.flush();
                    if (gui) {
                        out.printf("\t Please enter value or ```error %s``` to cancel : ", new Object[]{"cancel!"});
                        out.flush();
                        String v0 = this.showGuiInput(bos.toString(), true);
                        if (v0 == null) {
                            v0 = "";
                        }
                        v = v0.toCharArray();
                    } else {
                        v = this.terminal.readPassword("\t Please enter value or ```error %s``` to cancel : ", new Object[]{"cancel!"});
                    }
                } else {
                    out.flush();
                    if (gui) {
                        out.printf(" ", new Object[0]);
                        out.flush();
                        String v0 = this.showGuiInput(bos.toString(), true);
                        if (v0 == null) {
                            v0 = "";
                        }
                        v = v0.toCharArray();
                    } else {
                        v = this.terminal.readPassword(" ", new Object[0]);
                    }
                }
                if (Arrays.equals("cancel!".toCharArray(), v)) {
                    throw new NutsUserCancelException(this.getSession());
                }
                try {
                    if (this.validator != null) {
                        v = (char[])this.validator.validate(v, (NutsQuestion)this);
                    }
                    return (T)v;
                }
                catch (NutsUserCancelException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    out.printf("```error ERROR``` : %s%n", new Object[]{ex});
                }
            } else {
                if (extraInfo) {
                    out.print("?\n");
                    out.flush();
                    if (gui) {
                        out.printf("\t Please enter value or ```error %s``` to cancel : ", new Object[]{"cancel!"});
                        out.flush();
                        String v0 = this.showGuiInput(bos.toString(), false);
                        if (v0 == null) {
                            v0 = "";
                        }
                        v = v0;
                    } else {
                        v = this.terminal.readLine("\t Please enter value or ```error %s``` to cancel : ", new Object[]{"cancel!"});
                    }
                } else {
                    out.flush();
                    if (gui) {
                        out.printf(" ? : ", new Object[0]);
                        out.flush();
                        String v0 = this.showGuiInput(bos.toString(), false);
                        if (v0 == null) {
                            v0 = "";
                        }
                        v = v0;
                    } else {
                        v = this.terminal.readLine(" ? : ", new Object[0]);
                    }
                }
                try {
                    Object parsed = p.parse(v, this.getDefaultValue(), (NutsQuestion)this);
                    if (this.validator != null) {
                        parsed = this.validator.validate(parsed, (NutsQuestion)this);
                    }
                    return (T)parsed;
                }
                catch (NutsUserCancelException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    out.printf("```error ERROR``` : %s%n", new Object[]{ex});
                }
            }
            extraInfo = true;
        }
    }

    private String showGuiInput(String str, boolean pwd) {
        String ft = this.getSession().getWorkspace().text().parse(str).filteredText();
        NutsMessage title = NutsMessage.cstyle((String)"Nuts Package Manager - %s", (Object[])new Object[]{this.getSession().getWorkspace().getApiId().getVersion()});
        if (this.session.getAppId() != null) {
            try {
                String n;
                NutsDefinition def = (NutsDefinition)this.session.getWorkspace().search().setId(this.session.getAppId()).setEffective(true).setLatest(true).getResultDefinitions().first();
                if (def != null && !NutsUtilStrings.isBlank((CharSequence)(n = def.getEffectiveDescriptor().getName()))) {
                    title = NutsMessage.cstyle((String)"%s - %s", (Object[])new Object[]{n, def.getEffectiveDescriptor().getId().getVersion()});
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.password) {
            return CoreNutsUtilGui.inputPassword(NutsMessage.formatted((String)str), title, this.getSession());
        }
        return CoreNutsUtilGui.inputString(NutsMessage.formatted((String)str), title, this.getSession());
    }

    public boolean isResetLine() {
        return this.resetLine;
    }

    public NutsQuestion<T> resetLine() {
        return this.resetLine(true);
    }

    public NutsQuestion<T> resetLine(boolean resetLine) {
        this.resetLine = resetLine;
        return this;
    }

    public NutsQuestion<Boolean> forBoolean(String msg, Object ... params) {
        return this.setValueType(Boolean.class).setMessage(msg, params);
    }

    public NutsQuestion<char[]> forPassword(String msg, Object ... params) {
        this.password = true;
        return this.setValueType(char[].class).setMessage(msg, params);
    }

    public NutsQuestion<String> forString(String msg, Object ... params) {
        return this.setValueType(String.class).setMessage(msg, params);
    }

    public NutsQuestion<Integer> forInteger(String msg, Object ... params) {
        return this.setValueType(Integer.class).setMessage(msg, params);
    }

    public NutsQuestion<Long> forLong(String msg, Object ... params) {
        return this.setValueType(Long.class).setMessage(msg, params);
    }

    public NutsQuestion<Float> forFloat(String msg, Object ... params) {
        return this.setValueType(Float.class).setMessage(msg, params);
    }

    public NutsQuestion<Double> forDouble(String msg, Object ... params) {
        return this.setValueType(Double.class).setMessage(msg, params);
    }

    public <K extends Enum> NutsQuestion<K> forEnum(Class<K> enumType, String msg, Object ... params) {
        Object[] values = (Enum[])enumType.getEnumConstants();
        return this.setValueType(enumType).setMessage(msg, params).setAcceptedValues(values);
    }

    public String getHintMessage() {
        return this.hintMessage;
    }

    public Object[] getHintMessageParameters() {
        return this.hintMessageParameters;
    }

    public String getMessage() {
        return this.message;
    }

    public Object[] getMessageParameters() {
        return this.messageParameters;
    }

    public String getCancelMessage() {
        return this.cancelMessage;
    }

    public Object[] getCancelMessageParameters() {
        return this.cancelMessageParameters;
    }

    public NutsQuestion<T> setMessage(String message, Object ... messageParameters) {
        this.message = message;
        this.messageParameters = messageParameters;
        return this;
    }

    public NutsQuestion<T> setHintMessage(String message, Object ... messageParameters) {
        this.hintMessage = message;
        this.hintMessageParameters = messageParameters;
        return this;
    }

    public Object[] getAcceptedValues() {
        return this.acceptedValues;
    }

    public NutsQuestion<T> setAcceptedValues(Object[] acceptedValues) {
        this.acceptedValues = acceptedValues;
        return this;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public NutsQuestion<T> setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public Class<T> getValueType() {
        return this.valueType;
    }

    public NutsQuestion<T> setValueType(Class<T> valueType) {
        this.valueType = valueType;
        return this;
    }

    public NutsQuestionFormat<T> getFormat() {
        return this.format;
    }

    public NutsQuestion<T> setFormat(NutsQuestionFormat<T> parser) {
        this.format = parser;
        return this;
    }

    public NutsQuestionParser<T> getParser() {
        return this.parser;
    }

    public NutsQuestion<T> setParser(NutsQuestionParser<T> parser) {
        this.parser = parser;
        return this;
    }

    public NutsQuestion<T> setValidator(NutsQuestionValidator<T> validator) {
        this.validator = validator;
        return this;
    }

    public NutsQuestionValidator<T> getValidator() {
        return this.validator;
    }

    public NutsQuestion<T> run() {
        this.lastResult = this.execute();
        this.executed = true;
        return this;
    }

    public Boolean getBooleanValue() {
        return (Boolean)this.getValue();
    }

    public T getValue() {
        if (!this.executed) {
            this.run();
        }
        return (T)this.lastResult;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsQuestion<T> setCancelMessage(String message, Object ... params) {
        if (message == null) {
            this.cancelMessage = null;
            this.cancelMessageParameters = null;
        } else {
            this.cancelMessage = message;
            this.cancelMessageParameters = params == null ? new Object[]{} : params;
        }
        return this;
    }

    public NutsQuestion<T> setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public final NutsQuestion<T> configure(boolean skipUnsupported, String ... args) {
        this.checkSession();
        return (NutsQuestion)NutsConfigurableHelper.configure((NutsCommandLineConfigurable)this, this.getSession(), skipUnsupported, args, "question");
    }

    public final boolean configure(boolean skipUnsupported, NutsCommandLine commandLine) {
        this.checkSession();
        return NutsConfigurableHelper.configure((NutsCommandLineConfigurable)this, this.getSession(), skipUnsupported, commandLine);
    }

    public boolean configureFirst(NutsCommandLine cmd) {
        NutsArgument a = cmd.peek();
        if (a == null) {
            return false;
        }
        switch (a.getStringKey()) {
            case "trace-confirmation": {
                boolean val = cmd.nextBoolean(new String[0]).getBooleanValue();
                if (!a.isEnabled()) break;
                this.traceConfirmation = val;
                break;
            }
        }
        return false;
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
    }
}

