/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Path;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOutput;
import net.thevpc.nuts.NutsOutputAction;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedArgumentException;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.io.AbstractNutsOutput;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsOutputAction
implements NutsOutputAction {
    private NutsWorkspace ws;
    private String name;
    private String typeName;
    private NutsSession session;

    public DefaultNutsOutputAction(NutsWorkspace ws) {
        this.ws = ws;
    }

    private static NutsOutput createOutputTarget(OutputStream target, String name, String typeName, NutsSession ws) {
        if (target == null) {
            return null;
        }
        return new AbstractNutsOutput(target, false, false, name, typeName, ws){

            @Override
            public OutputStream open() {
                return (OutputStream)this.getSource();
            }

            public String toString() {
                return "OutputStream(" + this.getSource() + ")";
            }

            public void close() {
                try {
                    ((OutputStream)this.getSource()).close();
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
        };
    }

    private static NutsOutput createOutputTarget(String target, String name, String typeName, NutsSession session) {
        if (target == null) {
            return null;
        }
        return session.getWorkspace().io().path(target).output();
    }

    public NutsOutput of(Object source) {
        this.checkSession();
        if (source == null) {
            return null;
        }
        if (source instanceof NutsOutput) {
            return (NutsOutput)source;
        }
        if (source instanceof OutputStream) {
            return this.of((OutputStream)source);
        }
        if (source instanceof Path) {
            return this.of((Path)source);
        }
        if (source instanceof File) {
            return this.of((File)source);
        }
        if (source instanceof URL) {
            return this.of((URL)source);
        }
        if (source instanceof String) {
            return this.of((String)source);
        }
        if (source instanceof NutsPath) {
            return this.of((NutsPath)source);
        }
        throw new NutsUnsupportedArgumentException(this.session, NutsMessage.cstyle((String)"unsupported type %s", (Object[])new Object[]{source.getClass().getName()}));
    }

    public NutsOutput of(String resource) {
        this.checkSession();
        NutsOutput v = DefaultNutsOutputAction.createOutputTarget(resource, this.getName(), this.getTypeName(), this.session);
        v = this.toMulti(v);
        return v;
    }

    private NutsOutput toMulti(NutsOutput v) {
        return v;
    }

    public NutsOutput of(OutputStream stream) {
        this.checkSession();
        NutsOutput v = DefaultNutsOutputAction.createOutputTarget(stream, this.getName(), this.getTypeName(), this.session);
        v = this.toMulti(v);
        return v;
    }

    public NutsOutput of(URL source) {
        this.checkSession();
        return this.session.getWorkspace().io().path(source).output();
    }

    public NutsOutput of(File source) {
        this.checkSession();
        return this.session.getWorkspace().io().path(source).output();
    }

    public NutsOutput of(Path source) {
        this.checkSession();
        return this.session.getWorkspace().io().path(source).output();
    }

    public NutsOutput of(NutsPath source) {
        this.checkSession();
        return source.output();
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public NutsOutputAction setName(String name) {
        this.name = name;
        return this;
    }

    public NutsOutputAction setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsOutputAction setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
    }
}

