/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInput;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsMonitorAction;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsProgressEvent;
import net.thevpc.nuts.NutsProgressFactory;
import net.thevpc.nuts.NutsProgressMonitor;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsUnsupportedArgumentException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.io.InputStreamMetadataAware;
import net.thevpc.nuts.runtime.core.io.NutsCompressedPath;
import net.thevpc.nuts.runtime.core.util.CoreBooleanUtils;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.SilentStartNutsInputStreamProgressMonitorAdapter;
import net.thevpc.nuts.runtime.standalone.io.SingletonNutsInputStreamProgressFactory;
import net.thevpc.nuts.runtime.standalone.io.progress.DefaultNutsProgressEvent;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsMonitorAction
implements NutsMonitorAction {
    private final NutsWorkspace ws;
    private String sourceTypeName;
    private String sourceKind;
    private Object source;
    private Object sourceOrigin;
    private NutsString sourceName;
    private long length = -1L;
    private NutsSession session;
    private boolean logProgress;
    private NutsProgressFactory progressFactory;

    public DefaultNutsMonitorAction(NutsWorkspace ws) {
        this.ws = ws;
    }

    public NutsMonitorAction setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsMonitorAction setName(NutsString name) {
        this.sourceName = name;
        return this;
    }

    public NutsString getName() {
        return this.sourceName;
    }

    public NutsMonitorAction setOrigin(Object origin) {
        this.sourceOrigin = origin;
        return this;
    }

    public Object getOrigin() {
        return this.sourceOrigin;
    }

    public NutsMonitorAction setLength(long len) {
        this.length = len;
        return this;
    }

    public long getLength() {
        return this.length;
    }

    public NutsMonitorAction setSource(String path) {
        this.source = path;
        this.sourceKind = "string";
        return this;
    }

    public NutsMonitorAction setSource(NutsPath inputSource) {
        this.source = inputSource;
        this.sourceKind = "nutsPath";
        return this;
    }

    public NutsMonitorAction setSource(NutsInput inputSource) {
        this.source = inputSource;
        this.sourceKind = "inputSource";
        return this;
    }

    public NutsMonitorAction setSource(Path path) {
        this.source = path;
        this.sourceKind = "filePath";
        return this;
    }

    public NutsMonitorAction setSource(File path) {
        this.source = path;
        this.sourceKind = "file";
        return this;
    }

    public NutsMonitorAction setSource(InputStream path) {
        this.source = path;
        this.sourceKind = "stream";
        return this;
    }

    public InputStream create() {
        this.checkSession();
        if (this.source == null || this.sourceKind == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing Source", (Object[])new Object[0]));
        }
        switch (this.sourceKind) {
            case "inputSource": {
                return this.monitorInputStream((NutsInput)this.source, this.sourceOrigin, this.sourceName).open();
            }
            case "stream": {
                return this.monitorInputStream((InputStream)this.source, this.sourceOrigin, this.length, this.sourceName);
            }
            case "string": {
                return this.monitorInputStream((String)this.source, this.sourceOrigin, this.sourceName);
            }
            case "filePath": {
                return this.monitorInputStream(((Path)this.source).toString(), this.sourceOrigin, this.sourceName);
            }
            case "nutsPath": {
                return this.monitorInputStream((NutsPath)this.source, this.sourceOrigin, this.sourceName).open();
            }
            case "file": {
                return this.monitorInputStream(((File)this.source).getPath(), this.sourceOrigin, this.sourceName);
            }
        }
        throw new NutsUnsupportedArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported kind %s", (Object[])new Object[]{this.sourceKind}));
    }

    public String getSourceTypeName() {
        return this.sourceTypeName;
    }

    public NutsMonitorAction setSourceTypeName(String sourceType) {
        this.sourceTypeName = sourceType;
        return this;
    }

    public NutsInput createSource() {
        this.checkSession();
        NutsInput base = this.getSession().getWorkspace().io().input().of(this.source);
        boolean isPath = base.isFile();
        boolean isUrl = base.isURL();
        String sourceKind0 = this.sourceKind;
        String sourceTypeName0 = this.sourceTypeName;
        NutsString sourceName0 = this.sourceName;
        if (sourceTypeName0 == null && this.getOrigin() instanceof NutsInput) {
            sourceTypeName0 = ((NutsInput)this.getOrigin()).getTypeName();
        }
        if (sourceTypeName0 == null && this.source instanceof NutsInput) {
            sourceTypeName0 = ((NutsInput)this.source).getTypeName();
        }
        if (sourceName0 == null && this.getOrigin() instanceof NutsInput) {
            sourceName0 = this.session.getWorkspace().text().toText((Object)((NutsInput)this.getOrigin()).getName());
        }
        if (sourceName0 == null && this.source instanceof NutsInput) {
            sourceName0 = this.session.getWorkspace().text().toText((Object)((NutsInput)this.source).getName());
        }
        if (sourceKind0.equalsIgnoreCase("inputSource")) {
            return this.monitorInputStream((NutsInput)this.source, this.sourceOrigin, sourceName0);
        }
        if (sourceName0 == null) {
            sourceName0 = this.session.getWorkspace().text().forStyled(NutsCompressedPath.compressPath(this.source.toString()), NutsTextStyle.path());
        }
        switch (sourceKind0) {
            case "string": {
                return this.monitorInputStream(new InputFromString(sourceName0.filteredText(), sourceName0, base, isPath, isUrl, sourceTypeName0, this.getSession(), base), this.sourceOrigin, sourceName0);
            }
            case "filePath": {
                return this.monitorInputStream(new InputFromPath(sourceName0.filteredText(), sourceName0, base, isPath, isUrl, sourceTypeName0, this.getSession(), base), this.sourceOrigin, sourceName0);
            }
            case "nutsPath": {
                return this.monitorInputStream(new InputFromNutsPath(sourceName0.filteredText(), sourceName0, base, isPath, isUrl, sourceTypeName0, this.getSession(), base), this.sourceOrigin, sourceName0);
            }
            case "file": {
                return this.monitorInputStream(new InputFromFile(sourceName0.filteredText(), sourceName0, base, isPath, isUrl, sourceTypeName0, this.getSession(), base), this.sourceOrigin, sourceName0);
            }
            case "stream": {
                return this.monitorInputStream(new InputFromStream(sourceName0.filteredText(), sourceName0, base, isPath, isUrl, sourceTypeName0, this.getSession(), base), this.sourceOrigin, sourceName0);
            }
        }
        throw new NutsUnsupportedArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported kind %s", (Object[])new Object[]{this.sourceKind}));
    }

    public boolean isLogProgress() {
        return this.logProgress;
    }

    public NutsMonitorAction setLogProgress(boolean value) {
        this.logProgress = value;
        return this;
    }

    public NutsProgressFactory getProgressFactory() {
        return this.progressFactory;
    }

    public NutsMonitorAction setProgressFactory(NutsProgressFactory value) {
        this.progressFactory = value;
        return this;
    }

    public NutsMonitorAction setProgressMonitor(NutsProgressMonitor value) {
        this.progressFactory = value == null ? null : new SingletonNutsInputStreamProgressFactory(value);
        return this;
    }

    public InputStream monitorInputStream(String path, Object source, NutsString sourceName) {
        this.checkSession();
        if (NutsUtilStrings.isBlank((CharSequence)path)) {
            throw new UncheckedIOException(new IOException("missing path"));
        }
        if (sourceName == null) {
            sourceName = this.session.getWorkspace().text().forStyled(path, NutsTextStyle.path());
        }
        NutsProgressMonitor monitor = CoreIOUtils.createProgressMonitor(CoreIOUtils.MonitorType.STREAM, path, source, this.session, this.isLogProgress(), this.getProgressFactory());
        boolean verboseMode = CoreBooleanUtils.getSysBoolNutsProperty("monitor.start", false);
        NutsInput stream = null;
        long size = -1L;
        try {
            if (verboseMode && monitor != null) {
                monitor.onStart((NutsProgressEvent)new DefaultNutsProgressEvent(source, sourceName, 0L, 0L, 0L, 0L, size, null, this.session, true));
            }
            stream = this.getSession().getWorkspace().io().input().setTypeName(this.getSourceTypeName()).of(path);
            size = stream.length();
        }
        catch (UncheckedIOException | NutsIOException e) {
            if (verboseMode && monitor != null) {
                monitor.onComplete((NutsProgressEvent)new DefaultNutsProgressEvent(source, sourceName, 0L, 0L, 0L, 0L, size, e, this.session, true));
            }
            throw e;
        }
        if (size < 0L) {
            size = this.getLength();
        }
        InputStream openedStream = stream.open();
        if (monitor == null) {
            return openedStream;
        }
        if (!verboseMode) {
            monitor.onStart((NutsProgressEvent)new DefaultNutsProgressEvent(source, sourceName, 0L, 0L, 0L, 0L, size, null, this.session, size < 0L));
        }
        return CoreIOUtils.monitor(openedStream, source, sourceName, size, new SilentStartNutsInputStreamProgressMonitorAdapter(this.ws, monitor, path), this.session);
    }

    public NutsInput monitorInputStream(NutsInput inputSource, Object source, NutsString sourceName) {
        String sourceTypeName;
        this.checkSession();
        if (inputSource == null) {
            throw new UncheckedIOException(new IOException("missing inputSource"));
        }
        if (sourceName == null) {
            sourceName = this.session.getWorkspace().text().toText((Object)inputSource.getName());
        }
        NutsProgressMonitor monitor = CoreIOUtils.createProgressMonitor(CoreIOUtils.MonitorType.STREAM, inputSource, source, this.session, this.isLogProgress(), this.getProgressFactory());
        boolean verboseMode = true;
        long size = -1L;
        try {
            if (verboseMode && monitor != null) {
                monitor.onStart((NutsProgressEvent)new DefaultNutsProgressEvent(source, sourceName, 0L, 0L, 0L, 0L, size, null, this.session, true));
            }
            size = inputSource.length();
        }
        catch (UncheckedIOException | NutsIOException e) {
            if (verboseMode && monitor != null) {
                monitor.onComplete((NutsProgressEvent)new DefaultNutsProgressEvent(source, sourceName, 0L, 0L, 0L, 0L, size, e, this.session, true));
            }
            throw e;
        }
        if (size < 0L) {
            size = this.getLength();
        }
        if (monitor == null) {
            return inputSource;
        }
        InputStream openedStream = inputSource.open();
        if (!verboseMode) {
            monitor.onStart((NutsProgressEvent)new DefaultNutsProgressEvent(source, sourceName, 0L, 0L, 0L, 0L, size, null, this.session, size < 0L));
        }
        if ((sourceTypeName = this.getSourceTypeName()) == null) {
            sourceTypeName = inputSource.getTypeName();
        }
        return this.getSession().getWorkspace().io().input().setTypeName(sourceTypeName).of(CoreIOUtils.monitor(openedStream, source, sourceName, size, new SilentStartNutsInputStreamProgressMonitorAdapter(this.ws, monitor, inputSource.toString()), this.session));
    }

    public NutsInput monitorInputStream(NutsPath inputSource, Object source, NutsString sourceName) {
        String sourceTypeName;
        this.checkSession();
        if (inputSource == null) {
            throw new UncheckedIOException(new IOException("missing inputSource"));
        }
        if (sourceName == null || sourceName.isEmpty()) {
            sourceName = this.session.getWorkspace().text().toText((Object)inputSource);
        }
        NutsProgressMonitor monitor = CoreIOUtils.createProgressMonitor(CoreIOUtils.MonitorType.STREAM, inputSource, source, this.session, this.isLogProgress(), this.getProgressFactory());
        boolean verboseMode = CoreBooleanUtils.getSysBoolNutsProperty("monitor.start", false);
        long size = -1L;
        try {
            if (verboseMode && monitor != null) {
                monitor.onStart((NutsProgressEvent)new DefaultNutsProgressEvent(source, sourceName, 0L, 0L, 0L, 0L, size, null, this.session, true));
            }
            size = inputSource.getContentLength();
        }
        catch (UncheckedIOException | NutsIOException e) {
            if (verboseMode && monitor != null) {
                monitor.onComplete((NutsProgressEvent)new DefaultNutsProgressEvent(source, sourceName, 0L, 0L, 0L, 0L, size, e, this.session, true));
            }
            throw e;
        }
        if (size < 0L) {
            size = this.getLength();
        }
        if (monitor == null) {
            return this.getSession().getWorkspace().io().input().setSession(this.getSession()).of(inputSource);
        }
        InputStream openedStream = this.getSession().getWorkspace().io().input().setSession(this.getSession()).of(inputSource).open();
        if (!verboseMode) {
            monitor.onStart((NutsProgressEvent)new DefaultNutsProgressEvent(source, sourceName, 0L, 0L, 0L, 0L, size, null, this.session, size < 0L));
        }
        if ((sourceTypeName = this.getSourceTypeName()) == null) {
            sourceTypeName = "nuts-Path";
        }
        return this.getSession().getWorkspace().io().input().setTypeName(sourceTypeName).of(CoreIOUtils.monitor(openedStream, source, sourceName, size, new SilentStartNutsInputStreamProgressMonitorAdapter(this.ws, monitor, inputSource.toString()), this.session));
    }

    public InputStream monitorInputStream(InputStream stream, Object sourceOrigin, long length, NutsString name) {
        this.checkSession();
        if (length > 0L) {
            NutsProgressMonitor m = CoreIOUtils.createProgressMonitor(CoreIOUtils.MonitorType.STREAM, stream, sourceOrigin, this.session, this.isLogProgress(), this.getProgressFactory());
            if (m == null) {
                return stream;
            }
            return CoreIOUtils.monitor(stream, sourceOrigin, (NutsString)(name == null ? this.session.getWorkspace().text().forPlain("Stream") : name), length, m, this.session);
        }
        if (stream instanceof InputStreamMetadataAware) {
            NutsProgressMonitor m = CoreIOUtils.createProgressMonitor(CoreIOUtils.MonitorType.STREAM, stream, sourceOrigin, this.session, this.isLogProgress(), this.getProgressFactory());
            if (m == null) {
                return stream;
            }
            return CoreIOUtils.monitor(stream, sourceOrigin, m, this.session);
        }
        return stream;
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
    }

    private class InputFromString
    extends CoreIOUtils.AbstractItem {
        private final NutsInput base;

        public InputFromString(String name, NutsString formattedName, Object value, boolean pathFlag, boolean urlFlag, String typeName, NutsSession session, NutsInput base) {
            super(name, formattedName, value, pathFlag, urlFlag, typeName, session);
            this.base = base;
        }

        @Override
        public InputStream open() {
            return DefaultNutsMonitorAction.this.monitorInputStream((String)DefaultNutsMonitorAction.this.source, DefaultNutsMonitorAction.this.sourceOrigin, DefaultNutsMonitorAction.this.sourceName);
        }

        public String toString() {
            return (String)DefaultNutsMonitorAction.this.source;
        }

        public long length() {
            return this.base.length();
        }

        public String getContentType() {
            return null;
        }

        public String getContentEncoding() {
            return null;
        }

        public Instant getLastModifiedInstant() {
            return null;
        }
    }

    private class InputFromNutsPath
    extends CoreIOUtils.AbstractItem {
        private final NutsInput base;

        public InputFromNutsPath(String string, NutsString formattedName, Object o, boolean bln, boolean bln1, String string1, NutsSession ns, NutsInput base) {
            super(string, formattedName, o, bln, bln1, string1, ns);
            this.base = base;
        }

        NutsPath np() {
            return (NutsPath)DefaultNutsMonitorAction.this.source;
        }

        @Override
        public InputStream open() {
            return DefaultNutsMonitorAction.this.monitorInputStream(this.np().asString(), DefaultNutsMonitorAction.this.sourceOrigin, DefaultNutsMonitorAction.this.sourceName);
        }

        public String toString() {
            return ((Path)DefaultNutsMonitorAction.this.source).toString();
        }

        public long length() {
            return this.base.length();
        }

        public String getContentType() {
            return null;
        }

        public String getContentEncoding() {
            return null;
        }

        public Instant getLastModifiedInstant() {
            FileTime r = null;
            try {
                r = Files.getLastModifiedTime(this.getFilePath(), new LinkOption[0]);
                if (r != null) {
                    return r.toInstant();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    private class InputFromPath
    extends CoreIOUtils.AbstractItem {
        private final NutsInput base;

        public InputFromPath(String string, NutsString formattedName, Object o, boolean bln, boolean bln1, String string1, NutsSession ns, NutsInput base) {
            super(string, formattedName, o, bln, bln1, string1, ns);
            this.base = base;
        }

        @Override
        public InputStream open() {
            return DefaultNutsMonitorAction.this.monitorInputStream(((Path)DefaultNutsMonitorAction.this.source).toString(), DefaultNutsMonitorAction.this.sourceOrigin, DefaultNutsMonitorAction.this.sourceName);
        }

        public String toString() {
            return ((Path)DefaultNutsMonitorAction.this.source).toString();
        }

        public long length() {
            return this.base.length();
        }

        public String getContentType() {
            return null;
        }

        public String getContentEncoding() {
            return null;
        }

        public Instant getLastModifiedInstant() {
            FileTime r = null;
            try {
                r = Files.getLastModifiedTime(this.getFilePath(), new LinkOption[0]);
                if (r != null) {
                    return r.toInstant();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    private class InputFromFile
    extends CoreIOUtils.AbstractItem {
        private final NutsInput base;

        public InputFromFile(String string, NutsString formattedName, Object o, boolean bln, boolean bln1, String string1, NutsSession ns, NutsInput base) {
            super(string, formattedName, o, bln, bln1, string1, ns);
            this.base = base;
        }

        @Override
        public InputStream open() {
            return DefaultNutsMonitorAction.this.monitorInputStream(((File)DefaultNutsMonitorAction.this.source).getPath(), DefaultNutsMonitorAction.this.sourceOrigin, DefaultNutsMonitorAction.this.sourceName);
        }

        @Override
        public Path getFilePath() {
            return ((File)DefaultNutsMonitorAction.this.source).toPath();
        }

        public String toString() {
            return ((File)DefaultNutsMonitorAction.this.source).getPath();
        }

        public long length() {
            return this.base.length();
        }

        public String getContentType() {
            return null;
        }

        public String getContentEncoding() {
            return null;
        }

        public Instant getLastModifiedInstant() {
            FileTime r = null;
            try {
                r = Files.getLastModifiedTime(this.getFilePath(), new LinkOption[0]);
                if (r != null) {
                    return r.toInstant();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    private class InputFromStream
    extends CoreIOUtils.AbstractItem {
        private final NutsInput base;

        public InputFromStream(String string, NutsString formattedName, Object o, boolean bln, boolean bln1, String string1, NutsSession ns, NutsInput base) {
            super(string, formattedName, o, bln, bln1, string1, ns);
            this.base = base;
        }

        @Override
        public InputStream open() {
            return DefaultNutsMonitorAction.this.monitorInputStream((InputStream)DefaultNutsMonitorAction.this.source, DefaultNutsMonitorAction.this.sourceOrigin, DefaultNutsMonitorAction.this.length, DefaultNutsMonitorAction.this.sourceName);
        }

        public String toString() {
            return ((InputStream)DefaultNutsMonitorAction.this.source).toString();
        }

        public long length() {
            return this.base.length();
        }

        public String getContentType() {
            return null;
        }

        public String getContentEncoding() {
            return null;
        }

        public Instant getLastModifiedInstant() {
            return null;
        }
    }
}

