/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import net.thevpc.nuts.NutsInput;
import net.thevpc.nuts.NutsInputAction;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsUnsupportedArgumentException;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.io.CoreInput;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsInputAction
implements NutsInputAction {
    private NutsWorkspace ws;
    private NutsString name;
    private String typeName;
    private NutsSession session;
    private boolean multiRead;

    public DefaultNutsInputAction(NutsWorkspace ws) {
        this.ws = ws;
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
    }

    public NutsInput of(Object source) {
        this.checkSession();
        if (source == null) {
            return null;
        }
        if (source instanceof NutsInput) {
            return (NutsInput)source;
        }
        if (source instanceof InputStream) {
            return this.of((InputStream)source);
        }
        if (source instanceof Path) {
            return this.of((Path)source);
        }
        if (source instanceof File) {
            return this.of((File)source);
        }
        if (source instanceof URL) {
            return this.of((URL)source);
        }
        if (source instanceof byte[]) {
            return this.of(new ByteArrayInputStream((byte[])source));
        }
        if (source instanceof String) {
            return this.of((String)source);
        }
        if (source instanceof NutsPath) {
            return this.of((NutsPath)source);
        }
        throw new NutsUnsupportedArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported type %s", (Object[])new Object[]{source.getClass().getName()}));
    }

    public NutsInput of(String resource) {
        return resource == null ? null : this.session.getWorkspace().io().path(resource).input();
    }

    private NutsInput toMulti(NutsInput v) {
        if (v == null) {
            return v;
        }
        if (this.isMultiRead()) {
            v = ((CoreInput)v).multi();
        }
        return v;
    }

    public NutsInput of(byte[] bytes) {
        this.checkSession();
        NutsString n = this.getName();
        if (n == null) {
            n = this.getSession().getWorkspace().text().forStyled("<bytes>", NutsTextStyle.path());
        }
        CoreInput v = CoreIOUtils.createInputSource(bytes, n.filteredText(), n, this.getTypeName(), this.getSession());
        v = this.toMulti(v);
        return v;
    }

    public NutsInput of(InputStream source) {
        if (source == null) {
            return null;
        }
        this.checkSession();
        NutsString name = this.getName();
        if (name == null) {
            name = this.getSession().getWorkspace().text().toText((Object)source);
        }
        return this.toMulti(new CoreIOUtils.InputStream(name.filteredText(), name, source, "inputStream", this.getSession()));
    }

    public NutsInput of(URL source) {
        this.checkSession();
        return this.getSession().getWorkspace().io().path(source).input();
    }

    public NutsInput of(File source) {
        this.checkSession();
        return this.getSession().getWorkspace().io().path(source).input();
    }

    public NutsInput of(Path source) {
        this.checkSession();
        return this.getSession().getWorkspace().io().path(source).input();
    }

    public NutsInput of(NutsPath stream) {
        this.checkSession();
        return stream == null ? null : stream.input();
    }

    public NutsInput of(NutsInput stream) {
        this.checkSession();
        return this.toMulti(stream);
    }

    public NutsString getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public NutsInputAction setName(NutsString name) {
        this.name = name;
        return this;
    }

    public NutsInputAction setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public boolean isMultiRead() {
        return this.multiRead;
    }

    public NutsInputAction setMultiRead(boolean multiRead) {
        this.multiRead = multiRead;
        return this;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsInputAction setSession(NutsSession session) {
        this.session = session;
        return this;
    }
}

