/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.thevpc.nuts.NutsIOUncompressAction;
import net.thevpc.nuts.NutsIOUncompressVisitor;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInput;
import net.thevpc.nuts.NutsInputAction;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOutput;
import net.thevpc.nuts.NutsOutputAction;
import net.thevpc.nuts.NutsProgressFactory;
import net.thevpc.nuts.NutsProgressMonitor;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedArgumentException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.SingletonNutsInputStreamProgressFactory;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsIOUncompressAction
implements NutsIOUncompressAction {
    private NutsLogger LOG;
    private boolean skipRoot = false;
    private boolean safe = true;
    private boolean logProgress = false;
    private String format = "zip";
    private NutsWorkspace ws;
    private NutsInput source;
    private NutsOutput target;
    private NutsSession session;
    private NutsProgressFactory progressMonitorFactory;

    public DefaultNutsIOUncompressAction(NutsWorkspace ws) {
        this.ws = ws;
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = this.ws.log().setSession(session).of(DefaultNutsIOUncompressAction.class);
        }
        return this.LOG;
    }

    public String getFormat() {
        return this.format;
    }

    public NutsIOUncompressAction setFormat(String format) {
        this.checkSession();
        if (NutsUtilStrings.isBlank((CharSequence)format)) {
            format = "zip";
        }
        switch (format) {
            case "zip": 
            case "gzip": 
            case "gz": {
                this.format = format;
                break;
            }
            default: {
                throw new NutsUnsupportedArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported compression format %s", (Object[])new Object[]{format}));
            }
        }
        return this;
    }

    public Object getSource() {
        return this.source;
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
    }

    private NutsInputAction _input() {
        this.checkSession();
        return this.ws.io().input().setSession(this.getSession());
    }

    public NutsIOUncompressAction setSource(InputStream source) {
        this.source = this._input().of(source);
        return this;
    }

    public NutsIOUncompressAction setSource(File source) {
        this.source = this._input().of(source);
        return this;
    }

    public NutsIOUncompressAction setSource(Path source) {
        this.source = this._input().of(source);
        return this;
    }

    public NutsIOUncompressAction setSource(URL source) {
        this.source = this._input().of(source);
        return this;
    }

    public NutsIOUncompressAction setTarget(Path target) {
        this.target = this._output().of(target);
        return this;
    }

    public NutsIOUncompressAction setTarget(String target) {
        this.target = this._output().of(target);
        return this;
    }

    public NutsIOUncompressAction setTarget(File target) {
        this.target = this._output().of(target);
        return this;
    }

    public DefaultNutsIOUncompressAction setSource(Object source) {
        this.source = this._input().of(source);
        return this;
    }

    public NutsIOUncompressAction from(String source) {
        this.source = this._input().of(source);
        return this;
    }

    protected NutsOutputAction _output() {
        this.checkSession();
        return this.ws.io().output().setSession(this.getSession());
    }

    public NutsIOUncompressAction to(String target) {
        this.target = this._output().of(target);
        return this;
    }

    public NutsIOUncompressAction from(Object source) {
        this.source = this._input().of(source);
        return this;
    }

    public NutsIOUncompressAction to(Object target) {
        this.target = this._output().of(target);
        return this;
    }

    public NutsIOUncompressAction to(NutsOutput target) {
        this.target = this._output().of((Object)target);
        return this;
    }

    public Object getTarget() {
        return this.target;
    }

    public DefaultNutsIOUncompressAction setTarget(Object target) {
        this.target = this._output().of(target);
        return this;
    }

    public NutsIOUncompressAction setTarget(NutsOutput target) {
        this.target = this._output().of((Object)target);
        return this;
    }

    public boolean isLogProgress() {
        return this.logProgress;
    }

    public DefaultNutsIOUncompressAction setLogProgress(boolean value) {
        this.logProgress = value;
        return this;
    }

    public NutsIOUncompressAction from(InputStream source) {
        return this.setSource(source);
    }

    public NutsIOUncompressAction from(File source) {
        return this.setSource(source);
    }

    public NutsIOUncompressAction from(Path source) {
        return this.setSource(source);
    }

    public NutsIOUncompressAction from(URL source) {
        return this.setSource(source);
    }

    public NutsIOUncompressAction to(File target) {
        return this.setTarget(target);
    }

    public NutsIOUncompressAction to(Path target) {
        return this.setTarget(target);
    }

    public boolean isSafe() {
        return this.safe;
    }

    public DefaultNutsIOUncompressAction setSafe(boolean value) {
        this.safe = value;
        return this;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsIOUncompressAction setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public NutsIOUncompressAction run() {
        NutsInput _source;
        this.checkSession();
        String format = this.getFormat();
        if (NutsUtilStrings.isBlank((CharSequence)format)) {
            format = "zip";
        }
        if ((_source = this.source) == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing source", (Object[])new Object[0]));
        }
        if (this.target == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing target", (Object[])new Object[0]));
        }
        if (this.isLogProgress() || this.getProgressMonitorFactory() != null) {
            _source = this.ws.io().monitor().setSource(_source).setSession(this.session).setProgressFactory(this.getProgressMonitorFactory()).setLogProgress(this.isLogProgress()).createSource();
        }
        this._LOGOP(this.session).level(Level.FINEST).verb(NutsLogVerb.START).log("uncompress {0} to {1}", new Object[]{_source, this.target});
        Path folder = this.target.getFilePath();
        CoreIOUtils.mkdirs(folder);
        switch (format) {
            case "zip": {
                this.runZip();
                break;
            }
            case "gzip": 
            case "gz": {
                this.runGZip();
                break;
            }
            default: {
                throw new NutsUnsupportedArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported format %s", (Object[])new Object[]{format}));
            }
        }
        return this;
    }

    public NutsIOUncompressAction visit(NutsIOUncompressVisitor visitor) {
        NutsInput _source;
        this.checkSession();
        String format = this.getFormat();
        if (NutsUtilStrings.isBlank((CharSequence)format)) {
            format = "zip";
        }
        if ((_source = this.source) == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing source", (Object[])new Object[0]));
        }
        if (this.target == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing target", (Object[])new Object[0]));
        }
        if (this.isLogProgress() || this.getProgressMonitorFactory() != null) {
            _source = this.ws.io().monitor().setSource(_source).setSession(this.session).setProgressFactory(this.getProgressMonitorFactory()).setLogProgress(this.isLogProgress()).createSource();
        }
        this._LOGOP(this.session).level(Level.FINEST).verb(NutsLogVerb.START).log("uncompress {0} to {1}", new Object[]{_source, this.target});
        Path folder = this.target.getFilePath();
        CoreIOUtils.mkdirs(folder);
        switch (format) {
            case "zip": {
                this.visitZip(visitor);
                break;
            }
            case "gzip": 
            case "gz": {
                this.visitGZip(visitor);
                break;
            }
            default: {
                throw new NutsUnsupportedArgumentException(this.getSession(), NutsMessage.cstyle((String)("unsupported format %s" + format), (Object[])new Object[0]));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runZip() {
        this.checkSession();
        NutsInput _source = this.source;
        try {
            byte[] buffer = new byte[1024];
            Path folder = this.target.getFilePath();
            try (InputStream _in = _source.open();
                 ZipInputStream zis = new ZipInputStream(_in);){
                ZipEntry ze = zis.getNextEntry();
                String root = null;
                while (ze != null) {
                    Path newFile;
                    String fileName = ze.getName();
                    if (this.skipRoot) {
                        if (root == null) {
                            if (fileName.endsWith("/")) {
                                root = fileName;
                                ze = zis.getNextEntry();
                                continue;
                            }
                            throw new IOException("tot a single root zip");
                        }
                        if (fileName.startsWith(root)) {
                            fileName = fileName.substring(root.length());
                        } else {
                            throw new IOException("tot a single root zip");
                        }
                    }
                    if (fileName.endsWith("/")) {
                        newFile = folder.resolve(fileName);
                        CoreIOUtils.mkdirs(newFile);
                    } else {
                        newFile = folder.resolve(fileName);
                        this._LOGOP(this.session).level(Level.FINEST).verb(NutsLogVerb.WARNING).log("file unzip : " + newFile, new Object[0]);
                        if (newFile.getParent() != null) {
                            CoreIOUtils.mkdirs(newFile.getParent());
                        }
                        try (OutputStream fos = Files.newOutputStream(newFile, new OpenOption[0]);){
                            int len;
                            while ((len = zis.read(buffer)) > 0) {
                                fos.write(buffer, 0, len);
                            }
                        }
                    }
                    ze = zis.getNextEntry();
                }
                zis.closeEntry();
            }
        }
        catch (IOException ex) {
            this._LOGOP(this.session).level(Level.CONFIG).verb(NutsLogVerb.FAIL).log("error uncompressing {0} to {1} : {2}", new Object[]{_source.getSource(), this.target.getSource(), ex});
            throw new UncheckedIOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitZip(NutsIOUncompressVisitor visitor) {
        this.checkSession();
        NutsInput _source = this.source;
        try {
            byte[] buffer = new byte[1024];
            try (InputStream _in = _source.open();
                 final ZipInputStream zis = new ZipInputStream(_in);){
                ZipEntry ze = zis.getNextEntry();
                String root = null;
                while (ze != null) {
                    String fileName = ze.getName();
                    if (this.skipRoot) {
                        if (root == null) {
                            if (fileName.endsWith("/")) {
                                root = fileName;
                                ze = zis.getNextEntry();
                                continue;
                            }
                            throw new IOException("tot a single root zip");
                        }
                        if (fileName.startsWith(root)) {
                            fileName = fileName.substring(root.length());
                        } else {
                            throw new IOException("tot a single root zip");
                        }
                    }
                    if (fileName.endsWith("/") ? !visitor.visitFolder(fileName) : !visitor.visitFile(fileName, new InputStream(){

                        @Override
                        public int read() throws IOException {
                            return zis.read();
                        }

                        @Override
                        public int read(byte[] b, int off, int len) throws IOException {
                            return zis.read(b, off, len);
                        }

                        @Override
                        public int read(byte[] b) throws IOException {
                            return zis.read(b);
                        }
                    })) break;
                    ze = zis.getNextEntry();
                }
                zis.closeEntry();
            }
        }
        catch (IOException ex) {
            this._LOGOP(this.session).level(Level.CONFIG).verb(NutsLogVerb.FAIL).log("error uncompressing {0} to {1} : {2}", new Object[]{_source.getSource(), this.target.getSource(), ex});
            throw new UncheckedIOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runGZip() {
        NutsInput _source = this.source;
        try {
            String baseName = _source.getName();
            byte[] buffer = new byte[1024];
            Path folder = this.target.getFilePath();
            try (InputStream _in = _source.open();
                 GZIPInputStream zis = new GZIPInputStream(_in);){
                String n = CoreIOUtils.getURLName(baseName == null ? "" : baseName);
                if (n.endsWith(".gz")) {
                    n = n.substring(0, n.length() - 3);
                }
                if (n.isEmpty()) {
                    n = "data";
                }
                Path newFile = folder.resolve(n);
                this._LOGOP(this.session).level(Level.FINEST).verb(NutsLogVerb.WARNING).log("file unzip : {0}", new Object[]{newFile});
                if (newFile.getParent() != null) {
                    CoreIOUtils.mkdirs(newFile.getParent());
                }
                try (OutputStream fos = Files.newOutputStream(newFile, new OpenOption[0]);){
                    int len;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
            }
        }
        catch (IOException ex) {
            this._LOGOP(this.session).level(Level.CONFIG).verb(NutsLogVerb.FAIL).log("error uncompressing {0} to {1} : {2}", new Object[]{_source.getSource(), this.target.getSource(), ex});
            throw new UncheckedIOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitGZip(NutsIOUncompressVisitor visitor) {
        NutsInput _source = this.source;
        try {
            String baseName = _source.getName();
            byte[] buffer = new byte[1024];
            try (InputStream _in = _source.open();
                 final GZIPInputStream zis = new GZIPInputStream(_in);){
                String n = CoreIOUtils.getURLName(baseName == null ? "" : baseName);
                if (n.endsWith(".gz")) {
                    n = n.substring(0, n.length() - 3);
                }
                if (n.isEmpty()) {
                    n = "data";
                }
                visitor.visitFile(n, new InputStream(){

                    @Override
                    public int read() throws IOException {
                        return zis.read();
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        return zis.read(b, off, len);
                    }

                    @Override
                    public int read(byte[] b) throws IOException {
                        return zis.read(b);
                    }
                });
            }
        }
        catch (IOException ex) {
            this._LOGOP(this.session).level(Level.CONFIG).verb(NutsLogVerb.FAIL).log("error uncompressing {0} to {1} : {2}", new Object[]{_source.getSource(), this.target.getSource(), ex});
            throw new UncheckedIOException(ex);
        }
    }

    public NutsProgressFactory getProgressMonitorFactory() {
        return this.progressMonitorFactory;
    }

    public NutsIOUncompressAction setProgressMonitorFactory(NutsProgressFactory value) {
        this.progressMonitorFactory = value;
        return this;
    }

    public NutsIOUncompressAction setProgressMonitor(NutsProgressMonitor value) {
        this.progressMonitorFactory = value == null ? null : new SingletonNutsInputStreamProgressFactory(value);
        return this;
    }

    public NutsIOUncompressAction progressMonitor(NutsProgressMonitor value) {
        return this.setProgressMonitor(value);
    }

    public boolean isSkipRoot() {
        return this.skipRoot;
    }

    public NutsIOUncompressAction setSkipRoot(boolean value) {
        this.skipRoot = true;
        return this;
    }

    public NutsIOUncompressAction setFormatOption(String option, Object value) {
        return this;
    }

    public Object getFormatOption(String option) {
        return null;
    }
}

