/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsIOProcessAction;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsProcessInfo;
import net.thevpc.nuts.NutsResultList;
import net.thevpc.nuts.NutsSdkLocation;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersionFilter;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.iter.IteratorBuilder;
import net.thevpc.nuts.runtime.bundles.iter.IteratorUtils;
import net.thevpc.nuts.runtime.core.io.DefaultNutsProcessInfo;
import net.thevpc.nuts.runtime.standalone.util.NutsCollectionResult;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsIOProcessAction
implements NutsIOProcessAction {
    private String processType;
    private NutsWorkspace ws;
    private NutsSession session;
    private boolean failFast;

    public DefaultNutsIOProcessAction(NutsWorkspace ws) {
        this.ws = ws;
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public NutsIOProcessAction setFailFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    public boolean isSupportedKillProcess() {
        this.checkSession();
        NutsOsFamily f = this.getSession().getWorkspace().env().getOsFamily();
        return f == NutsOsFamily.LINUX || f == NutsOsFamily.MACOS || f == NutsOsFamily.UNIX;
    }

    public boolean killProcess(String processId) {
        this.checkSession();
        return this.getSession().getWorkspace().exec().addCommand(new String[]{"kill", "-9", processId}).getResult() == 0;
    }

    public NutsIOProcessAction failFast(boolean failFast) {
        return this.setFailFast(failFast);
    }

    public NutsIOProcessAction failFast() {
        return this.failFast(true);
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsIOProcessAction setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public String getType() {
        return this.processType;
    }

    public NutsIOProcessAction setType(String processType) {
        this.processType = processType;
        return this;
    }

    public NutsIOProcessAction type(String processType) {
        return this.setType(processType);
    }

    private static String getJpsJavaHome(NutsWorkspace ws, String version, NutsSession session) {
        NutsSdkLocation[] availableJava;
        ArrayList<String> detectedJavaHomes = new ArrayList<String>();
        String jh = System.getProperty("java.home");
        detectedJavaHomes.add(jh);
        String v = DefaultNutsIOProcessAction.getJpsJavaHome(jh);
        if (v != null) {
            return v;
        }
        NutsVersionFilter nvf = NutsUtilStrings.isBlank((CharSequence)version) ? null : ws.version().parser().parse(version).filter();
        for (NutsSdkLocation java2 : availableJava = ws.sdks().setSession(session).find("java", java -> "jdk".equals(java.getPackaging()) && (nvf == null || nvf.acceptVersion(ws.version().parser().parse(java.getVersion()), session)))) {
            detectedJavaHomes.add(java2.getPath());
            v = DefaultNutsIOProcessAction.getJpsJavaHome(java2.getPath());
            if (v == null) continue;
            return v;
        }
        throw new NutsExecutionException(session, NutsMessage.cstyle((String)"unable to resolve a valid jdk installation. Either run nuts with a valid JDK/SDK (not JRE) or register a valid one using 'nuts settings' command. All the followings are invalid : \n%s", (Object[])new Object[]{String.join((CharSequence)"\n", detectedJavaHomes)}), 10);
    }

    private static String getJpsJavaHome(String base) {
        File jh = new File(base);
        if (new File(jh, ".." + File.separator + "bin" + File.separator + "jps").exists()) {
            return jh.getParent();
        }
        if (new File(jh, "bin" + File.separator + "jps").exists()) {
            return jh.getPath();
        }
        return null;
    }

    public NutsResultList<NutsProcessInfo> getResultList() {
        this.checkSession();
        String processType = NutsUtilStrings.trim((String)this.getType());
        if (processType.toLowerCase().startsWith("java#")) {
            return this.getResultListJava(processType.substring("java#".length()));
        }
        if (processType.toLowerCase().equals("java")) {
            return this.getResultListJava("");
        }
        if (this.isFailFast()) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported list processes of type : %s", (Object[])new Object[]{processType}));
        }
        return new NutsCollectionResult<NutsProcessInfo>(this.getSession(), "process-" + processType, Collections.emptyList());
    }

    private NutsResultList<NutsProcessInfo> getResultListJava(String version) {
        this.checkSession();
        Iterator<NutsProcessInfo> it = IteratorBuilder.ofLazy(() -> {
            String cmd = "jps";
            NutsExecCommand b = null;
            boolean mainArgs = true;
            boolean vmArgs = true;
            String jdkHome = DefaultNutsIOProcessAction.getJpsJavaHome(this.ws, version, this.session);
            if (jdkHome != null) {
                cmd = jdkHome + File.separator + "bin" + File.separator + cmd;
            }
            b = this.getSession().getWorkspace().exec().setExecutionType(NutsExecutionType.SYSTEM).addCommand(new String[]{cmd}).addCommand(new String[]{"-l" + (mainArgs ? "m" : "") + (vmArgs ? "v" : "")}).setRedirectErrorStream(true).grabOutputString().setFailFast(this.isFailFast());
            b.getResult();
            if (b.getResult() == 0) {
                String out = b.getOutputString();
                String[] split = out.split("\n");
                return Arrays.asList(split).iterator();
            }
            return IteratorUtils.emptyIterator();
        }).map(line -> {
            int s1 = line.indexOf(32);
            int s2 = line.indexOf(32, s1 + 1);
            String pid = line.substring(0, s1).trim();
            String cls = line.substring(s1 + 1, s2 < 0 ? line.length() : s2).trim();
            String args = s2 >= 0 ? line.substring(s2 + 1).trim() : "";
            return new DefaultNutsProcessInfo(pid, cls, null, args);
        }).build();
        return new NutsCollectionResult<NutsProcessInfo>(this.getSession(), "process-" + this.getType(), it);
    }
}

