/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.thevpc.nuts.NutsIOCompressAction;
import net.thevpc.nuts.NutsIOCopyAction;
import net.thevpc.nuts.NutsIODeleteAction;
import net.thevpc.nuts.NutsIOHashAction;
import net.thevpc.nuts.NutsIOProcessAction;
import net.thevpc.nuts.NutsIOUncompressAction;
import net.thevpc.nuts.NutsInputAction;
import net.thevpc.nuts.NutsMonitorAction;
import net.thevpc.nuts.NutsOutputAction;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathFactory;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsPrintStreamAdapter;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsSupplier;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsTempAction;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.runtime.bundles.io.NullInputStream;
import net.thevpc.nuts.runtime.bundles.parsers.StringPlaceHolderParser;
import net.thevpc.nuts.runtime.core.NutsSupplierBase;
import net.thevpc.nuts.runtime.core.format.text.SimpleWriterOutputStream;
import net.thevpc.nuts.runtime.core.io.ClassLoaderPath;
import net.thevpc.nuts.runtime.core.io.FilePath;
import net.thevpc.nuts.runtime.core.io.NutsPathFromSPI;
import net.thevpc.nuts.runtime.core.io.NutsResourcePath;
import net.thevpc.nuts.runtime.core.io.URLPath;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.boot.DefaultNutsBootModel;
import net.thevpc.nuts.runtime.standalone.io.DefaultNutsIOCompressAction;
import net.thevpc.nuts.runtime.standalone.io.DefaultNutsIOCopyAction;
import net.thevpc.nuts.runtime.standalone.io.DefaultNutsIODeleteAction;
import net.thevpc.nuts.runtime.standalone.io.DefaultNutsIOHashAction;
import net.thevpc.nuts.runtime.standalone.io.DefaultNutsIOProcessAction;
import net.thevpc.nuts.runtime.standalone.io.DefaultNutsIOUncompressAction;
import net.thevpc.nuts.runtime.standalone.io.DefaultNutsInputAction;
import net.thevpc.nuts.runtime.standalone.io.DefaultNutsMonitorAction;
import net.thevpc.nuts.runtime.standalone.io.DefaultNutsOutputAction;
import net.thevpc.nuts.runtime.standalone.io.DefaultTempAction;
import net.thevpc.nuts.runtime.standalone.io.NutsPrintStreamBase;
import net.thevpc.nuts.runtime.standalone.io.NutsPrintStreamNull;
import net.thevpc.nuts.runtime.standalone.io.NutsPrintStreamRaw;
import net.thevpc.nuts.runtime.standalone.io.NutsWorkspaceVarExpansionFunction;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsPathSPI;

public class DefaultNutsIOModel {
    public static final Pattern MOSTLY_URL_PATTERN = Pattern.compile("([a-zA-Z][a-zA-Z0-9_-]+):.*");
    public final NutsPrintStream nullOut;
    private final Function<String, String> pathExpansionConverter;
    public DefaultNutsBootModel bootModel;
    private NutsWorkspace ws;
    private InputStream stdin = null;
    private NutsPrintStream stdout;
    private NutsPrintStream stderr;
    private List<NutsPathFactory> pathFactories = new ArrayList<NutsPathFactory>();

    public DefaultNutsIOModel(NutsWorkspace workspace, DefaultNutsBootModel bootModel) {
        this.ws = workspace;
        this.pathExpansionConverter = new NutsWorkspaceVarExpansionFunction(this.ws);
        this.bootModel = bootModel;
        this.stdout = bootModel.stdout();
        this.stderr = bootModel.stderr();
        this.stdin = bootModel.stdin();
        this.nullOut = new NutsPrintStreamNull(bootModel.bootSession());
        this.addPathFactory(new FilePathFactory());
        this.addPathFactory(new ClasspathNutsPathFactory());
        this.addPathFactory(new URLPathFactory());
        this.addPathFactory(new NutsResourcePathFactory());
    }

    public NutsWorkspace getWorkspace() {
        return this.ws;
    }

    public int getSupportLevel(NutsSupportLevelContext<Object> criteria) {
        return 10;
    }

    public String expandPath(String path) {
        return this.expandPath(path, this.ws.locations().getWorkspaceLocation().toString());
    }

    public String expandPath(String path, String baseFolder) {
        if (path != null && path.length() > 0) {
            if (CoreIOUtils.isURL(path = StringPlaceHolderParser.replaceDollarPlaceHolders(path, this.pathExpansionConverter))) {
                return path;
            }
            Path ppath = Paths.get(path, new String[0]);
            if (path.startsWith("~")) {
                if (path.equals("~~")) {
                    Path nutsHome = Paths.get(this.ws.locations().getHomeLocation(NutsStoreLocation.CONFIG), new String[0]);
                    return nutsHome.normalize().toString();
                }
                if (path.startsWith("~~") && path.length() > 2 && (path.charAt(2) == '/' || path.charAt(2) == '\\')) {
                    Path nutsHome = Paths.get(this.ws.locations().getHomeLocation(NutsStoreLocation.CONFIG), new String[0]);
                    return nutsHome.resolve(path.substring(3)).normalize().toString();
                }
                if (path.equals("~")) {
                    return System.getProperty("user.home");
                }
                if (path.startsWith("~") && path.length() > 1 && (path.charAt(1) == '/' || path.charAt(1) == '\\')) {
                    return System.getProperty("user.home") + File.separator + path.substring(2);
                }
                if (baseFolder != null) {
                    if (CoreIOUtils.isURL(baseFolder)) {
                        return baseFolder + "/" + path;
                    }
                    return Paths.get(baseFolder, new String[0]).resolve(path).toAbsolutePath().normalize().toString();
                }
                if (CoreIOUtils.isURL(path)) {
                    return path;
                }
                return ppath.toAbsolutePath().normalize().toString();
            }
            if (ppath.isAbsolute()) {
                return ppath.normalize().toString();
            }
            if (baseFolder != null) {
                if (CoreIOUtils.isURL(baseFolder)) {
                    return baseFolder + "/" + path;
                }
                return Paths.get(baseFolder, new String[0]).resolve(path).toAbsolutePath().normalize().toString();
            }
            return ppath.toAbsolutePath().normalize().toString();
        }
        if (CoreIOUtils.isURL(baseFolder)) {
            return baseFolder;
        }
        return Paths.get(baseFolder, new String[0]).toAbsolutePath().normalize().toString();
    }

    public InputStream nullInputStream() {
        return NullInputStream.INSTANCE;
    }

    public NutsPrintStream nullPrintStream() {
        return this.nullOut;
    }

    public NutsPrintStream createPrintStream(Writer out, NutsTerminalMode expectedMode, NutsSession session) {
        if (out == null) {
            return null;
        }
        if (out instanceof NutsPrintStreamAdapter) {
            return ((NutsPrintStreamAdapter)out).getBaseNutsPrintStream().convertMode(expectedMode);
        }
        SimpleWriterOutputStream w = new SimpleWriterOutputStream(out, session);
        return this.createPrintStream(w, expectedMode, session);
    }

    public NutsPrintStream createPrintStream(OutputStream out, NutsTerminalMode expectedMode, NutsSession session) {
        if (out == null) {
            return null;
        }
        NutsWorkspaceOptions woptions = this.ws.env().setSession(session).getBootOptions();
        NutsTerminalMode expectedMode0 = woptions.getTerminalMode();
        if (expectedMode0 == null) {
            expectedMode0 = woptions.isBot() ? NutsTerminalMode.FILTERED : NutsTerminalMode.FORMATTED;
        }
        if (expectedMode == null) {
            expectedMode = expectedMode0;
        }
        if (expectedMode == NutsTerminalMode.FORMATTED && expectedMode0 == NutsTerminalMode.FILTERED) {
            expectedMode = NutsTerminalMode.FILTERED;
        }
        if (out instanceof NutsPrintStreamAdapter) {
            return ((NutsPrintStreamAdapter)out).getBaseNutsPrintStream().convertMode(expectedMode);
        }
        return new NutsPrintStreamRaw(out, null, null, session, new NutsPrintStreamBase.Bindings()).convertMode(expectedMode);
    }

    public NutsTempAction tmp() {
        return new DefaultTempAction(this.ws);
    }

    public NutsIOCopyAction copy() {
        return new DefaultNutsIOCopyAction(this.ws);
    }

    public NutsIOProcessAction ps() {
        return new DefaultNutsIOProcessAction(this.ws);
    }

    public NutsIOCompressAction compress() {
        return new DefaultNutsIOCompressAction(this.ws);
    }

    public NutsIOUncompressAction uncompress() {
        return new DefaultNutsIOUncompressAction(this.ws);
    }

    public NutsIODeleteAction delete() {
        return new DefaultNutsIODeleteAction(this.ws);
    }

    public NutsMonitorAction monitor() {
        return new DefaultNutsMonitorAction(this.ws);
    }

    public NutsIOHashAction hash() {
        return new DefaultNutsIOHashAction(this.ws);
    }

    public NutsInputAction input() {
        return new DefaultNutsInputAction(this.ws);
    }

    public NutsOutputAction output() {
        return new DefaultNutsOutputAction(this.ws);
    }

    public InputStream stdin() {
        return this.stdin == null ? this.bootModel.stdin() : this.stdin;
    }

    public void setStdin(InputStream stdin) {
        this.stdin = stdin;
    }

    public NutsPrintStream stdout() {
        return this.stdout;
    }

    public void setStdout(NutsPrintStream stdout) {
        this.stdout = stdout == null ? this.bootModel.stdout() : stdout;
    }

    public NutsPrintStream stderr() {
        return this.stderr;
    }

    public void setStderr(NutsPrintStream stderr) {
        this.stderr = stderr == null ? this.bootModel.stderr() : stderr;
    }

    public void addPathFactory(NutsPathFactory f) {
        if (f != null && !this.pathFactories.contains(f)) {
            this.pathFactories.add(f);
        }
    }

    public void removePathFactory(NutsPathFactory f) {
        this.pathFactories.remove(f);
    }

    public NutsPath resolve(String path, NutsSession session, ClassLoader classLoader) {
        NutsPathSPI s;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        ClassLoader finalClassLoader = classLoader;
        NutsSupplier z = Arrays.stream(this.getPathFactories()).map(x -> {
            try {
                return x.createPath(path, session, finalClassLoader);
            }
            catch (Exception exception) {
                return null;
            }
        }).filter(x -> x != null && x.getLevel() > 0).max(Comparator.comparingInt(NutsSupplier::getLevel)).orElse(null);
        NutsPathSPI nutsPathSPI = s = z == null ? null : (NutsPathSPI)z.create();
        if (s != null) {
            if (s instanceof NutsPath) {
                return (NutsPath)s;
            }
            return new NutsPathFromSPI(s);
        }
        return null;
    }

    public NutsPathFactory[] getPathFactories() {
        return this.pathFactories.toArray(new NutsPathFactory[0]);
    }

    private class FilePathFactory
    implements NutsPathFactory {
        private FilePathFactory() {
        }

        public NutsSupplier<NutsPathSPI> createPath(String path, final NutsSession session, ClassLoader classLoader) {
            NutsWorkspaceUtils.checkSession(DefaultNutsIOModel.this.getWorkspace(), session);
            try {
                if (MOSTLY_URL_PATTERN.matcher(path).matches()) {
                    return null;
                }
                final Path value = Paths.get(path, new String[0]);
                return new NutsSupplierBase<NutsPathSPI>(1){

                    public NutsPathSPI create() {
                        return new FilePath(value, session);
                    }
                };
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private class ClasspathNutsPathFactory
    implements NutsPathFactory {
        private ClasspathNutsPathFactory() {
        }

        public NutsSupplier<NutsPathSPI> createPath(final String path, final NutsSession session, final ClassLoader classLoader) {
            NutsWorkspaceUtils.checkSession(DefaultNutsIOModel.this.getWorkspace(), session);
            try {
                if (path.startsWith("classpath:")) {
                    return new NutsSupplierBase<NutsPathSPI>(2){

                        public NutsPathSPI create() {
                            return new ClassLoaderPath(path, classLoader, session);
                        }
                    };
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    private class NutsResourcePathFactory
    implements NutsPathFactory {
        private NutsResourcePathFactory() {
        }

        public NutsSupplier<NutsPathSPI> createPath(final String path, final NutsSession session, ClassLoader classLoader) {
            NutsWorkspaceUtils.checkSession(DefaultNutsIOModel.this.getWorkspace(), session);
            try {
                if (path.startsWith("nuts-resource:")) {
                    return new NutsSupplierBase<NutsPathSPI>(2){

                        public NutsPathSPI create() {
                            return new NutsResourcePath(path, session);
                        }
                    };
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    private class URLPathFactory
    implements NutsPathFactory {
        private URLPathFactory() {
        }

        public NutsSupplier<NutsPathSPI> createPath(String path, final NutsSession session, ClassLoader classLoader) {
            NutsWorkspaceUtils.checkSession(DefaultNutsIOModel.this.getWorkspace(), session);
            try {
                final URL url = new URL(path);
                return new NutsSupplierBase<NutsPathSPI>(2){

                    public NutsPathSPI create() {
                        return new URLPath(url, session);
                    }
                };
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

