/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsIOHashAction;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedArgumentException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsIOHashAction
implements NutsIOHashAction {
    private Object value;
    private String type;
    private String algorithm;
    private NutsWorkspace ws;
    private NutsSession session;

    public DefaultNutsIOHashAction(NutsWorkspace ws) {
        this.ws = ws;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public NutsIOHashAction algorithm(String algorithm) {
        return this.setAlgorithm(algorithm);
    }

    public NutsIOHashAction setAlgorithm(String algorithm) {
        if (NutsUtilStrings.isBlank((CharSequence)algorithm)) {
            algorithm = null;
        }
        try {
            MessageDigest.getInstance(algorithm);
            this.algorithm = algorithm;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException(ex);
        }
        return this;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsIOHashAction setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public NutsIOHashAction sha1() {
        return this.setAlgorithm("SHA1");
    }

    public NutsIOHashAction md5() {
        return this.setAlgorithm("MD5");
    }

    public NutsIOHashAction setSource(InputStream input) {
        this.value = input;
        this.type = "stream";
        return this;
    }

    public NutsIOHashAction setSource(File file) {
        this.value = file;
        this.type = "file";
        return this;
    }

    public NutsIOHashAction setSource(Path path) {
        this.value = path;
        this.type = "path";
        return this;
    }

    public NutsIOHashAction setSource(NutsPath path) {
        this.value = path;
        this.type = "nuts-path";
        return this;
    }

    public NutsIOHashAction setSource(NutsDescriptor descriptor) {
        this.value = descriptor;
        this.type = "desc";
        return this;
    }

    public String computeString() {
        return NutsUtilStrings.toHexString((byte[])this.computeBytes());
    }

    protected String getValidAlgo() {
        if (this.algorithm == null) {
            return "SHA1";
        }
        return this.algorithm;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NutsIOHashAction writeHash(OutputStream out) {
        this.checkSession();
        if (this.type == null) throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing Source", (Object[])new Object[0]));
        if (this.value == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing Source", (Object[])new Object[0]));
        }
        switch (this.type) {
            case "stream": {
                try {
                    out.write(CoreIOUtils.evalHash((InputStream)this.value, this.getValidAlgo()));
                    return this;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            case "file": {
                try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(((File)this.value).toPath(), new OpenOption[0]));){
                    out.write(CoreIOUtils.evalHash(is, this.getValidAlgo()));
                    DefaultNutsIOHashAction defaultNutsIOHashAction = this;
                    return defaultNutsIOHashAction;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            case "path": {
                try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream((Path)this.value, new OpenOption[0]));){
                    out.write(CoreIOUtils.evalHash(is, this.getValidAlgo()));
                    DefaultNutsIOHashAction defaultNutsIOHashAction = this;
                    return defaultNutsIOHashAction;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            case "nuts-path": {
                try (BufferedInputStream is = new BufferedInputStream(((NutsPath)this.value).input().open());){
                    out.write(CoreIOUtils.evalHash(is, this.getValidAlgo()));
                    DefaultNutsIOHashAction defaultNutsIOHashAction = this;
                    return defaultNutsIOHashAction;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            case "desc": {
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                this.ws.descriptor().formatter((NutsDescriptor)this.value).compact().print((Writer)new OutputStreamWriter(o));
                try (ByteArrayInputStream is = new ByteArrayInputStream(o.toByteArray());){
                    out.write(CoreIOUtils.evalHash(is, this.getValidAlgo()));
                    DefaultNutsIOHashAction defaultNutsIOHashAction = this;
                    return defaultNutsIOHashAction;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
        }
        throw new NutsUnsupportedArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported type %s", (Object[])new Object[]{this.type}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] computeBytes() {
        if (this.type == null) throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing Source", (Object[])new Object[0]));
        if (this.value == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing Source", (Object[])new Object[0]));
        }
        switch (this.type) {
            case "stream": {
                return CoreIOUtils.evalHash((InputStream)this.value, this.getValidAlgo());
            }
            case "file": {
                try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(((File)this.value).toPath(), new OpenOption[0]));){
                    byte[] byArray = CoreIOUtils.evalHash(is, this.getValidAlgo());
                    return byArray;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            case "path": {
                try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream((Path)this.value, new OpenOption[0]));){
                    byte[] byArray = CoreIOUtils.evalHash(is, this.getValidAlgo());
                    return byArray;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            case "desc": {
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                this.ws.descriptor().formatter((NutsDescriptor)this.value).compact().setSession(this.session).print((Writer)new OutputStreamWriter(o));
                try (ByteArrayInputStream is = new ByteArrayInputStream(o.toByteArray());){
                    byte[] byArray = CoreIOUtils.evalHash(is, this.getValidAlgo());
                    return byArray;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
        }
        throw new NutsUnsupportedArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported type %s", (Object[])new Object[]{this.type}));
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
    }
}

