/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import java.util.logging.Level;
import net.thevpc.nuts.NutsIOCopyAction;
import net.thevpc.nuts.NutsIOCopyValidationException;
import net.thevpc.nuts.NutsIOCopyValidator;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInput;
import net.thevpc.nuts.NutsInputAction;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOutput;
import net.thevpc.nuts.NutsOutputAction;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsProgressEvent;
import net.thevpc.nuts.NutsProgressFactory;
import net.thevpc.nuts.NutsProgressMonitor;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.io.InterruptException;
import net.thevpc.nuts.runtime.bundles.io.Interruptible;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.SingletonNutsInputStreamProgressFactory;
import net.thevpc.nuts.runtime.standalone.io.progress.DefaultNutsProgressEvent;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsIOCopyAction
implements NutsIOCopyAction {
    private NutsLogger LOG;
    private NutsIOCopyValidator checker;
    private boolean skipRoot = false;
    private boolean safe = true;
    private boolean logProgress = false;
    private NutsInput source;
    private NutsOutput target;
    private NutsSession session;
    private NutsProgressFactory progressMonitorFactory;
    private boolean interruptible;
    private boolean interrupted;
    private boolean recursive;
    private boolean mkdirs;
    private Interruptible interruptibleInstance;
    private NutsWorkspace ws;

    public DefaultNutsIOCopyAction(NutsWorkspace ws) {
        this.ws = ws;
    }

    private static Path transformPath(Path f, Path sourceBase, Path targetBase) {
        String bs;
        String fs = f.toString();
        if (fs.startsWith(bs = sourceBase.toString())) {
            String relative = fs.substring(bs.length());
            if (!relative.startsWith(File.separator)) {
                relative = File.separator + relative;
            }
            String x = targetBase + relative;
            return Paths.get(x, new String[0]);
        }
        throw new RuntimeException("Invalid path " + f);
    }

    protected NutsLoggerOp _LOGOP(NutsSession session) {
        return this._LOG(session).with().session(session);
    }

    protected NutsLogger _LOG(NutsSession session) {
        if (this.LOG == null) {
            this.LOG = this.ws.log().setSession(session).of(DefaultNutsIOCopyAction.class);
        }
        return this.LOG;
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
    }

    public Object getSource() {
        return this.source;
    }

    public DefaultNutsIOCopyAction setSource(Object source) {
        this.source = this._input().of(source);
        return this;
    }

    public NutsIOCopyAction setSource(NutsInput source) {
        this.source = this._input().of(source);
        return this;
    }

    public NutsIOCopyAction setSource(InputStream source) {
        this.source = this._input().of(source);
        return this;
    }

    public NutsIOCopyAction setSource(File source) {
        this.source = this._input().of(source);
        return this;
    }

    public NutsIOCopyAction setSource(Path source) {
        this.source = this._input().of(source);
        return this;
    }

    public NutsIOCopyAction setSource(URL source) {
        this.source = this._input().of(source);
        return this;
    }

    public NutsIOCopyAction setSource(String source) {
        this.source = this._input().of(source);
        return this;
    }

    public NutsIOCopyAction from(Object source) {
        this.source = this._input().of(source);
        return this;
    }

    public NutsIOCopyAction from(String source) {
        this.source = this._input().of(source);
        return this;
    }

    public NutsIOCopyAction from(NutsInput source) {
        return this.setSource(source);
    }

    public NutsIOCopyAction from(InputStream source) {
        return this.setSource(source);
    }

    public NutsIOCopyAction from(File source) {
        return this.setSource(source);
    }

    public NutsIOCopyAction from(Path source) {
        return this.setSource(source);
    }

    public NutsIOCopyAction from(URL source) {
        return this.setSource(source);
    }

    public Object getTarget() {
        return this.target;
    }

    public NutsIOCopyAction setTarget(OutputStream target) {
        this.target = this._output().of(target);
        return this;
    }

    public NutsIOCopyAction setTarget(NutsPath target) {
        this.target = this._output().of(target);
        return this;
    }

    public NutsIOCopyAction setTarget(NutsOutput target) {
        this.target = target;
        return this;
    }

    public NutsIOCopyAction setTarget(Path target) {
        this.target = this._output().of(target);
        return this;
    }

    public NutsIOCopyAction setTarget(String target) {
        this.target = this._output().of(target);
        return this;
    }

    public NutsIOCopyAction setTarget(File target) {
        this.target = this._output().of(target);
        return this;
    }

    public NutsIOCopyAction to(Object target) {
        this.target = this._output().of(target);
        return this;
    }

    public NutsIOCopyAction to(OutputStream target) {
        return this.setTarget(target);
    }

    public NutsIOCopyAction to(String target) {
        this.target = this._output().of(target);
        return this;
    }

    public NutsIOCopyAction to(Path target) {
        return this.setTarget(target);
    }

    public NutsIOCopyAction to(File target) {
        return this.setTarget(target);
    }

    public NutsIOCopyAction to(NutsOutput target) {
        return this.setTarget(target);
    }

    public NutsIOCopyValidator getValidator() {
        return this.checker;
    }

    public DefaultNutsIOCopyAction setValidator(NutsIOCopyValidator checker) {
        this.checker = checker;
        return this;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public NutsIOCopyAction setRecursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public boolean isMkdirs() {
        return this.mkdirs;
    }

    public NutsIOCopyAction setMkdirs(boolean mkdirs) {
        this.mkdirs = mkdirs;
        return this;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public DefaultNutsIOCopyAction setSafe(boolean value) {
        this.safe = value;
        return this;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsIOCopyAction setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public byte[] getByteArrayResult() {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        this.to(b);
        this.setSafe(false);
        this.run();
        return b.toByteArray();
    }

    public NutsIOCopyAction run() {
        this.checkSession();
        NutsInput _source = this.source;
        if (_source == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.formatted((String)"missing source"));
        }
        if (this.target == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.formatted((String)"missing target"));
        }
        if (_source.isFile() && Files.isDirectory(_source.getFilePath(), new LinkOption[0])) {
            if (!this.target.isPath()) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported copy of directory to %s", (Object[])new Object[]{this.target}));
            }
            Path toPath = this.target.getFilePath();
            CopyData cd = new CopyData();
            if (this.isLogProgress() || this.getProgressMonitorFactory() != null) {
                this.prepareCopyFolder(_source.getFilePath(), cd);
                this.copyFolderWithMonitor(_source.getFilePath(), toPath, cd);
            } else {
                this.copyFolderNoMonitor(_source.getFilePath(), toPath, cd);
            }
            return this;
        }
        this.copyStream();
        return this;
    }

    public boolean isLogProgress() {
        return this.logProgress;
    }

    public DefaultNutsIOCopyAction setLogProgress(boolean value) {
        this.logProgress = value;
        return this;
    }

    public NutsProgressFactory getProgressMonitorFactory() {
        return this.progressMonitorFactory;
    }

    public NutsIOCopyAction setProgressMonitorFactory(NutsProgressFactory value) {
        this.progressMonitorFactory = value;
        return this;
    }

    public NutsIOCopyAction setProgressMonitor(NutsProgressMonitor value) {
        this.progressMonitorFactory = value == null ? null : new SingletonNutsInputStreamProgressFactory(value);
        return this;
    }

    public NutsIOCopyAction setSkipRoot(boolean skipRoot) {
        this.skipRoot = skipRoot;
        return this;
    }

    public boolean isSkipRoot() {
        return this.skipRoot;
    }

    public boolean isInterruptible() {
        return this.interruptible;
    }

    public NutsIOCopyAction setInterruptible(boolean interruptible) {
        this.interruptible = interruptible;
        return this;
    }

    public NutsIOCopyAction interrupt() {
        if (this.interruptibleInstance != null) {
            this.interruptibleInstance.interrupt();
        }
        this.interrupted = true;
        return this;
    }

    public DefaultNutsIOCopyAction setTarget(Object target) {
        this.target = this._output().of(target);
        return this;
    }

    protected NutsInputAction _input() {
        this.checkSession();
        return this.getSession().getWorkspace().io().input().setSession(this.getSession());
    }

    protected NutsOutputAction _output() {
        this.checkSession();
        return this.getSession().getWorkspace().io().output().setSession(this.getSession());
    }

    private void checkInterrupted() {
        if (this.interrupted) {
            throw new UncheckedIOException(new IOException(new InterruptException()));
        }
    }

    private void prepareCopyFolder(Path d, final CopyData f) {
        try {
            Files.walkFileTree(d, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    DefaultNutsIOCopyAction.this.checkInterrupted();
                    ++f.folders;
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    DefaultNutsIOCopyAction.this.checkInterrupted();
                    ++f.files;
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    DefaultNutsIOCopyAction.this.checkInterrupted();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    DefaultNutsIOCopyAction.this.checkInterrupted();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
    }

    private void copyFolderWithMonitor(final Path srcBase, final Path targetBase, final CopyData f) {
        this.checkSession();
        NutsSession session = this.getSession();
        final long start = System.currentTimeMillis();
        final NutsProgressMonitor m = CoreIOUtils.createProgressMonitor(CoreIOUtils.MonitorType.DEFAULT, srcBase, srcBase, session, this.isLogProgress(), this.getProgressMonitorFactory());
        final NutsText srcBaseMessage = session.getWorkspace().text().toText((Object)srcBase);
        m.onStart((NutsProgressEvent)new DefaultNutsProgressEvent(srcBase, (NutsString)srcBaseMessage, 0L, 0L, 0L, 0L, f.files + f.folders, null, session, false));
        try {
            final NutsSession finalSession = session;
            Files.walkFileTree(srcBase, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    DefaultNutsIOCopyAction.this.checkInterrupted();
                    ++f.doneFolders;
                    CoreIOUtils.mkdirs(DefaultNutsIOCopyAction.transformPath(dir, srcBase, targetBase));
                    m.onProgress((NutsProgressEvent)new DefaultNutsProgressEvent(srcBase, (NutsString)srcBaseMessage, f.doneFiles + f.doneFolders, System.currentTimeMillis() - start, 0L, 0L, f.files + f.folders, null, finalSession, false));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    DefaultNutsIOCopyAction.this.checkInterrupted();
                    ++f.doneFiles;
                    DefaultNutsIOCopyAction.this.copy(file, DefaultNutsIOCopyAction.transformPath(file, srcBase, targetBase), new CopyOption[0]);
                    m.onProgress((NutsProgressEvent)new DefaultNutsProgressEvent(srcBase, (NutsString)srcBaseMessage, f.doneFiles + f.doneFolders, System.currentTimeMillis() - start, 0L, 0L, f.files + f.folders, null, finalSession, false));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    DefaultNutsIOCopyAction.this.checkInterrupted();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    DefaultNutsIOCopyAction.this.checkInterrupted();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
        finally {
            m.onComplete((NutsProgressEvent)new DefaultNutsProgressEvent(srcBase, (NutsString)srcBaseMessage, f.files + f.folders, System.currentTimeMillis() - start, 0L, 0L, f.files + f.folders, null, session, false));
        }
    }

    public Path copy(Path source, Path target, CopyOption ... options) throws IOException {
        if (this.interruptible) {
            try (InputStream in = CoreIOUtils.interruptible(Files.newInputStream(source, new OpenOption[0]));){
                this.interruptibleInstance = (Interruptible)((Object)in);
                try (OutputStream out = Files.newOutputStream(target, new OpenOption[0]);){
                    this.transferTo(in, out);
                }
            }
            return target;
        }
        return Files.copy(source, target, options);
    }

    public long copy(InputStream in, Path target, CopyOption ... options) throws IOException {
        if (this.interruptible) {
            in = CoreIOUtils.interruptible(in);
            this.interruptibleInstance = (Interruptible)((Object)in);
            try (OutputStream out = Files.newOutputStream(target, new OpenOption[0]);){
                long l = this.transferTo(in, out);
                return l;
            }
        }
        return Files.copy(in, target, options);
    }

    public long copy(InputStream in, OutputStream out, CopyOption ... options) throws IOException {
        if (this.interruptible) {
            in = CoreIOUtils.interruptible(in);
            this.interruptibleInstance = (Interruptible)((Object)in);
            return this.transferTo(in, out);
        }
        return CoreIOUtils.copy(in, out);
    }

    public long copy(Path source, OutputStream out) throws IOException {
        if (this.interruptible) {
            try (InputStream in = CoreIOUtils.interruptible(Files.newInputStream(source, new OpenOption[0]));){
                this.interruptibleInstance = (Interruptible)((Object)in);
                long l = this.transferTo(in, out);
                return l;
            }
        }
        return Files.copy(source, out);
    }

    private long transferTo(InputStream in, OutputStream out) throws IOException {
        int read;
        int DEFAULT_BUFFER_SIZE = 8192;
        Objects.requireNonNull(out, "out");
        long transferred = 0L;
        byte[] buffer = new byte[DEFAULT_BUFFER_SIZE];
        while ((read = in.read(buffer, 0, DEFAULT_BUFFER_SIZE)) >= 0) {
            this.checkInterrupted();
            out.write(buffer, 0, read);
            transferred += (long)read;
        }
        return transferred;
    }

    private void copyFolderNoMonitor(final Path srcBase, final Path targetBase, final CopyData f) {
        try {
            Files.walkFileTree(srcBase, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    DefaultNutsIOCopyAction.this.checkInterrupted();
                    ++f.doneFolders;
                    CoreIOUtils.mkdirs(DefaultNutsIOCopyAction.transformPath(dir, srcBase, targetBase));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    DefaultNutsIOCopyAction.this.checkInterrupted();
                    ++f.doneFiles;
                    DefaultNutsIOCopyAction.this.copy(file, DefaultNutsIOCopyAction.transformPath(file, srcBase, targetBase), new CopyOption[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    DefaultNutsIOCopyAction.this.checkInterrupted();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    DefaultNutsIOCopyAction.this.checkInterrupted();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyStream() {
        block123: {
            this.checkSession();
            NutsInput _source = this.source;
            boolean _target_isPath = this.target.isPath();
            if (this.checker != null && !_target_isPath && !this.safe) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.formatted((String)"unsupported validation if neither safeCopy is armed nor path is defined"));
            }
            if (this.isLogProgress() || this.getProgressMonitorFactory() != null) {
                _source = this.getSession().getWorkspace().io().monitor().setSource(_source).setSession(this.session).setProgressFactory(this.getProgressMonitorFactory()).setLogProgress(this.isLogProgress()).createSource();
            }
            this._LOGOP(this.session).level(Level.FINEST).verb(NutsLogVerb.START).log("copy {0} to {1}", new Object[]{_source, this.target});
            try {
                if (this.safe) {
                    Throwable throwable;
                    Path temp = null;
                    if (_target_isPath) {
                        Path to = this.target.getFilePath();
                        CoreIOUtils.mkdirs(to.getParent());
                        temp = to.resolveSibling(to.getFileName() + "~");
                    } else {
                        temp = Paths.get(this.getSession().getWorkspace().io().tmp().setSession(this.session).createTempFile("temp~"), new String[0]);
                    }
                    if (_source.isFile()) {
                        this.copy(_source.getFilePath(), temp, StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        throwable = null;
                        try (InputStream ins = _source.open();){
                            this.copy(ins, temp, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    this._validate(temp);
                    if (_target_isPath) {
                        try {
                            Files.move(temp, this.target.getFilePath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (FileSystemException e) {
                            if (CoreIOUtils.compareContent(temp, this.target.getFilePath())) {
                                if (temp != null && Files.exists(temp, new LinkOption[0])) {
                                    Files.delete(temp);
                                }
                                return;
                            }
                            throw e;
                        }
                        temp = null;
                        break block123;
                    }
                    OutputStream ops = this.target.open();
                    throwable = null;
                    try {
                        this.copy(temp, ops);
                        break block123;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (temp != null && Files.exists(temp, new LinkOption[0])) {
                            Files.delete(temp);
                        }
                    }
                }
                if (_target_isPath) {
                    Path to = this.target.getFilePath();
                    CoreIOUtils.mkdirs(to.getParent());
                    if (_source.isFile()) {
                        this.copy(_source.getFilePath(), this.target.getFilePath(), StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        try (InputStream ins = _source.open();){
                            this.copy(ins, this.target.getFilePath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    this._validate(this.target.getFilePath());
                    break block123;
                }
                ByteArrayOutputStream bos = null;
                if (this.checker != null) {
                    Throwable throwable;
                    bos = new ByteArrayOutputStream();
                    if (_source.isFile()) {
                        this.copy(_source.getFilePath(), bos);
                    } else {
                        throwable = null;
                        try (InputStream ins = _source.open();){
                            this.copy(ins, bos, new CopyOption[0]);
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                    }
                    throwable = null;
                    try (OutputStream ops = this.target.open();){
                        this.copy((InputStream)new ByteArrayInputStream(bos.toByteArray()), ops, new CopyOption[0]);
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    this._validate(bos.toByteArray());
                    break block123;
                }
                if (_source.isFile()) {
                    try (OutputStream ops = this.target.open();){
                        this.copy(_source.getFilePath(), ops);
                        break block123;
                    }
                }
                try (InputStream ins = _source.open();
                     OutputStream ops = this.target.open();){
                    this.copy(ins, ops, new CopyOption[0]);
                }
            }
            catch (IOException ex) {
                this._LOGOP(this.session).level(Level.CONFIG).verb(NutsLogVerb.FAIL).log("error copying {0} to {1} : {2}", new Object[]{_source.getSource(), this.target.getSource(), ex});
                throw new UncheckedIOException(ex);
            }
        }
    }

    private void _validate(Path temp) {
        if (this.checker != null) {
            try (InputStream in = Files.newInputStream(temp, new OpenOption[0]);){
                this.checker.validate(in);
            }
            catch (NutsIOCopyValidationException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new NutsIOCopyValidationException(this.session, NutsMessage.cstyle((String)"validate file %s failed", (Object[])new Object[]{temp}), (Throwable)ex);
            }
        }
    }

    private void _validate(byte[] temp) {
        if (this.checker != null) {
            try (ByteArrayInputStream in = new ByteArrayInputStream(temp);){
                this.checker.validate((InputStream)in);
            }
            catch (NutsIOCopyValidationException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new NutsIOCopyValidationException(this.session, NutsMessage.cstyle((String)"validate file failed", (Object[])new Object[0]), (Throwable)ex);
            }
        }
    }

    private static class CopyData {
        long files;
        long folders;
        long doneFiles;
        long doneFolders;

        private CopyData() {
        }
    }
}

