/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.thevpc.nuts.NutsIOCompressAction;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInput;
import net.thevpc.nuts.NutsInputAction;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLogger;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsOutput;
import net.thevpc.nuts.NutsOutputAction;
import net.thevpc.nuts.NutsProgressFactory;
import net.thevpc.nuts.NutsProgressMonitor;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedArgumentException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.SingletonNutsInputStreamProgressFactory;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsIOCompressAction
implements NutsIOCompressAction {
    private final NutsLogger LOG;
    private boolean safe = true;
    private boolean logProgress = false;
    private List<NutsInput> sources = new ArrayList<NutsInput>();
    private NutsOutput target;
    private NutsWorkspace ws;
    private NutsSession session;
    private boolean skipRoot;
    private NutsProgressFactory progressMonitorFactory;
    private String format = "zip";

    public DefaultNutsIOCompressAction(NutsWorkspace ws) {
        this.ws = ws;
        this.LOG = ws.log().of(DefaultNutsIOCompressAction.class);
    }

    protected NutsInputAction _input() {
        this.checkSession();
        return this.ws.io().input().setSession(this.getSession());
    }

    protected NutsOutputAction _output() {
        this.checkSession();
        return this.ws.io().output().setSession(this.getSession());
    }

    public List<Object> getSources() {
        return this.sources;
    }

    public NutsIOCompressAction addSource(InputStream source) {
        this.sources.add(this._input().of(source));
        return this;
    }

    public NutsIOCompressAction addSource(File source) {
        this.sources.add(this._input().of(source));
        return this;
    }

    public NutsIOCompressAction addSource(Path source) {
        this.sources.add(this._input().of(source));
        return this;
    }

    public NutsIOCompressAction addSource(URL source) {
        this.sources.add(this._input().of(source));
        return this;
    }

    public NutsIOCompressAction setTarget(NutsOutput target) {
        this.target = target;
        return this;
    }

    public NutsIOCompressAction setTarget(OutputStream target) {
        this.target = this._output().of(target);
        return this;
    }

    public NutsIOCompressAction setTarget(Path target) {
        this.target = this._output().of(target);
        return this;
    }

    public NutsIOCompressAction setTarget(File target) {
        this.target = this._output().of(target);
        return this;
    }

    public NutsIOCompressAction setTarget(String target) {
        this.target = this._output().of(target);
        return this;
    }

    public NutsIOCompressAction addSource(Object source) {
        this.sources.add(this._input().of(source));
        return this;
    }

    public NutsIOCompressAction addSource(String source) {
        this.sources.add(this._input().of(source));
        return this;
    }

    public NutsIOCompressAction to(NutsOutput target) {
        return this.setTarget(target);
    }

    public NutsIOCompressAction to(Object target) {
        return this.setTarget(target);
    }

    public NutsIOCompressAction to(String target) {
        return this.setTarget(target);
    }

    public Object getTarget() {
        return this.target;
    }

    public NutsIOCompressAction setTarget(Object target) {
        this.target = this._output().of(target);
        return this;
    }

    public boolean isLogProgress() {
        return this.logProgress;
    }

    public DefaultNutsIOCompressAction setLogProgress(boolean value) {
        this.logProgress = value;
        return this;
    }

    public NutsIOCompressAction to(File target) {
        return this.setTarget(target);
    }

    public NutsIOCompressAction to(OutputStream target) {
        return this.setTarget(target);
    }

    public NutsIOCompressAction to(Path target) {
        return this.setTarget(target);
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsIOCompressAction setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public NutsIOCompressAction run() {
        this.checkSession();
        switch (this.getFormat()) {
            case "zip": 
            case "gzip": 
            case "gz": {
                this.runZip();
                break;
            }
            default: {
                throw new NutsUnsupportedArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported compression format %s", (Object[])new Object[]{this.getFormat()}));
            }
        }
        return this;
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runZip() {
        block22: {
            this.checkSession();
            if (this.sources.isEmpty()) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing source", (Object[])new Object[0]));
            }
            if (this.target == null) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"missing target", (Object[])new Object[0]));
            }
            if (this.isLogProgress() || this.getProgressMonitorFactory() != null) {
                // empty if block
            }
            this.LOG.with().session(this.session).level(Level.FINEST).verb(NutsLogVerb.START).log("compress {0} to {1}", new Object[]{this.sources, this.target});
            try {
                OutputStream fW = null;
                ZipOutputStream zip = null;
                if (this.target.isPath()) {
                    Path path;
                    Path tempPath;
                    block21: {
                        tempPath = null;
                        if (this.isSafe()) {
                            tempPath = Paths.get(this.ws.io().tmp().setSession(this.session).createTempFile("zip"), new String[0]);
                        }
                        path = this.target.getFilePath();
                        CoreIOUtils.mkdirs(path.getParent());
                        fW = tempPath == null ? this.target.open() : Files.newOutputStream(tempPath, new OpenOption[0]);
                        try {
                            try {
                                zip = new ZipOutputStream(fW);
                                if (this.skipRoot) {
                                    for (NutsInput s : this.sources) {
                                        Item file1 = new Item(s);
                                        if (file1.isDirectory()) {
                                            for (Item c : file1.list()) {
                                                this.add("", c, zip);
                                            }
                                            continue;
                                        }
                                        this.add("", file1, zip);
                                    }
                                    break block21;
                                }
                                for (NutsInput s : this.sources) {
                                    this.add("", new Item(s), zip);
                                }
                            }
                            finally {
                                if (zip != null) {
                                    zip.close();
                                }
                            }
                        }
                        finally {
                            if (fW != null) {
                                fW.close();
                            }
                        }
                    }
                    if (tempPath != null) {
                        Files.move(tempPath, path, StandardCopyOption.REPLACE_EXISTING);
                    }
                    break block22;
                }
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported target %s", (Object[])new Object[]{this.target}));
            }
            catch (IOException ex) {
                this.LOG.with().session(this.session).level(Level.CONFIG).verb(NutsLogVerb.FAIL).log("error compressing {0} to {1} : {2}", new Object[]{this.sources, this.target.getSource(), ex});
                throw new UncheckedIOException(ex);
            }
        }
    }

    public NutsProgressFactory getProgressMonitorFactory() {
        return this.progressMonitorFactory;
    }

    public NutsIOCompressAction setProgressMonitorFactory(NutsProgressFactory value) {
        this.progressMonitorFactory = value;
        return this;
    }

    public NutsIOCompressAction setProgressMonitor(NutsProgressMonitor value) {
        this.progressMonitorFactory = value == null ? null : new SingletonNutsInputStreamProgressFactory(value);
        return this;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public NutsIOCompressAction setSafe(boolean value) {
        this.safe = value;
        return this;
    }

    private void add(String path, Item srcFolder, ZipOutputStream zip) {
        if (srcFolder.isDirectory()) {
            this.addFolderToZip(path, srcFolder, zip);
        } else {
            this.addFileToZip(path, srcFolder, zip, false);
        }
    }

    private void addFolderToZip(String path, Item srcFolder, ZipOutputStream zip) throws UncheckedIOException {
        Item[] dirChildren = srcFolder.list();
        if (dirChildren.length == 0) {
            this.addFileToZip(path, srcFolder, zip, true);
        } else {
            for (Item c : dirChildren) {
                if (path.equals("")) {
                    this.addFileToZip(srcFolder.getName(), c, zip, false);
                    continue;
                }
                this.addFileToZip(DefaultNutsIOCompressAction.concatPath(path, c.getName()), c, zip, false);
            }
        }
    }

    private static String concatPath(String a, String b) {
        if (a.endsWith("/")) {
            if (b.startsWith("/")) {
                return a + b.substring(1);
            }
            return a + b;
        }
        if (b.startsWith("/")) {
            return a + b;
        }
        return a + "/" + b;
    }

    private void addFileToZip(String path, Item srcFile, ZipOutputStream zip, boolean flag) throws UncheckedIOException {
        String pathPrefix = path;
        if (!pathPrefix.endsWith("/")) {
            pathPrefix = pathPrefix + "/";
        }
        if (!pathPrefix.startsWith("/")) {
            pathPrefix = "/" + pathPrefix;
        }
        try {
            if (flag) {
                zip.putNextEntry(new ZipEntry(pathPrefix + srcFile.getName() + "/"));
            } else if (srcFile.isDirectory()) {
                this.addFolderToZip(pathPrefix, srcFile, zip);
            } else {
                int len;
                byte[] buf = new byte[1024];
                InputStream in = srcFile.open();
                zip.putNextEntry(new ZipEntry(pathPrefix + srcFile.getName()));
                while ((len = in.read(buf)) > 0) {
                    zip.write(buf, 0, len);
                }
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public boolean isSkipRoot() {
        return this.skipRoot;
    }

    public NutsIOCompressAction setSkipRoot(boolean value) {
        this.skipRoot = true;
        return this;
    }

    public NutsIOCompressAction setFormatOption(String option, Object value) {
        return this;
    }

    public Object getFormatOption(String option) {
        return null;
    }

    public String getFormat() {
        return this.format;
    }

    public NutsIOCompressAction setFormat(String format) {
        this.checkSession();
        if (NutsUtilStrings.isBlank((CharSequence)format)) {
            format = "zip";
        }
        switch (format) {
            case "zip": 
            case "gzip": 
            case "gz": {
                this.format = format;
                break;
            }
            default: {
                throw new NutsUnsupportedArgumentException(this.getSession(), NutsMessage.cstyle((String)"unsupported compression format %s", (Object[])new Object[]{format}));
            }
        }
        return this;
    }

    private static class Item {
        private Object o;

        public Item(Object value) {
            this.o = value;
        }

        public boolean isDirectory() {
            NutsInput s;
            if (this.o instanceof File) {
                return ((File)this.o).isDirectory();
            }
            if (this.o instanceof Path) {
                return Files.isDirectory((Path)this.o, new LinkOption[0]);
            }
            if (this.o instanceof NutsInput && (s = (NutsInput)this.o).isFile()) {
                return Files.isDirectory(s.getFilePath(), new LinkOption[0]);
            }
            return false;
        }

        private Item[] list() {
            NutsInput s;
            Path o1;
            if (this.o instanceof File) {
                File[] g = ((File)this.o).listFiles();
                if (g == null) {
                    return new Item[0];
                }
                return (Item[])Arrays.stream(g).map(Item::new).toArray(Item[]::new);
            }
            if (this.o instanceof Path && Files.isDirectory(o1 = (Path)this.o, new LinkOption[0])) {
                try {
                    return (Item[])Files.list(o1).map(Item::new).toArray(Item[]::new);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            if (this.o instanceof NutsInput && (s = (NutsInput)this.o).isFile()) {
                Path o12 = s.getFilePath();
                try {
                    return (Item[])Files.list(o12).map(Item::new).toArray(Item[]::new);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            return new Item[0];
        }

        public InputStream open() {
            if (this.o instanceof File) {
                try {
                    return new FileInputStream((File)this.o);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            if (this.o instanceof Path) {
                try {
                    return Files.newInputStream((Path)this.o, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            if (this.o instanceof NutsInput) {
                NutsInput s = (NutsInput)this.o;
                return s.open();
            }
            throw new UncheckedIOException(new IOException("Unsupported type " + this.o));
        }

        public String getName() {
            if (this.o instanceof File) {
                return ((File)this.o).getName();
            }
            if (this.o instanceof Path) {
                return ((Path)this.o).getFileName().toString();
            }
            if (this.o instanceof NutsInput) {
                NutsInput s = (NutsInput)this.o;
                return s.getFilePath().getFileName().toString();
            }
            return "";
        }
    }
}

