/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.thevpc.nuts.NutsExecutionEntry;
import net.thevpc.nuts.NutsExecutionEntryAction;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class DefaultNutsExecutionEntryAction
implements NutsExecutionEntryAction {
    private NutsWorkspace ws;
    private NutsSession session;

    public DefaultNutsExecutionEntryAction(NutsWorkspace ws) {
        this.ws = ws;
    }

    public NutsExecutionEntry[] parse(File file) {
        return this.parse(file.toPath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NutsExecutionEntry[] parse(Path file) {
        if (file.getFileName().toString().toLowerCase().endsWith(".jar")) {
            try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
                NutsExecutionEntry[] nutsExecutionEntryArray = this.parse(in, "java", file.toAbsolutePath().normalize().toString());
                return nutsExecutionEntryArray;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        if (!file.getFileName().toString().toLowerCase().endsWith(".class")) return new NutsExecutionEntry[0];
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            NutsExecutionEntry[] nutsExecutionEntryArray = this.parse(in, "class", file.toAbsolutePath().normalize().toString());
            return nutsExecutionEntryArray;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public NutsExecutionEntry[] parse(InputStream inputStream, String type, String sourceName) {
        if ("java".equals(type)) {
            return NutsWorkspaceUtils.of(this.getSession()).parseJarExecutionEntries(inputStream, sourceName);
        }
        if ("class".equals(type)) {
            NutsExecutionEntry[] nutsExecutionEntryArray;
            NutsExecutionEntry u = NutsWorkspaceUtils.of(this.getSession()).parseClassExecutionEntry(inputStream, sourceName);
            if (u == null) {
                nutsExecutionEntryArray = new NutsExecutionEntry[]{};
            } else {
                NutsExecutionEntry[] nutsExecutionEntryArray2 = new NutsExecutionEntry[1];
                nutsExecutionEntryArray = nutsExecutionEntryArray2;
                nutsExecutionEntryArray2[0] = u;
            }
            return nutsExecutionEntryArray;
        }
        return new NutsExecutionEntry[0];
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsExecutionEntryAction setSession(NutsSession session) {
        this.session = session;
        return this;
    }
}

