/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.util.Objects;
import net.thevpc.nuts.NutsExecutionEntry;
import net.thevpc.nuts.NutsUtilStrings;

public class DefaultNutsExecutionEntry
implements NutsExecutionEntry {
    private final String name;
    private final boolean defaultEntry;
    private final boolean app;

    public DefaultNutsExecutionEntry(String name, boolean defaultEntry, boolean app) {
        if (NutsUtilStrings.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("empty name");
        }
        this.name = name;
        this.defaultEntry = defaultEntry;
        this.app = app;
    }

    public boolean isApp() {
        return this.app;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefaultEntry() {
        return this.defaultEntry;
    }

    public String toString() {
        return "NutsExecutionEntry{name='" + this.name + '\'' + ", app=" + this.app + ", defaultEntry=" + this.defaultEntry + '}';
    }

    public int compareTo(NutsExecutionEntry o) {
        if (o == null) {
            return 1;
        }
        int x = this.name.compareTo(o.getName());
        if (x != 0) {
            return x;
        }
        x = Boolean.compare(this.defaultEntry, o.isDefaultEntry());
        if (x != 0) {
            return x;
        }
        x = Boolean.compare(this.app, o.isApp());
        if (x != 0) {
            return x;
        }
        return 0;
    }

    public int hashCode() {
        int hash = 5;
        hash = 17 * hash + Objects.hashCode(this.name);
        hash = 17 * hash + (this.defaultEntry ? 1 : 0);
        hash = 17 * hash + (this.app ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NutsExecutionEntry)) {
            return false;
        }
        NutsExecutionEntry other = (NutsExecutionEntry)obj;
        if (this.defaultEntry != other.isDefaultEntry()) {
            return false;
        }
        if (this.app != other.isApp()) {
            return false;
        }
        return Objects.equals(this.name, other.getName());
    }
}

