/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSingleton;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsUnsupportedOperationException;
import net.thevpc.nuts.spi.NutsTransportComponent;
import net.thevpc.nuts.spi.NutsTransportConnection;
import net.thevpc.nuts.spi.NutsTransportParamPart;

@NutsSingleton
public class DefaultHttpTransportComponent
implements NutsTransportComponent {
    public static final NutsTransportComponent INSTANCE = new DefaultHttpTransportComponent();
    private NutsSession session;

    public int getSupportLevel(NutsSupportLevelContext<String> url) {
        this.session = url.getSession();
        return 10;
    }

    public NutsTransportConnection open(String url) throws UncheckedIOException {
        try {
            return new DefaultNutsTransportConnection(new URL(url), this.session);
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class DefaultNutsTransportConnection
    implements NutsTransportConnection {
        private final URL url;
        private final NutsSession session;

        public DefaultNutsTransportConnection(URL url, NutsSession session) {
            this.url = url;
            this.session = session;
        }

        public InputStream open() {
            try {
                return this.url.openStream();
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        public NutsPath getPath() {
            return this.session.getWorkspace().io().path(this.url);
        }

        public InputStream upload(NutsTransportParamPart ... parts) {
            throw new NutsUnsupportedOperationException(this.session, NutsMessage.cstyle((String)"upload unsupported", (Object[])new Object[0]));
        }

        public String toString() {
            return String.valueOf(this.url);
        }
    }
}

