/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLock;
import net.thevpc.nuts.NutsLockAcquireException;
import net.thevpc.nuts.NutsLockBarrierException;
import net.thevpc.nuts.NutsLockReleaseException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedOperationException;
import net.thevpc.nuts.runtime.core.common.TimePeriod;
import net.thevpc.nuts.runtime.core.util.CoreIOUtils;

public class DefaultFileNutsLock
implements NutsLock {
    private static TimePeriod FIVE_MINUTES = new TimePeriod(5L, TimeUnit.MINUTES);
    private Path path;
    private Object lockedObject;
    private NutsSession session;

    public DefaultFileNutsLock(Path path, Object lockedObject, NutsSession session) {
        this.path = path;
        this.lockedObject = lockedObject;
        this.session = session;
    }

    public TimePeriod getDefaultTimePeriod() {
        TimePeriod tp = TimePeriod.parse(this.session.getWorkspace().env().getEnv("DEFAULT_LOCK_PERIOD", null), true, TimeUnit.SECONDS);
        if (tp == null) {
            return FIVE_MINUTES;
        }
        return tp;
    }

    public void lockInterruptibly() throws InterruptedException {
        TimePeriod tp = this.getDefaultTimePeriod();
        if (!this.tryLockInterruptibly(tp.getUnitCount(), tp.getUnit())) {
            throw new NutsLockAcquireException(this.session, null, this.lockedObject, (Object)this, null);
        }
    }

    public synchronized void lock() {
        TimePeriod tp = this.getDefaultTimePeriod();
        if (!this.tryLock(tp.getUnitCount(), tp.getUnit())) {
            throw new NutsLockAcquireException(this.session, null, this.lockedObject, (Object)this, null);
        }
    }

    public void checkFree() {
        if (!this.isFree()) {
            throw new NutsLockBarrierException(this.session, null, this.lockedObject, (Object)this);
        }
    }

    public synchronized boolean isFree() {
        return !Files.exists(this.path, new LinkOption[0]);
    }

    public synchronized void unlock() {
        try {
            Files.delete(this.path);
        }
        catch (IOException ex) {
            throw new NutsLockReleaseException(this.session, null, this.lockedObject, (Object)this, (Throwable)ex);
        }
    }

    public boolean tryLock() {
        return this.tryLockImmediately();
    }

    public boolean tryLock(TimePeriod p) {
        return this.tryLock(p.getUnitCount(), p.getUnit());
    }

    private PollTime preferredPollTime(long time, TimeUnit unit) {
        long timeMs = 0L;
        if (time <= 0L) {
            timeMs = Long.MAX_VALUE;
        } else {
            switch (unit) {
                case NANOSECONDS: {
                    timeMs = time / 1000000L;
                    if (timeMs > 0L) break;
                    timeMs = 1L;
                    break;
                }
                case MICROSECONDS: {
                    timeMs = time / 1000L;
                    if (timeMs > 0L) break;
                    timeMs = 1L;
                    break;
                }
                case MILLISECONDS: {
                    timeMs = time;
                    break;
                }
                case SECONDS: {
                    timeMs = time * 1000L;
                    break;
                }
                case MINUTES: {
                    timeMs = time * 1000L * 60L;
                    break;
                }
                case HOURS: {
                    timeMs = time * 1000L * 3600L;
                    break;
                }
                case DAYS: {
                    timeMs = time * 1000L * 3600L * 24L;
                }
            }
        }
        long minTimeToSleep = timeMs / 10L;
        if (timeMs < 200L) {
            timeMs = 200L;
        }
        return new PollTime(timeMs, minTimeToSleep);
    }

    public synchronized boolean tryLock(long time, TimeUnit unit) {
        if (unit == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing unit", (Object[])new Object[0]));
        }
        long now = System.currentTimeMillis();
        PollTime ptime = this.preferredPollTime(time, unit);
        while (true) {
            if (this.tryLockImmediately()) {
                return true;
            }
            if (System.currentTimeMillis() - now > ptime.timeMs) break;
            try {
                Thread.sleep(ptime.minTimeToSleep);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public synchronized boolean tryLockInterruptibly(long time, TimeUnit unit) throws InterruptedException {
        if (unit == null) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing unit", (Object[])new Object[0]));
        }
        long now = System.currentTimeMillis();
        PollTime ptime = this.preferredPollTime(time, unit);
        while (true) {
            if (this.tryLockImmediatelyInterruptibly()) {
                return true;
            }
            if (System.currentTimeMillis() - now > ptime.timeMs) break;
            try {
                Thread.sleep(ptime.minTimeToSleep);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public boolean tryLockImmediatelyInterruptibly() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.tryLockImmediately();
    }

    public boolean tryLockImmediately() {
        try {
            if (!Files.exists(this.path, new LinkOption[0])) {
                Path p = this.path.getParent();
                CoreIOUtils.mkdirs(p);
                Files.createFile(this.path, new FileAttribute[0]);
                return true;
            }
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public Condition newCondition() {
        throw new NutsUnsupportedOperationException(this.session, NutsMessage.cstyle((String)"unsupported Lock.newCondition", (Object[])new Object[0]));
    }

    private class PollTime {
        long timeMs;
        long minTimeToSleep;

        public PollTime(long timeMs, long minTimeToSleep) {
            this.timeMs = timeMs;
            this.minTimeToSleep = minTimeToSleep;
        }
    }
}

