/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.File;
import java.nio.file.Path;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsIODeleteAction;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public abstract class AbstractNutsIODeleteAction
implements NutsIODeleteAction {
    private NutsWorkspace ws;
    private Object target;
    private NutsSession session;
    private boolean failFast;

    public AbstractNutsIODeleteAction(NutsWorkspace ws) {
        this.ws = ws;
    }

    protected void checkSession() {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsIODeleteAction setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    public NutsWorkspace getWs() {
        return this.ws;
    }

    public Object getTarget() {
        return this.target;
    }

    public NutsIODeleteAction setTarget(Object target) {
        NutsWorkspaceUtils.checkSession(this.ws, this.session);
        if (target == null) {
            this.target = null;
            return this;
        }
        if (target instanceof File) {
            return this.setTarget((File)target);
        }
        if (target instanceof Path) {
            return this.setTarget((Path)target);
        }
        throw new NutsException(this.session, NutsMessage.cstyle((String)"unsupported delete %s", (Object[])new Object[]{target}));
    }

    public NutsIODeleteAction setTarget(File target) {
        this.target = target;
        return this;
    }

    public NutsIODeleteAction setTarget(Path target) {
        this.target = target;
        return this;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public NutsIODeleteAction setFailFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }
}

