/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.installers;

import java.io.IOException;
import java.io.UncheckedIOException;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsExecutionContext;
import net.thevpc.nuts.NutsInstallerComponent;
import net.thevpc.nuts.NutsSingleton;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.runtime.bundles.io.UnzipOptions;
import net.thevpc.nuts.runtime.bundles.io.ZipUtils;
import net.thevpc.nuts.runtime.core.NutsWorkspaceExt;
import net.thevpc.nuts.runtime.core.model.DefaultNutsDefinition;

@NutsSingleton
public class ZipInstallerComponent
implements NutsInstallerComponent {
    public int getSupportLevel(NutsSupportLevelContext<NutsDefinition> nutsDefinition) {
        if (nutsDefinition != null && ((NutsDefinition)nutsDefinition.getConstraints()).getDescriptor() != null && "zip".equals(((NutsDefinition)nutsDefinition.getConstraints()).getDescriptor().getPackaging())) {
            return 10;
        }
        return -1;
    }

    public void install(NutsExecutionContext executionContext) {
        DefaultNutsDefinition nutsDefinition = (DefaultNutsDefinition)executionContext.getDefinition();
        String installFolder = executionContext.getWorkspace().locations().getStoreLocation(nutsDefinition.getId(), NutsStoreLocation.APPS);
        String skipRoot = (String)executionContext.getExecutorProperties().get("unzip-skip-root");
        try {
            ZipUtils.unzip(executionContext.getTraceSession(), nutsDefinition.getPath().toString(), installFolder, new UnzipOptions().setSkipRoot("true".equalsIgnoreCase(skipRoot)));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        nutsDefinition.setInstallInformation(NutsWorkspaceExt.of(executionContext.getWorkspace()).getInstalledRepository().getInstallInformation(nutsDefinition.getId(), executionContext.getExecSession()));
        if (executionContext.getExecutorArguments().length > 0) {
            executionContext.getWorkspace().exec().addCommand(executionContext.getExecutorArguments()).setSession(executionContext.getExecSession()).setEnv(executionContext.getExecutorProperties()).setDirectory(installFolder.toString()).getResult();
        }
    }

    public void update(NutsExecutionContext executionContext) {
    }

    public void uninstall(NutsExecutionContext executionContext, boolean deleteData) {
    }
}

