/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.installers;

import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsExecutionContext;
import net.thevpc.nuts.NutsExecutionEntry;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsInstallerComponent;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSupportLevelContext;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.core.model.DefaultNutsDefinition;
import net.thevpc.nuts.runtime.standalone.DefaultNutsInstallInfo;
import net.thevpc.nuts.runtime.standalone.util.NutsWorkspaceUtils;

public class CommandForIdNutsInstallerComponent
implements NutsInstallerComponent {
    private String getNutsVersion(NutsExecutionContext executionContext) {
        NutsDescriptor descriptor = executionContext.getDefinition().getDescriptor();
        if (descriptor.isApplication()) {
            for (NutsDependency dependency : descriptor.getDependencies()) {
                if (!dependency.toId().getShortName().equals("net.thevpc.nuts:nuts")) continue;
                return dependency.toId().getVersion().getValue();
            }
        }
        for (NutsDependency dependency : executionContext.getDefinition().getDependencies()) {
            if (!dependency.toId().getShortName().equals("net.thevpc.nuts:nuts")) continue;
            return dependency.toId().getVersion().getValue();
        }
        return null;
    }

    public void install(NutsExecutionContext executionContext) {
        NutsWorkspaceUtils.of(executionContext.getTraceSession()).checkReadOnly();
        NutsDescriptor descriptor = executionContext.getDefinition().getDescriptor();
        if (descriptor.isApplication()) {
            DefaultNutsDefinition def2 = new DefaultNutsDefinition(executionContext.getDefinition(), executionContext.getTraceSession()).setInstallInformation(new DefaultNutsInstallInfo(executionContext.getDefinition().getInstallInformation()).setInstallStatus(executionContext.getDefinition().getInstallInformation().getInstallStatus().withInstalled(true)));
            executionContext.getWorkspace().exec().setSession(executionContext.getExecSession()).setCommand((NutsDefinition)def2).addCommand(new String[]{"--nuts-exec-mode=install"}).addExecutorOptions(new String[]{"--nuts-auto-install=false"}).addCommand(executionContext.getArguments()).setExecutionType(executionContext.getWorkspace().env().getBootOptions().getExecutionType()).setFailFast(true).run();
        }
    }

    public void update(NutsExecutionContext executionContext) {
        NutsWorkspaceUtils.of(executionContext.getTraceSession()).checkReadOnly();
        NutsDescriptor descriptor = executionContext.getDefinition().getDescriptor();
        if (descriptor.isApplication()) {
            DefaultNutsDefinition def2 = new DefaultNutsDefinition(executionContext.getDefinition(), executionContext.getTraceSession()).setInstallInformation(new DefaultNutsInstallInfo(executionContext.getDefinition().getInstallInformation()).setInstallStatus(executionContext.getDefinition().getInstallInformation().getInstallStatus().withInstalled(true)));
            executionContext.getWorkspace().exec().setCommand((NutsDefinition)def2).addCommand(new String[]{"--nuts-exec-mode=update", "--yes"}).addExecutorOptions(new String[0]).addCommand(executionContext.getArguments()).setFailFast(true).run();
        }
    }

    public void uninstall(NutsExecutionContext executionContext, boolean deleteData) {
        NutsSession session = executionContext.getExecSession();
        NutsWorkspace ws = executionContext.getWorkspace();
        NutsWorkspaceUtils.of(executionContext.getTraceSession()).checkReadOnly();
        NutsId id = executionContext.getDefinition().getId();
        if ("jar".equals(executionContext.getDefinition().getDescriptor().getPackaging())) {
            NutsExecutionEntry[] executionEntries;
            for (NutsExecutionEntry executionEntry : executionEntries = ws.apps().execEntries().parse(executionContext.getDefinition().getPath())) {
                if (!executionEntry.isApp()) continue;
                int r = ws.exec().addCommand(new String[]{id.getLongName(), "--nuts-exec-mode=uninstall", "--yes"}).addCommand(executionContext.getArguments()).getResult();
                if (r != 0) {
                    session.out().printf("installation exited with code : " + r + " %n", new Object[0]);
                }
                return;
            }
        }
    }

    public int getSupportLevel(NutsSupportLevelContext<NutsDefinition> criteria) {
        return 10;
    }
}

