/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.index;

import java.util.stream.Stream;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDB;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBDefaultIndexDefinition;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBTableDefinition;
import net.thevpc.nuts.runtime.bundles.nanodb.NanoDBTableFile;
import net.thevpc.nuts.runtime.standalone.index.CacheDB;

public class ArtifactsIndexDB {
    public static final String DEFAULT_ARTIFACT_TABLE_NAME = "Artifacts";
    private NanoDBTableFile<NutsId> table;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArtifactsIndexDB of(NutsWorkspace ws) {
        NutsWorkspace nutsWorkspace = ws;
        synchronized (nutsWorkspace) {
            ArtifactsIndexDB o = (ArtifactsIndexDB)ws.env().getProperties().get(ArtifactsIndexDB.class.getName());
            if (o == null) {
                o = new ArtifactsIndexDB(DEFAULT_ARTIFACT_TABLE_NAME, CacheDB.of(ws));
                ws.env().getProperties().put(ArtifactsIndexDB.class.getName(), o);
            }
            return o;
        }
    }

    public ArtifactsIndexDB(String tableName, NanoDB db) {
        this.table = db.createTable(ArtifactsIndexDB.def(tableName, db), true);
    }

    public Stream<NutsId> findAll() {
        return this.table.stream();
    }

    public Stream<NutsId> findByGroupId(String groupId) {
        return this.table.findByIndex("groupId", groupId);
    }

    public Stream<NutsId> findByArtifactId(String artifactId) {
        return this.table.findByIndex("artifactId", artifactId);
    }

    private static NanoDBTableDefinition<NutsId> def(String name, NanoDB db) {
        return new NanoDBTableDefinition<NutsId>(name, NutsId.class, db.getSerializers().of(NutsId.class, false), new NanoDBDefaultIndexDefinition<NutsId>("id", String.class, false, x -> x.getLongNameId().builder().setRepository(x.getRepository()).build().toString()), new NanoDBDefaultIndexDefinition<NutsId>("groupId", String.class, false, NutsId::getGroupId), new NanoDBDefaultIndexDefinition<NutsId>("artifactId", String.class, false, NutsId::getArtifactId), new NanoDBDefaultIndexDefinition<NutsId>("repository", String.class, false, NutsId::getRepository));
    }

    public void add(NutsId id) {
        this.table.add(id);
    }

    public void flush() {
        this.table.flush();
    }

    public boolean contains(NutsId id) {
        return this.table.findByIndex("id", id.getLongNameId().builder().setRepository(id.getRepository()).build().toDependency()).findAny().orElse(null) != null;
    }
}

